/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.json;

import camundajar.impl.com.google.gson.JsonObject;
import org.cibseven.bpm.engine.impl.json.JsonObjectConverter;
import org.cibseven.bpm.engine.impl.migration.MigrationInstructionImpl;
import org.cibseven.bpm.engine.impl.util.JsonUtil;
import org.cibseven.bpm.engine.migration.MigrationInstruction;

public class MigrationInstructionJsonConverter
extends JsonObjectConverter<MigrationInstruction> {
    public static final MigrationInstructionJsonConverter INSTANCE = new MigrationInstructionJsonConverter();
    public static final String SOURCE_ACTIVITY_IDS = "sourceActivityIds";
    public static final String TARGET_ACTIVITY_IDS = "targetActivityIds";
    public static final String UPDATE_EVENT_TRIGGER = "updateEventTrigger";

    @Override
    public JsonObject toJsonObject(MigrationInstruction instruction) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addArrayField(json, SOURCE_ACTIVITY_IDS, new String[]{instruction.getSourceActivityId()});
        JsonUtil.addArrayField(json, TARGET_ACTIVITY_IDS, new String[]{instruction.getTargetActivityId()});
        JsonUtil.addField(json, UPDATE_EVENT_TRIGGER, instruction.isUpdateEventTrigger());
        return json;
    }

    @Override
    public MigrationInstruction toObject(JsonObject json) {
        return new MigrationInstructionImpl(this.readSourceActivityId(json), this.readTargetActivityId(json), JsonUtil.getBoolean(json, UPDATE_EVENT_TRIGGER));
    }

    protected String readSourceActivityId(JsonObject json) {
        return JsonUtil.getString(JsonUtil.getArray(json, SOURCE_ACTIVITY_IDS));
    }

    protected String readTargetActivityId(JsonObject json) {
        return JsonUtil.getString(JsonUtil.getArray(json, TARGET_ACTIVITY_IDS));
    }
}

