/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.json;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.List;
import org.cibseven.bpm.engine.impl.QueryEntityRelationCondition;
import org.cibseven.bpm.engine.impl.QueryPropertyImpl;
import org.cibseven.bpm.engine.impl.json.JsonArrayConverter;
import org.cibseven.bpm.engine.impl.json.JsonArrayOfObjectsConverter;
import org.cibseven.bpm.engine.impl.json.JsonObjectConverter;
import org.cibseven.bpm.engine.impl.util.JsonUtil;
import org.cibseven.bpm.engine.query.QueryProperty;

public class JsonQueryFilteringPropertyConverter
extends JsonObjectConverter<QueryEntityRelationCondition> {
    protected static JsonQueryFilteringPropertyConverter INSTANCE = new JsonQueryFilteringPropertyConverter();
    protected static JsonArrayConverter<List<QueryEntityRelationCondition>> ARRAY_CONVERTER = new JsonArrayOfObjectsConverter<QueryEntityRelationCondition>(INSTANCE);
    public static final String BASE_PROPERTY = "baseField";
    public static final String COMPARISON_PROPERTY = "comparisonField";
    public static final String SCALAR_VALUE = "value";

    @Override
    public JsonObject toJsonObject(QueryEntityRelationCondition filteringProperty) {
        Object scalarValue;
        JsonObject jsonObject = JsonUtil.createObject();
        JsonUtil.addField(jsonObject, BASE_PROPERTY, filteringProperty.getProperty().getName());
        QueryProperty comparisonProperty = filteringProperty.getComparisonProperty();
        if (comparisonProperty != null) {
            JsonUtil.addField(jsonObject, COMPARISON_PROPERTY, comparisonProperty.getName());
        }
        if ((scalarValue = filteringProperty.getScalarValue()) != null) {
            JsonUtil.addFieldRawValue(jsonObject, SCALAR_VALUE, scalarValue);
        }
        return jsonObject;
    }

    @Override
    public QueryEntityRelationCondition toObject(JsonObject jsonObject) {
        String scalarValue = null;
        if (jsonObject.has(SCALAR_VALUE)) {
            scalarValue = JsonUtil.getString(jsonObject, SCALAR_VALUE);
        }
        QueryPropertyImpl baseProperty = null;
        if (jsonObject.has(BASE_PROPERTY)) {
            baseProperty = new QueryPropertyImpl(JsonUtil.getString(jsonObject, BASE_PROPERTY));
        }
        QueryPropertyImpl comparisonProperty = null;
        if (jsonObject.has(COMPARISON_PROPERTY)) {
            comparisonProperty = new QueryPropertyImpl(JsonUtil.getString(jsonObject, COMPARISON_PROPERTY));
        }
        return new QueryEntityRelationCondition(baseProperty, comparisonProperty, scalarValue);
    }
}

