/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.jobexecutor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutor;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutorLogger;

public abstract class AcquireJobsRunnable
implements Runnable {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    protected final JobExecutor jobExecutor;
    protected volatile boolean isInterrupted = false;
    protected volatile boolean isJobAdded = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public AcquireJobsRunnable(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendAcquisition(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            LOG.debugJobAcquisitionThreadSleeping(millis);
            Object object = this.MONITOR;
            synchronized (object) {
                if (!this.isInterrupted) {
                    this.isWaiting.set(true);
                    this.MONITOR.wait(millis);
                }
            }
            LOG.jobExecutorThreadWokeUp();
        }
        catch (InterruptedException e) {
            LOG.jobExecutionWaitInterrupted();
        }
        finally {
            this.isWaiting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                this.MONITOR.notifyAll();
            }
        }
    }

    protected void clearJobAddedNotification() {
        this.isJobAdded = false;
    }

    public boolean isJobAdded() {
        return this.isJobAdded;
    }
}

