/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.form.type;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cibseven.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.cibseven.bpm.engine.impl.form.type.AbstractFormFieldType;
import org.cibseven.bpm.engine.impl.form.type.DateFormType;
import org.cibseven.bpm.engine.impl.form.type.EnumFormType;
import org.cibseven.bpm.engine.impl.util.xml.Element;

public class FormTypes {
    protected Map<String, AbstractFormFieldType> formTypes = new HashMap<String, AbstractFormFieldType>();

    public void addFormType(AbstractFormFieldType formType) {
        this.formTypes.put(formType.getName(), formType);
    }

    public AbstractFormFieldType parseFormPropertyType(Element formFieldElement, BpmnParse bpmnParse) {
        AbstractFormFieldType formType = null;
        String typeText = formFieldElement.attribute("type");
        String datePatternText = formFieldElement.attribute("datePattern");
        if (typeText == null && "formField".equals(formFieldElement.getTagName())) {
            bpmnParse.addError("form field must have a 'type' attribute", formFieldElement);
        }
        if ("date".equals(typeText) && datePatternText != null) {
            formType = new DateFormType(datePatternText);
        } else if ("enum".equals(typeText)) {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            for (Element valueElement : formFieldElement.elementsNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "value")) {
                String valueId = valueElement.attribute("id");
                String valueName = valueElement.attribute("name");
                values.put(valueId, valueName);
            }
            formType = new EnumFormType(values);
        } else if (typeText != null && (formType = this.formTypes.get(typeText)) == null) {
            bpmnParse.addError("unknown type '" + typeText + "'", formFieldElement);
        }
        return formType;
    }

    public AbstractFormFieldType getFormType(String name) {
        return this.formTypes.get(name);
    }
}

