/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.form.entity;

import java.util.HashMap;
import java.util.List;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.db.EnginePersistenceLogger;
import org.cibseven.bpm.engine.impl.db.ListQueryParameterObject;
import org.cibseven.bpm.engine.impl.persistence.AbstractManager;
import org.cibseven.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.cibseven.bpm.engine.impl.persistence.entity.CamundaFormDefinitionEntity;

public class CamundaFormDefinitionManager
extends AbstractManager
implements AbstractResourceDefinitionManager<CamundaFormDefinitionEntity> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public CamundaFormDefinitionEntity findLatestDefinitionByKey(String key) {
        List camundaFormDefinitions = this.getDbEntityManager().selectList("selectLatestCamundaFormDefinitionByKey", this.configureParameterizedQuery(key));
        if (camundaFormDefinitions.isEmpty()) {
            return null;
        }
        if (camundaFormDefinitions.size() == 1) {
            return (CamundaFormDefinitionEntity)camundaFormDefinitions.iterator().next();
        }
        throw LOG.multipleTenantsForCamundaFormDefinitionKeyException(key);
    }

    @Override
    public CamundaFormDefinitionEntity findLatestDefinitionById(String id) {
        return this.getDbEntityManager().selectById(CamundaFormDefinitionEntity.class, id);
    }

    @Override
    public CamundaFormDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("camundaFormDefinitionKey", definitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (CamundaFormDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestCamundaFormDefinitionByKeyWithoutTenantId", parameters);
        }
        return (CamundaFormDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestCamundaDefinitionByKeyAndTenantId", parameters);
    }

    @Override
    public CamundaFormDefinitionEntity findDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("camundaFormDefinitionVersion", definitionVersion);
        parameters.put("camundaFormDefinitionKey", definitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (CamundaFormDefinitionEntity)this.getDbEntityManager().selectOne("selectCamundaFormDefinitionByKeyVersionWithoutTenantId", parameters);
        }
        return (CamundaFormDefinitionEntity)this.getDbEntityManager().selectOne("selectCamundaFormDefinitionByKeyVersionAndTenantId", parameters);
    }

    @Override
    public CamundaFormDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("camundaFormDefinitionKey", definitionKey);
        return (CamundaFormDefinitionEntity)this.getDbEntityManager().selectOne("selectCamundaFormDefinitionByDeploymentAndKey", parameters);
    }

    public List<CamundaFormDefinitionEntity> findDefinitionsByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectCamundaFormDefinitionByDeploymentId", deploymentId);
    }

    @Override
    public CamundaFormDefinitionEntity getCachedResourceDefinitionEntity(String definitionId) {
        return this.getDbEntityManager().getCachedEntity(CamundaFormDefinitionEntity.class, definitionId);
    }

    @Override
    public CamundaFormDefinitionEntity findDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId) {
        throw new UnsupportedOperationException("Currently finding Camunda Form definition by version tag and tenant is not implemented.");
    }

    public void deleteCamundaFormDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(CamundaFormDefinitionEntity.class, "deleteCamundaFormDefinitionsByDeploymentId", deploymentId);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }
}

