/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.form.deployer;

import camundajar.impl.com.google.gson.Gson;
import camundajar.impl.com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.cibseven.bpm.engine.impl.AbstractDefinitionDeployer;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.core.model.Properties;
import org.cibseven.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.cibseven.bpm.engine.impl.persistence.entity.CamundaFormDefinitionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.cibseven.bpm.engine.impl.util.EngineUtilLogger;
import org.cibseven.bpm.engine.impl.util.JsonUtil;

public class CamundaFormDefinitionDeployer
extends AbstractDefinitionDeployer<CamundaFormDefinitionEntity> {
    protected static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    public static final String[] FORM_RESOURCE_SUFFIXES = new String[]{"form"};

    @Override
    protected String[] getResourcesSuffixes() {
        return FORM_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<CamundaFormDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        String formContent = new String(resource.getBytes(), StandardCharsets.UTF_8);
        try {
            JsonObject formJsonObject = new Gson().fromJson(formContent, JsonObject.class);
            String camundaFormDefinitionKey = JsonUtil.getString(formJsonObject, "id");
            CamundaFormDefinitionEntity definition = new CamundaFormDefinitionEntity(camundaFormDefinitionKey, deployment.getId(), resource.getName(), deployment.getTenantId());
            return Collections.singletonList(definition);
        }
        catch (Exception e) {
            if (!this.getCommandContext().getProcessEngineConfiguration().isDisableStrictCamundaFormParsing()) {
                throw LOG.exceptionDuringFormParsing(e.getMessage(), resource.getName());
            }
            return Collections.emptyList();
        }
    }

    @Override
    protected CamundaFormDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getCommandContext().getCamundaFormDefinitionManager().findDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected CamundaFormDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getCommandContext().getCamundaFormDefinitionManager().findLatestDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(CamundaFormDefinitionEntity definition) {
        this.getCommandContext().getCamundaFormDefinitionManager().insert(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, CamundaFormDefinitionEntity definition) {
        deploymentCache.addCamundaFormDefinition(definition);
    }
}

