/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.dmn.entity.repository;

import java.util.Collections;
import java.util.List;
import org.cibseven.bpm.engine.exception.NotValidException;
import org.cibseven.bpm.engine.impl.AbstractQuery;
import org.cibseven.bpm.engine.impl.Page;
import org.cibseven.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryProperty;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.repository.DecisionRequirementsDefinition;
import org.cibseven.bpm.engine.repository.DecisionRequirementsDefinitionQuery;

public class DecisionRequirementsDefinitionQueryImpl
extends AbstractQuery<DecisionRequirementsDefinitionQuery, DecisionRequirementsDefinition>
implements DecisionRequirementsDefinitionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected boolean latest = false;
    protected boolean isTenantIdSet = false;
    protected String[] tenantIds;
    protected boolean includeDefinitionsWithoutTenantId = false;

    public DecisionRequirementsDefinitionQueryImpl() {
    }

    public DecisionRequirementsDefinitionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionId(String id) {
        EnsureUtil.ensureNotNull(NotValidException.class, "id", (Object)id);
        this.id = id;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionIdIn(String ... ids) {
        this.ids = ids;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionCategory(String category) {
        EnsureUtil.ensureNotNull(NotValidException.class, "category", (Object)category);
        this.category = category;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionCategoryLike(String categoryLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "categoryLike", (Object)categoryLike);
        this.categoryLike = categoryLike;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionName(String name) {
        EnsureUtil.ensureNotNull(NotValidException.class, "name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionNameLike(String nameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "nameLike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionKey(String key) {
        EnsureUtil.ensureNotNull(NotValidException.class, "key", (Object)key);
        this.key = key;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionKeyLike(String keyLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "keyLike", (Object)keyLike);
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionVersion(Integer version) {
        EnsureUtil.ensureNotNull(NotValidException.class, "version", (Object)version);
        EnsureUtil.ensurePositive(NotValidException.class, "version", (Long)version.longValue());
        this.version = version;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery latestVersion() {
        this.latest = true;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionResourceName(String resourceName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceName", (Object)resourceName);
        this.resourceName = resourceName;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery decisionRequirementsDefinitionResourceNameLike(String resourceNameLike) {
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceNameLike", (Object)resourceNameLike);
        this.resourceNameLike = resourceNameLike;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantIds = null;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery includeDecisionRequirementsDefinitionsWithoutTenantId() {
        this.includeDefinitionsWithoutTenantId = true;
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByDecisionRequirementsDefinitionCategory() {
        this.orderBy(DecisionRequirementsDefinitionQueryProperty.DECISION_REQUIREMENTS_DEFINITION_CATEGORY);
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByDecisionRequirementsDefinitionKey() {
        this.orderBy(DecisionRequirementsDefinitionQueryProperty.DECISION_REQUIREMENTS_DEFINITION_KEY);
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByDecisionRequirementsDefinitionId() {
        this.orderBy(DecisionRequirementsDefinitionQueryProperty.DECISION_REQUIREMENTS_DEFINITION_ID);
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByDecisionRequirementsDefinitionVersion() {
        this.orderBy(DecisionRequirementsDefinitionQueryProperty.DECISION_REQUIREMENTS_DEFINITION_VERSION);
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByDecisionRequirementsDefinitionName() {
        this.orderBy(DecisionRequirementsDefinitionQueryProperty.DECISION_REQUIREMENTS_DEFINITION_NAME);
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByDeploymentId() {
        this.orderBy(DecisionRequirementsDefinitionQueryProperty.DEPLOYMENT_ID);
        return this;
    }

    @Override
    public DecisionRequirementsDefinitionQuery orderByTenantId() {
        return (DecisionRequirementsDefinitionQuery)this.orderBy(DecisionRequirementsDefinitionQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().isDmnEnabled()) {
            this.checkQueryOk();
            return commandContext.getDecisionRequirementsDefinitionManager().findDecisionRequirementsDefinitionCountByQueryCriteria(this);
        }
        return 0L;
    }

    @Override
    public List<DecisionRequirementsDefinition> executeList(CommandContext commandContext, Page page) {
        if (commandContext.getProcessEngineConfiguration().isDmnEnabled()) {
            this.checkQueryOk();
            return commandContext.getDecisionRequirementsDefinitionManager().findDecisionRequirementsDefinitionsByQueryCriteria(this, page);
        }
        return Collections.emptyList();
    }

    @Override
    public void checkQueryOk() {
        super.checkQueryOk();
        if (this.latest && (this.id != null || this.name != null || this.nameLike != null || this.version != null || this.deploymentId != null)) {
            throw new NotValidException("Calling latest() can only be used in combination with key(String) and keyLike(String)");
        }
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryLike() {
        return this.categoryLike;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceNameLike() {
        return this.resourceNameLike;
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isLatest() {
        return this.latest;
    }
}

