/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.cibseven.bpm.engine.authorization.Permissions;
import org.cibseven.bpm.engine.impl.db.CompositePermissionCheck;
import org.cibseven.bpm.engine.impl.db.PermissionCheck;

public class AuthorizationCheck
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean isAuthorizationCheckEnabled = false;
    protected boolean shouldPerformAuthorizatioCheck = false;
    protected boolean isRevokeAuthorizationCheckEnabled = false;
    protected String authUserId;
    protected List<String> authGroupIds = new ArrayList<String>();
    protected int authDefaultPerm = Permissions.ALL.getValue();
    protected CompositePermissionCheck permissionChecks = new CompositePermissionCheck();
    protected boolean historicInstancePermissionsEnabled = false;
    protected boolean useLeftJoin = true;

    public AuthorizationCheck() {
    }

    public AuthorizationCheck(String authUserId, List<String> authGroupIds, CompositePermissionCheck permissionCheck, boolean isRevokeAuthorizationCheckEnabled) {
        this.authUserId = authUserId;
        this.authGroupIds = authGroupIds;
        this.permissionChecks = permissionCheck;
        this.isRevokeAuthorizationCheckEnabled = isRevokeAuthorizationCheckEnabled;
    }

    public boolean isAuthorizationCheckEnabled() {
        return this.isAuthorizationCheckEnabled;
    }

    public boolean getIsAuthorizationCheckEnabled() {
        return this.isAuthorizationCheckEnabled;
    }

    public void setAuthorizationCheckEnabled(boolean isAuthorizationCheckPerformed) {
        this.isAuthorizationCheckEnabled = isAuthorizationCheckPerformed;
    }

    public boolean shouldPerformAuthorizatioCheck() {
        return this.shouldPerformAuthorizatioCheck;
    }

    public boolean getShouldPerformAuthorizatioCheck() {
        return this.isAuthorizationCheckEnabled && !this.isPermissionChecksEmpty();
    }

    public void setShouldPerformAuthorizatioCheck(boolean shouldPerformAuthorizatioCheck) {
        this.shouldPerformAuthorizatioCheck = shouldPerformAuthorizatioCheck;
    }

    protected boolean isPermissionChecksEmpty() {
        return this.permissionChecks.getAtomicChecks().isEmpty() && this.permissionChecks.getCompositeChecks().isEmpty();
    }

    public String getAuthUserId() {
        return this.authUserId;
    }

    public void setAuthUserId(String authUserId) {
        this.authUserId = authUserId;
    }

    public List<String> getAuthGroupIds() {
        return this.authGroupIds;
    }

    public void setAuthGroupIds(List<String> authGroupIds) {
        this.authGroupIds = authGroupIds;
    }

    public int getAuthDefaultPerm() {
        return this.authDefaultPerm;
    }

    public void setAuthDefaultPerm(int authDefaultPerm) {
        this.authDefaultPerm = authDefaultPerm;
    }

    public CompositePermissionCheck getPermissionChecks() {
        return this.permissionChecks;
    }

    public void setAtomicPermissionChecks(List<PermissionCheck> permissionChecks) {
        this.permissionChecks.setAtomicChecks(permissionChecks);
    }

    public void addAtomicPermissionCheck(PermissionCheck permissionCheck) {
        this.permissionChecks.addAtomicCheck(permissionCheck);
    }

    public void setPermissionChecks(CompositePermissionCheck permissionChecks) {
        this.permissionChecks = permissionChecks;
    }

    public boolean isRevokeAuthorizationCheckEnabled() {
        return this.isRevokeAuthorizationCheckEnabled;
    }

    public void setRevokeAuthorizationCheckEnabled(boolean isRevokeAuthorizationCheckEnabled) {
        this.isRevokeAuthorizationCheckEnabled = isRevokeAuthorizationCheckEnabled;
    }

    public void setHistoricInstancePermissionsEnabled(boolean historicInstancePermissionsEnabled) {
        this.historicInstancePermissionsEnabled = historicInstancePermissionsEnabled;
    }

    public boolean isHistoricInstancePermissionsEnabled() {
        return this.historicInstancePermissionsEnabled;
    }

    public boolean isUseLeftJoin() {
        return this.useLeftJoin;
    }

    public void setUseLeftJoin(boolean useLeftJoin) {
        this.useLeftJoin = useLeftJoin;
    }
}

