/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.db.DbEntity;
import org.cibseven.bpm.engine.impl.db.EnginePersistenceLogger;
import org.cibseven.bpm.engine.impl.db.EntityLoadListener;
import org.cibseven.bpm.engine.impl.db.PersistenceSession;
import org.cibseven.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.cibseven.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.cibseven.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.cibseven.bpm.engine.impl.history.HistoryLevel;

public abstract class AbstractPersistenceSession
implements PersistenceSession {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected List<EntityLoadListener> listeners = new ArrayList<EntityLoadListener>(1);

    public void executeDbOperation(DbOperation operation) {
        switch (operation.getOperationType()) {
            case INSERT: {
                this.insertEntity((DbEntityOperation)operation);
                break;
            }
            case DELETE: {
                this.deleteEntity((DbEntityOperation)operation);
                break;
            }
            case DELETE_BULK: {
                this.deleteBulk((DbBulkOperation)operation);
                break;
            }
            case UPDATE: {
                this.updateEntity((DbEntityOperation)operation);
                break;
            }
            case UPDATE_BULK: {
                this.updateBulk((DbBulkOperation)operation);
            }
        }
    }

    protected abstract void insertEntity(DbEntityOperation var1);

    protected abstract void deleteEntity(DbEntityOperation var1);

    protected abstract void deleteBulk(DbBulkOperation var1);

    protected abstract void updateEntity(DbEntityOperation var1);

    protected abstract void updateBulk(DbBulkOperation var1);

    protected abstract String getDbVersion();

    @Override
    public void dbSchemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        HistoryLevel configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (!processEngineConfiguration.isDbHistoryUsed() && !configuredHistoryLevel.equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            throw LOG.databaseHistoryLevelException(configuredHistoryLevel.getName());
        }
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"fox".equals(dbVersion)) {
                throw LOG.wrongDbVersionException("fox", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        if (processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmn();
        }
        if (processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateCmmnHistory();
        }
        if (processEngineConfiguration.isDmnEnabled()) {
            this.dbSchemaCreateDmn();
            if (processEngineConfiguration.isDbHistoryUsed()) {
                this.dbSchemaCreateDmnHistory();
            }
        }
    }

    protected abstract void dbSchemaCreateIdentity();

    protected abstract void dbSchemaCreateHistory();

    protected abstract void dbSchemaCreateEngine();

    protected abstract void dbSchemaCreateCmmn();

    protected abstract void dbSchemaCreateCmmnHistory();

    protected abstract void dbSchemaCreateDmn();

    protected abstract void dbSchemaCreateDmnHistory();

    @Override
    public void dbSchemaDrop() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isDmnEnabled()) {
            this.dbSchemaDropDmn();
            if (processEngineConfiguration.isDbHistoryUsed()) {
                this.dbSchemaDropDmnHistory();
            }
        }
        if (processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaDropCmmn();
        }
        this.dbSchemaDropEngine();
        if (processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropCmmnHistory();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaDropIdentity();
        }
    }

    protected abstract void dbSchemaDropIdentity();

    protected abstract void dbSchemaDropHistory();

    protected abstract void dbSchemaDropEngine();

    protected abstract void dbSchemaDropCmmn();

    protected abstract void dbSchemaDropCmmnHistory();

    protected abstract void dbSchemaDropDmn();

    protected abstract void dbSchemaDropDmnHistory();

    @Override
    public void dbSchemaPrune() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (this.isHistoryTablePresent() && !processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaDropHistory();
        }
        if (this.isIdentityTablePresent() && !processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaDropIdentity();
        }
        if (this.isCmmnTablePresent() && !processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaDropCmmn();
        }
        if (!(!this.isCmmnHistoryTablePresent() || processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed())) {
            this.dbSchemaDropCmmnHistory();
        }
        if (this.isDmnTablePresent() && !processEngineConfiguration.isDmnEnabled()) {
            this.dbSchemaDropDmn();
        }
        if (!(!this.isDmnHistoryTablePresent() || processEngineConfiguration.isDmnEnabled() && processEngineConfiguration.isDbHistoryUsed())) {
            this.dbSchemaDropDmnHistory();
        }
    }

    public abstract boolean isEngineTablePresent();

    public abstract boolean isHistoryTablePresent();

    public abstract boolean isIdentityTablePresent();

    public abstract boolean isCmmnTablePresent();

    public abstract boolean isCmmnHistoryTablePresent();

    public abstract boolean isDmnTablePresent();

    public abstract boolean isDmnHistoryTablePresent();

    @Override
    public void dbSchemaUpdate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (!this.isEngineTablePresent()) {
            this.dbSchemaCreateEngine();
        }
        if (!this.isHistoryTablePresent() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (!this.isIdentityTablePresent() && processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        if (!this.isCmmnTablePresent() && processEngineConfiguration.isCmmnEnabled()) {
            this.dbSchemaCreateCmmn();
        }
        if (!this.isCmmnHistoryTablePresent() && processEngineConfiguration.isCmmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateCmmnHistory();
        }
        if (!this.isDmnTablePresent() && processEngineConfiguration.isDmnEnabled()) {
            this.dbSchemaCreateDmn();
        }
        if (!this.isDmnHistoryTablePresent() && processEngineConfiguration.isDmnEnabled() && processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateDmnHistory();
        }
    }

    @Override
    public List<String> getTableNamesPresent() {
        return Collections.emptyList();
    }

    @Override
    public void addEntityLoadListener(EntityLoadListener listener) {
        this.listeners.add(listener);
    }

    protected void fireEntityLoaded(Object result) {
        if (result != null && result instanceof DbEntity) {
            DbEntity entity = (DbEntity)result;
            for (EntityLoadListener entityLoadListener : this.listeners) {
                entityLoadListener.onEntityLoaded(entity);
            }
        }
    }
}

