/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.cibseven.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnIfPartDeclaration;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnOnPartDeclaration;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnVariableOnPartDeclaration;
import org.cibseven.bpm.engine.impl.cmmn.transformer.CmmnTransformerLogger;
import org.cibseven.bpm.engine.impl.el.Expression;
import org.cibseven.bpm.engine.impl.el.ExpressionManager;
import org.cibseven.bpm.model.cmmn.PlanItemTransition;
import org.cibseven.bpm.model.cmmn.Query;
import org.cibseven.bpm.model.cmmn.VariableTransition;
import org.cibseven.bpm.model.cmmn.instance.CaseFileItemOnPart;
import org.cibseven.bpm.model.cmmn.instance.CmmnElement;
import org.cibseven.bpm.model.cmmn.instance.ConditionExpression;
import org.cibseven.bpm.model.cmmn.instance.ExtensionElements;
import org.cibseven.bpm.model.cmmn.instance.IfPart;
import org.cibseven.bpm.model.cmmn.instance.OnPart;
import org.cibseven.bpm.model.cmmn.instance.PlanItem;
import org.cibseven.bpm.model.cmmn.instance.PlanItemOnPart;
import org.cibseven.bpm.model.cmmn.instance.Sentry;
import org.cibseven.bpm.model.cmmn.instance.cibseven.CamundaVariableOnPart;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;

public class SentryHandler
extends CmmnElementHandler<Sentry, CmmnSentryDeclaration> {
    protected static final CmmnTransformerLogger LOG = ProcessEngineLogger.CMMN_TRANSFORMER_LOGGER;

    @Override
    public CmmnSentryDeclaration handleElement(Sentry element, CmmnHandlerContext context) {
        String id = element.getId();
        Collection onParts = element.getOnParts();
        IfPart ifPart = element.getIfPart();
        List<CamundaVariableOnPart> variableOnParts = this.queryExtensionElementsByClass((CmmnElement)element, CamundaVariableOnPart.class);
        if ((ifPart == null || ifPart.getConditions().isEmpty()) && variableOnParts.isEmpty()) {
            if (onParts == null || onParts.isEmpty()) {
                LOG.ignoredSentryWithMissingCondition(id);
                return null;
            }
            boolean atLeastOneOnPartsValid = false;
            for (OnPart onPart : onParts) {
                PlanItemOnPart planItemOnPart;
                if (!(onPart instanceof PlanItemOnPart) || (planItemOnPart = (PlanItemOnPart)onPart).getSource() == null || planItemOnPart.getStandardEvent() == null) continue;
                atLeastOneOnPartsValid = true;
                break;
            }
            if (!atLeastOneOnPartsValid) {
                LOG.ignoredSentryWithInvalidParts(id);
                return null;
            }
        }
        CmmnSentryDeclaration sentryDeclaration = new CmmnSentryDeclaration(id);
        this.initializeIfPart(ifPart, sentryDeclaration, context);
        this.initializeVariableOnParts((CmmnElement)element, sentryDeclaration, context, variableOnParts);
        CmmnActivity parent = context.getParent();
        if (parent != null) {
            parent.addSentry(sentryDeclaration);
        }
        return sentryDeclaration;
    }

    public void initializeOnParts(Sentry sentry, CmmnHandlerContext context) {
        Collection onParts = sentry.getOnParts();
        for (OnPart onPart : onParts) {
            if (onPart instanceof PlanItemOnPart) {
                this.initializeOnPart((PlanItemOnPart)onPart, sentry, context);
                continue;
            }
            this.initializeOnPart((CaseFileItemOnPart)onPart, sentry, context);
        }
    }

    protected void initializeOnPart(PlanItemOnPart onPart, Sentry sentry, CmmnHandlerContext context) {
        CmmnActivity parent = context.getParent();
        String sentryId = sentry.getId();
        CmmnSentryDeclaration sentryDeclaration = parent.getSentry(sentryId);
        PlanItem source = onPart.getSource();
        PlanItemTransition standardEvent = onPart.getStandardEvent();
        if (source != null && standardEvent != null) {
            Sentry sentryRef;
            CmmnOnPartDeclaration onPartDeclaration = new CmmnOnPartDeclaration();
            String standardEventName = standardEvent.name();
            onPartDeclaration.setStandardEvent(standardEventName);
            String sourceId = source.getId();
            CmmnActivity sourceActivity = parent.findActivity(sourceId);
            if (sourceActivity != null) {
                onPartDeclaration.setSource(sourceActivity);
            }
            if ((sentryRef = onPart.getSentry()) != null) {
                String sentryRefId = sentryRef.getId();
                CmmnSentryDeclaration sentryRefDeclaration = parent.getSentry(sentryRefId);
                onPartDeclaration.setSentry(sentryRefDeclaration);
            }
            sentryDeclaration.addOnPart(onPartDeclaration);
        }
    }

    protected void initializeOnPart(CaseFileItemOnPart onPart, Sentry sentry, CmmnHandlerContext context) {
        String id = sentry.getId();
        LOG.ignoredUnsupportedAttribute("onPart", "CaseFileItem", id);
    }

    protected void initializeIfPart(IfPart ifPart, CmmnSentryDeclaration sentryDeclaration, CmmnHandlerContext context) {
        if (ifPart == null) {
            return;
        }
        Collection conditions = ifPart.getConditions();
        if (conditions.size() > 1) {
            String id = sentryDeclaration.getId();
            LOG.multipleIgnoredConditions(id);
        }
        ExpressionManager expressionManager = context.getExpressionManager();
        ConditionExpression condition = (ConditionExpression)conditions.iterator().next();
        Expression conditionExpression = expressionManager.createExpression(condition.getText());
        CmmnIfPartDeclaration ifPartDeclaration = new CmmnIfPartDeclaration();
        ifPartDeclaration.setCondition(conditionExpression);
        sentryDeclaration.setIfPart(ifPartDeclaration);
    }

    protected void initializeVariableOnParts(CmmnElement element, CmmnSentryDeclaration sentryDeclaration, CmmnHandlerContext context, List<CamundaVariableOnPart> variableOnParts) {
        for (CamundaVariableOnPart variableOnPart : variableOnParts) {
            this.initializeVariableOnPart(variableOnPart, sentryDeclaration, context);
        }
    }

    protected void initializeVariableOnPart(CamundaVariableOnPart variableOnPart, CmmnSentryDeclaration sentryDeclaration, CmmnHandlerContext context) {
        VariableTransition variableTransition;
        try {
            variableTransition = variableOnPart.getVariableEvent();
        }
        catch (IllegalArgumentException illegalArgumentexception) {
            throw LOG.nonMatchingVariableEvents(sentryDeclaration.getId());
        }
        catch (NullPointerException nullPointerException) {
            throw LOG.nonMatchingVariableEvents(sentryDeclaration.getId());
        }
        String variableName = variableOnPart.getVariableName();
        String variableEventName = variableTransition.name();
        if (variableName != null) {
            if (!sentryDeclaration.hasVariableOnPart(variableEventName, variableName)) {
                CmmnVariableOnPartDeclaration variableOnPartDeclaration = new CmmnVariableOnPartDeclaration();
                variableOnPartDeclaration.setVariableEvent(variableEventName);
                variableOnPartDeclaration.setVariableName(variableName);
                sentryDeclaration.addVariableOnParts(variableOnPartDeclaration);
            }
        } else {
            throw LOG.emptyVariableName(sentryDeclaration.getId());
        }
    }

    protected <V extends ModelElementInstance> List<V> queryExtensionElementsByClass(CmmnElement element, Class<V> cls) {
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements != null) {
            Query query = extensionElements.getElementsQuery();
            return query.filterByType(cls).list();
        }
        return new ArrayList();
    }
}

