/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.handler;

import java.util.HashMap;
import org.cibseven.bpm.engine.impl.HistoryTimeToLiveParser;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.cibseven.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.cibseven.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.cibseven.bpm.engine.impl.cmmn.transformer.CmmnTransformerLogger;
import org.cibseven.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.cibseven.bpm.engine.impl.task.TaskDefinition;
import org.cibseven.bpm.engine.repository.Deployment;
import org.cibseven.bpm.model.cmmn.CmmnModelInstance;
import org.cibseven.bpm.model.cmmn.instance.Case;
import org.cibseven.bpm.model.cmmn.instance.CmmnElement;
import org.cibseven.bpm.model.cmmn.instance.Definitions;

public class CaseHandler
extends CmmnElementHandler<Case, CmmnCaseDefinition> {
    protected static final CmmnTransformerLogger LOG = ProcessEngineLogger.CMMN_TRANSFORMER_LOGGER;

    @Override
    public CmmnCaseDefinition handleElement(Case element, CmmnHandlerContext context) {
        CaseDefinitionEntity definition = this.createActivity((CmmnElement)element, context);
        this.initializeActivity(element, definition, context);
        return definition;
    }

    protected void initializeActivity(Case element, CmmnActivity activity, CmmnHandlerContext context) {
        CaseDefinitionEntity definition = (CaseDefinitionEntity)activity;
        Deployment deployment = context.getDeployment();
        definition.setKey(element.getId());
        definition.setName(element.getName());
        definition.setDeploymentId(deployment.getId());
        definition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        boolean skipEnforceTtl = !((DeploymentEntity)deployment).isNew();
        this.validateAndSetHTTL(element, definition, skipEnforceTtl);
        CmmnModelInstance model = context.getModel();
        Definitions definitions = model.getDefinitions();
        String category = definitions.getTargetNamespace();
        definition.setCategory(category);
    }

    protected void validateAndSetHTTL(Case element, CaseDefinitionEntity definition, boolean skipEnforceTtl) {
        String caseDefinitionKey = definition.getKey();
        Integer historyTimeToLive = HistoryTimeToLiveParser.create().parse(element, caseDefinitionKey, skipEnforceTtl);
        definition.setHistoryTimeToLive(historyTimeToLive);
    }

    protected CaseDefinitionEntity createActivity(CmmnElement element, CmmnHandlerContext context) {
        CaseDefinitionEntity definition = new CaseDefinitionEntity();
        definition.setCmmnElement(element);
        return definition;
    }
}

