/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import java.util.Map;
import org.cibseven.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmmn.CaseInstanceBuilderImpl;
import org.cibseven.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.cibseven.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.runtime.CaseInstance;

public class CreateCaseInstanceCmd
implements Command<CaseInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;
    protected String caseDefinitionTenantId;
    protected boolean isTenantIdSet = false;

    public CreateCaseInstanceCmd(CaseInstanceBuilderImpl builder) {
        this.caseDefinitionKey = builder.getCaseDefinitionKey();
        this.caseDefinitionId = builder.getCaseDefinitionId();
        this.businessKey = builder.getBusinessKey();
        this.variables = builder.getVariables();
        this.caseDefinitionTenantId = builder.getCaseDefinitionTenantId();
        this.isTenantIdSet = builder.isTenantIdSet();
    }

    @Override
    public CaseInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("caseDefinitionId and caseDefinitionKey are null", this.caseDefinitionId, this.caseDefinitionKey);
        CaseDefinitionEntity caseDefinition = this.find(commandContext);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateCaseInstance(caseDefinition);
        }
        CaseExecutionEntity caseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance(this.businessKey);
        caseInstance.create(this.variables);
        return caseInstance;
    }

    protected CaseDefinitionEntity find(CommandContext commandContext) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        CaseDefinitionEntity caseDefinition = null;
        if (this.caseDefinitionId != null) {
            caseDefinition = this.findById(deploymentCache, this.caseDefinitionId);
            EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "No case definition found for id = '" + this.caseDefinitionId + "'", "caseDefinition", (Object)caseDefinition);
        } else {
            caseDefinition = this.findByKey(deploymentCache, this.caseDefinitionKey);
            EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "No case definition found for key '" + this.caseDefinitionKey + "'", "caseDefinition", (Object)caseDefinition);
        }
        return caseDefinition;
    }

    protected CaseDefinitionEntity findById(DeploymentCache deploymentCache, String caseDefinitionId) {
        return deploymentCache.findDeployedCaseDefinitionById(caseDefinitionId);
    }

    protected CaseDefinitionEntity findByKey(DeploymentCache deploymentCache, String caseDefinitionKey) {
        if (this.isTenantIdSet) {
            return deploymentCache.findDeployedLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, this.caseDefinitionTenantId);
        }
        return deploymentCache.findDeployedLatestCaseDefinitionByKey(caseDefinitionKey);
    }
}

