/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.cibseven.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmmn.CaseExecutionCommandBuilderImpl;
import org.cibseven.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class CaseExecutionVariableCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseExecutionId;
    protected Map<String, Object> variables;
    protected Map<String, Object> variablesLocal;
    protected Collection<String> variablesDeletions;
    protected Collection<String> variablesLocalDeletions;
    protected CaseExecutionEntity caseExecution;

    public CaseExecutionVariableCmd(String caseExecutionId, Map<String, Object> variables, Map<String, Object> variablesLocal, Collection<String> variablesDeletions, Collection<String> variablesLocalDeletions) {
        this.caseExecutionId = caseExecutionId;
        this.variables = variables;
        this.variablesLocal = variablesLocal;
        this.variablesDeletions = variablesDeletions;
        this.variablesLocalDeletions = variablesLocalDeletions;
    }

    public CaseExecutionVariableCmd(CaseExecutionCommandBuilderImpl builder) {
        this(builder.getCaseExecutionId(), (Map<String, Object>)builder.getVariables(), (Map<String, Object>)builder.getVariablesLocal(), builder.getVariableDeletions(), builder.getVariableLocalDeletions());
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)this.caseExecutionId);
        this.caseExecution = commandContext.getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        EnsureUtil.ensureNotNull(CaseExecutionNotFoundException.class, "There does not exist any case execution with id: '" + this.caseExecutionId + "'", "caseExecution", (Object)this.caseExecution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateCaseInstance(this.caseExecution);
        }
        if (this.variablesDeletions != null && !this.variablesDeletions.isEmpty()) {
            this.caseExecution.removeVariables(this.variablesDeletions);
        }
        if (this.variablesLocalDeletions != null && !this.variablesLocalDeletions.isEmpty()) {
            this.caseExecution.removeVariablesLocal(this.variablesLocalDeletions);
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            this.caseExecution.setVariables(this.variables);
        }
        if (this.variablesLocal != null && !this.variablesLocal.isEmpty()) {
            this.caseExecution.setVariablesLocal(this.variablesLocal);
        }
        return null;
    }

    public CaseExecutionEntity getCaseExecution() {
        return this.caseExecution;
    }
}

