/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.behavior;

import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.cibseven.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.cibseven.bpm.engine.impl.pvm.PvmException;

public class CmmnBehaviorLogger
extends ProcessEngineLogger {
    protected final String caseStateTransitionMessage = "Could not perform transition '{} on case execution with id '{}'.";

    public ProcessEngineException ruleExpressionNotBooleanException(Object result) {
        return new ProcessEngineException(this.exceptionMessage("001", "Rule expression returns a non-boolean value. Value: '{}', Class: '{}'", new Object[]{result, result.getClass().getName()}));
    }

    public CaseIllegalStateTransitionException forbiddenManualCompletitionException(String transition, String id, String type) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("002", "Could not perform transition '{} on case execution with id '{}'.Reason: It is not possible to manually complete the case execution which is associated with an element of type {}.", new Object[]{transition, id, type}));
    }

    public CaseIllegalStateTransitionException criteriaNotAllowedException(String criteria, String id, String additionalMessage) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("003", "Cannot trigger case execution with id '{}' because {} criteria is not allowed for {}.", new Object[]{id, criteria, additionalMessage}));
    }

    public CaseIllegalStateTransitionException criteriaNotAllowedForEventListenerOrMilestonesException(String criteria, String id) {
        return this.criteriaNotAllowedException(criteria, id, "event listener or milestones");
    }

    public CaseIllegalStateTransitionException criteriaNotAllowedForEventListenerException(String criteria, String id) {
        return this.criteriaNotAllowedException(criteria, id, "event listener");
    }

    public CaseIllegalStateTransitionException criteriaNotAllowedForCaseInstanceException(String criteria, String id) {
        return this.criteriaNotAllowedException(criteria, id, "case instances");
    }

    CaseIllegalStateTransitionException executionAlreadyCompletedException(String transition, String id) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("004", "Could not perform transition '{} on case execution with id '{}'.Reason: Case execution must be available or suspended, but was completed.", new Object[]{transition, id}));
    }

    public CaseIllegalStateTransitionException resumeInactiveCaseException(String transition, String id) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("005", "Could not perform transition '{} on case execution with id '{}'.Reason: It is not possible to resume the case execution which parent is not active.", new Object[]{transition, id}));
    }

    public CaseIllegalStateTransitionException illegalStateTransitionException(String transition, String id, String typeName) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("006", "Could not perform transition '{} on case execution with id '{}'.Reason: It is not possible to {} the case execution which is associated with a {}", new Object[]{transition, id, transition, typeName}));
    }

    public CaseIllegalStateTransitionException alreadyStateCaseException(String transition, String id, String state) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("007", "Could not perform transition '{} on case execution with id '{}'.Reason: The case instance is already {}.", new Object[]{transition, id, state}));
    }

    public CaseIllegalStateTransitionException alreadyClosedCaseException(String transition, String id) {
        return this.alreadyStateCaseException(transition, id, "closed");
    }

    public CaseIllegalStateTransitionException alreadyActiveException(String transition, String id) {
        return this.alreadyStateCaseException(transition, id, "active");
    }

    public CaseIllegalStateTransitionException alreadyTerminatedException(String transition, String id) {
        return this.alreadyStateCaseException(transition, id, "terminated");
    }

    public CaseIllegalStateTransitionException alreadySuspendedException(String transition, String id) {
        return this.alreadyStateCaseException(transition, id, "suspended");
    }

    public CaseIllegalStateTransitionException wrongCaseStateException(String transition, String id, String acceptedState, String currentState) {
        return this.wrongCaseStateException(transition, id, transition, acceptedState, currentState);
    }

    public CaseIllegalStateTransitionException wrongCaseStateException(String transition, String id, String altTransition, String acceptedState, String currentState) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("008", "Could not perform transition '{} on case execution with id '{}'.Reason: The case instance must be in state '{}' to {} it, but the state is '{}'.", new Object[]{transition, id, acceptedState, transition, currentState}));
    }

    public CaseIllegalStateTransitionException notACaseInstanceException(String transition, String id) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("009", "Could not perform transition '{} on case execution with id '{}'.Reason: It is not possible to close a case execution which is not a case instance.", new Object[]{transition, id}));
    }

    public CaseIllegalStateTransitionException isAlreadyInStateException(String transition, String id, CaseExecutionState state) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("010", "Could not perform transition '{} on case execution with id '{}'.Reason: The case execution is already in state '{}'.", new Object[]{transition, id, state}));
    }

    public CaseIllegalStateTransitionException unexpectedStateException(String transition, String id, CaseExecutionState expectedState, CaseExecutionState currentState) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("011", "Could not perform transition '{} on case execution with id '{}'.Reason: The case execution must be in state '{}' to {}, but it was in state '{}'", new Object[]{transition, id, expectedState, transition, currentState}));
    }

    public CaseIllegalStateTransitionException impossibleTransitionException(String transition, String id) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("012", "Could not perform transition '{} on case execution with id '{}'.Reason: The transition is not possible for this case instance.", new Object[]{transition, id}));
    }

    public CaseIllegalStateTransitionException remainingChildException(String transition, String id, String childId, CaseExecutionState childState) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("013", "Could not perform transition '{} on case execution with id '{}'.Reason: There is a child case execution with id '{}' in state '{}'", new Object[]{transition, id, childId, childState}));
    }

    public CaseIllegalStateTransitionException wrongChildStateException(String transition, String id, String childId, String stateList) {
        return new CaseIllegalStateTransitionException(this.exceptionMessage("014", "Could not perform transition '{} on case execution with id '{}'.Reason: There is a child case execution with id '{}' which is in one of the following states: {}", new Object[]{transition, id, childId, stateList}));
    }

    public PvmException transitCaseException(String transition, String id, CaseExecutionState currentState) {
        return new PvmException(this.exceptionMessage("015", "Could not perform transition '{} on case execution with id '{}'.Reason: Expected case execution state to be {terminatingOnTermination|terminatingOnExit} but it was '{}'.", new Object[]{transition, id, currentState}));
    }

    public PvmException suspendCaseException(String id, CaseExecutionState currentState) {
        return this.transitCaseException("suspend", id, currentState);
    }

    public PvmException terminateCaseException(String id, CaseExecutionState currentState) {
        return this.transitCaseException("terminate", id, currentState);
    }

    public ProcessEngineException missingDelegateParentClassException(String className, String parentClass) {
        return new ProcessEngineException(this.exceptionMessage("016", "Class '{}' doesn't implement '{}'.", new Object[]{className, parentClass}));
    }

    public UnsupportedOperationException unsupportedTransientOperationException(String className) {
        return new UnsupportedOperationException(this.exceptionMessage("017", "Class '{}' is not supported in transient CaseExecutionImpl", new Object[]{className}));
    }

    public ProcessEngineException invokeVariableListenerException(Throwable cause) {
        return new ProcessEngineException(this.exceptionMessage("018", "Variable listener invocation failed. Reason: {}", new Object[]{cause.getMessage()}), cause);
    }

    public ProcessEngineException decisionDefinitionEvaluationFailed(CmmnActivityExecution execution, Exception cause) {
        return new ProcessEngineException(this.exceptionMessage("019", "Could not evaluate decision in case execution '" + execution.getId() + "'. Reason: {}", new Object[]{cause.getMessage()}), cause);
    }
}

