/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.impl.HistoryTimeToLiveParser;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class UpdateProcessDefinitionHistoryTimeToLiveCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected Integer historyTimeToLive;

    public UpdateProcessDefinitionHistoryTimeToLiveCmd(String processDefinitionId, Integer historyTimeToLive) {
        this.processDefinitionId = processDefinitionId;
        this.historyTimeToLive = historyTimeToLive;
    }

    @Override
    public Void execute(CommandContext context) {
        this.checkAuthorization(context);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processDefinitionId", (Object)this.processDefinitionId);
        if (this.historyTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "", "historyTimeToLive", this.historyTimeToLive.intValue(), 0L);
        }
        HistoryTimeToLiveParser parser = HistoryTimeToLiveParser.create(context);
        parser.validate(this.historyTimeToLive);
        ProcessDefinitionEntity processDefinitionEntity = context.getProcessDefinitionManager().findLatestProcessDefinitionById(this.processDefinitionId);
        this.logUserOperation(context, processDefinitionEntity);
        processDefinitionEntity.setHistoryTimeToLive(this.historyTimeToLive);
        return null;
    }

    protected void checkAuthorization(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessDefinitionById(this.processDefinitionId);
        }
    }

    protected void logUserOperation(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity) {
        PropertyChange propertyChange = new PropertyChange("historyTimeToLive", processDefinitionEntity.getHistoryTimeToLive(), this.historyTimeToLive);
        commandContext.getOperationLogManager().logProcessDefinitionOperation("UpdateHistoryTimeToLive", this.processDefinitionId, processDefinitionEntity.getKey(), propertyChange);
    }
}

