/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.CommentEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.util.ClockUtil;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class UpdateCommentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String commentId;
    protected String processInstanceId;
    protected String message;

    public UpdateCommentCmd(String taskId, String processInstanceId, String commentId, String message) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.commentId = commentId;
        this.message = message;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        String oldMessage;
        if (this.processInstanceId == null && this.taskId == null) {
            throw new BadUserRequestException("Both process instance and task ids are null");
        }
        EnsureUtil.ensureNotNull("commentId", (Object)this.commentId);
        EnsureUtil.ensureNotNull("message", (Object)this.message);
        CommentEntity comment = this.getComment(commandContext);
        String string = oldMessage = comment != null ? comment.getMessage() : "";
        if (this.processInstanceId == null) {
            EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
            EnsureUtil.ensureNotNull("No comment exists with commentId: " + this.commentId + " and taskId: " + this.taskId, "comment", (Object)comment);
            TaskEntity task = this.updateTaskComment(this.taskId, commandContext, comment);
            commandContext.getOperationLogManager().logCommentOperation("UpdateComment", task, this.getPropertyChange(oldMessage));
            task.triggerUpdateEvent();
        } else {
            EnsureUtil.ensureNotNull("processInstanceId", (Object)this.processInstanceId);
            EnsureUtil.ensureNotNull("No comment exists with commentId: " + this.commentId + " and processInstanceId: " + this.processInstanceId, "comment", (Object)comment);
            ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
            EnsureUtil.ensureNotNull("No processInstance exists with processInstanceId: " + this.processInstanceId, "processInstance", (Object)processInstance);
            this.updateProcessInstanceComment(this.processInstanceId, commandContext, comment);
            commandContext.getOperationLogManager().logCommentOperation("UpdateComment", processInstance, this.getPropertyChange(oldMessage));
        }
        return null;
    }

    protected TaskEntity updateTaskComment(String taskId, CommandContext commandContext, CommentEntity comment) {
        TaskEntity task = commandContext.getTaskManager().findTaskById(taskId);
        EnsureUtil.ensureNotNull("No task exists with taskId: " + taskId, "task", (Object)task);
        this.checkTaskWork(task, commandContext);
        this.updateComment(commandContext, comment);
        return task;
    }

    protected void updateProcessInstanceComment(String processInstanceId, CommandContext commandContext, CommentEntity comment) {
        this.checkUpdateProcessInstanceById(processInstanceId, commandContext);
        this.updateComment(commandContext, comment);
    }

    protected CommentEntity getComment(CommandContext commandContext) {
        if (this.taskId != null) {
            return commandContext.getCommentManager().findCommentByTaskIdAndCommentId(this.taskId, this.commentId);
        }
        return commandContext.getCommentManager().findCommentByProcessInstanceIdAndCommentId(this.processInstanceId, this.commentId);
    }

    protected PropertyChange getPropertyChange(String oldMessage) {
        return new PropertyChange("comment", oldMessage, this.message);
    }

    protected void checkTaskWork(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkTaskWork(task);
        }
    }

    protected void checkUpdateProcessInstanceById(String processInstanceId, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceById(processInstanceId);
        }
    }

    private void updateComment(CommandContext commandContext, CommentEntity comment) {
        String eventMessage = comment.toEventMessage(this.message);
        String userId = commandContext.getAuthenticatedUserId();
        comment.setMessage(eventMessage);
        comment.setFullMessage(this.message);
        comment.setTime(ClockUtil.getCurrentTime());
        comment.setAction("UpdateComment");
        comment.setUserId(userId);
        commandContext.getDbEntityManager().update(CommentEntity.class, "updateComment", comment);
    }
}

