/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.CommandLogger;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.cibseven.bpm.engine.impl.persistence.entity.JobEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.util.ClockUtil;

public class SetJobRetriesCmd
implements Command<Void>,
Serializable {
    protected static final long serialVersionUID = 1L;
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected static final String RETRIES = "retries";
    protected static final String DUE_DATE = "dueDate";
    protected final String jobId;
    protected final String jobDefinitionId;
    protected final List<String> jobIds;
    protected final int retries;
    protected Date dueDate;
    protected final boolean isDueDateSet;

    public SetJobRetriesCmd(String jobId, String jobDefinitionId, int retries, Date dueDate, boolean isDueDateSet) {
        this.jobId = jobId;
        this.jobDefinitionId = jobDefinitionId;
        this.jobIds = null;
        this.retries = retries;
        this.dueDate = dueDate;
        this.isDueDateSet = isDueDateSet;
    }

    public SetJobRetriesCmd(List<String> jobIds, int retries, Date dueDate, boolean isDueDateSet) {
        this.jobId = null;
        this.jobDefinitionId = null;
        this.jobIds = jobIds;
        this.retries = retries;
        this.dueDate = dueDate;
        this.isDueDateSet = isDueDateSet;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.dueDate == null && commandContext.getProcessEngineConfiguration().isEnsureJobDueDateNotNull()) {
            this.dueDate = ClockUtil.getCurrentTime();
        }
        if (this.jobId != null) {
            this.setJobRetriesByJobId(this.jobId, commandContext);
        } else if (this.jobDefinitionId != null) {
            this.setJobRetriesByJobDefinitionId(commandContext);
        } else if (this.jobIds != null) {
            for (String id : this.jobIds) {
                this.setJobRetriesByJobId(id, commandContext);
            }
        }
        return null;
    }

    protected void setJobRetriesByJobId(String jobId, CommandContext commandContext) {
        ArrayList<PropertyChange> propertyChanges;
        JobEntity job = commandContext.getJobManager().findJobById(jobId);
        if (job != null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateRetriesJob(job);
            }
            if (job.isInInconsistentLockState()) {
                job.resetLock();
            }
            propertyChanges = new ArrayList<PropertyChange>();
            int oldRetries = job.getRetries();
            job.setRetries(this.retries);
            propertyChanges.add(new PropertyChange(RETRIES, oldRetries, job.getRetries()));
            if (this.isDueDateSet) {
                Date oldDueDate = job.getDuedate();
                job.setDuedate(this.dueDate);
                propertyChanges.add(new PropertyChange(DUE_DATE, oldDueDate, job.getDuedate()));
            }
        } else {
            throw LOG.exceptionNoJobFoundForId(jobId);
        }
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), job.getId(), job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), propertyChanges);
    }

    protected void setJobRetriesByJobDefinitionId(CommandContext commandContext) {
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        JobDefinitionEntity jobDefinition = jobDefinitionManager.findById(this.jobDefinitionId);
        if (jobDefinition != null) {
            String processDefinitionId = jobDefinition.getProcessDefinitionId();
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateRetriesProcessInstanceByProcessDefinitionId(processDefinitionId);
            }
        }
        commandContext.getJobManager().updateFailedJobRetriesByJobDefinitionId(this.jobDefinitionId, this.retries, this.dueDate, this.isDueDateSet);
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange(RETRIES, null, this.retries));
        if (this.isDueDateSet) {
            propertyChanges.add(new PropertyChange(DUE_DATE, null, this.dueDate));
        }
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), null, this.jobDefinitionId, null, null, null, propertyChanges);
    }

    protected String getLogEntryOperation() {
        return "SetJobRetries";
    }
}

