/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.util.List;
import org.cibseven.bpm.engine.BadUserRequestException;
import org.cibseven.bpm.engine.impl.batch.BatchElementConfiguration;
import org.cibseven.bpm.engine.impl.cmd.AbstractSetExternalTaskRetriesCmd;
import org.cibseven.bpm.engine.impl.cmd.SetExternalTaskRetriesCmd;
import org.cibseven.bpm.engine.impl.cmd.UpdateExternalTaskRetriesBuilderImpl;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class SetExternalTasksRetriesCmd
extends AbstractSetExternalTaskRetriesCmd<Void> {
    public SetExternalTasksRetriesCmd(UpdateExternalTaskRetriesBuilderImpl builder) {
        super(builder);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        BatchElementConfiguration elementConfiguration = this.collectExternalTaskIds(commandContext);
        List<String> collectedIds = elementConfiguration.getIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "externalTaskIds", collectedIds);
        int instanceCount = collectedIds.size();
        this.writeUserOperationLog(commandContext, instanceCount, false);
        int retries = this.builder.getRetries();
        for (String externalTaskId : collectedIds) {
            new SetExternalTaskRetriesCmd(externalTaskId, retries, false).execute(commandContext);
        }
        return null;
    }
}

