/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricCaseInstanceCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseInstanceId;

    public DeleteHistoricCaseInstanceCmd(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseInstanceId", (Object)this.caseInstanceId);
        HistoricCaseInstanceEntity instance = commandContext.getHistoricCaseInstanceManager().findHistoricCaseInstance(this.caseInstanceId);
        EnsureUtil.ensureNotNull("No historic case instance found with id: " + this.caseInstanceId, "instance", (Object)instance);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricCaseInstance(instance);
        }
        EnsureUtil.ensureNotNull("Case instance is still running, cannot delete historic case instance: " + this.caseInstanceId, "instance.getCloseTime()", (Object)instance.getCloseTime());
        commandContext.getOperationLogManager().logCaseInstanceOperation("DeleteHistory", this.caseInstanceId, instance.getTenantId(), Collections.singletonList(PropertyChange.EMPTY_CHANGE));
        commandContext.getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(Arrays.asList(this.caseInstanceId));
        return null;
    }
}

