/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.util.Map;
import org.cibseven.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.MessageEventReceivedCmd;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import org.cibseven.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.runtime.CorrelationHandlerResult;
import org.cibseven.bpm.engine.impl.runtime.MessageCorrelationResultImpl;
import org.cibseven.bpm.engine.runtime.MessageCorrelationResultType;
import org.cibseven.bpm.engine.runtime.ProcessInstance;
import org.cibseven.bpm.engine.variable.VariableMap;
import org.cibseven.bpm.engine.variable.Variables;

public abstract class AbstractCorrelateMessageCmd {
    protected final String messageName;
    protected final MessageCorrelationBuilderImpl builder;
    protected ExecutionVariableSnapshotObserver variablesListener;
    protected boolean variablesInResultEnabled = false;
    protected long variablesCount = 0L;
    protected boolean deserializeVariableValues = false;

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl builder) {
        this.builder = builder;
        this.messageName = builder.getMessageName();
        this.countVariables();
    }

    protected AbstractCorrelateMessageCmd(MessageCorrelationBuilderImpl builder, boolean variablesEnabled, boolean deserializeVariableValues) {
        this(builder);
        this.variablesInResultEnabled = variablesEnabled;
        this.deserializeVariableValues = deserializeVariableValues;
    }

    protected void triggerExecution(CommandContext commandContext, CorrelationHandlerResult correlationResult) {
        String executionId = correlationResult.getExecutionEntity().getId();
        MessageEventReceivedCmd command = new MessageEventReceivedCmd(this.messageName, executionId, this.builder.getPayloadProcessInstanceVariables(), (Map<String, Object>)this.builder.getPayloadProcessInstanceVariablesLocal(), (Map<String, Object>)this.builder.getPayloadProcessInstanceVariablesToTriggeredScope(), this.builder.isExclusiveCorrelation());
        command.execute(commandContext);
    }

    protected ProcessInstance instantiateProcess(CommandContext commandContext, CorrelationHandlerResult correlationResult) {
        ProcessDefinitionEntity processDefinitionEntity = correlationResult.getProcessDefinitionEntity();
        ActivityImpl messageStartEvent = processDefinitionEntity.findActivity(correlationResult.getStartEventActivityId());
        ExecutionEntity processInstance = processDefinitionEntity.createProcessInstance(this.builder.getBusinessKey(), messageStartEvent);
        if (this.variablesInResultEnabled) {
            this.variablesListener = new ExecutionVariableSnapshotObserver(processInstance, false, this.deserializeVariableValues);
        }
        VariableMap startVariables = this.resolveVariables();
        processInstance.start((Map<String, Object>)startVariables);
        return processInstance;
    }

    protected void checkAuthorization(CorrelationHandlerResult correlation) {
        CommandContext commandContext = Context.getCommandContext();
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if (MessageCorrelationResultType.Execution.equals((Object)correlation.getResultType())) {
                ExecutionEntity execution = correlation.getExecutionEntity();
                checker.checkUpdateProcessInstanceById(execution.getProcessInstanceId());
                continue;
            }
            ProcessDefinitionEntity definition = correlation.getProcessDefinitionEntity();
            checker.checkCreateProcessInstance(definition);
        }
    }

    protected MessageCorrelationResultImpl createMessageCorrelationResult(CommandContext commandContext, CorrelationHandlerResult handlerResult) {
        MessageCorrelationResultImpl resultWithVariables = new MessageCorrelationResultImpl(handlerResult);
        if (MessageCorrelationResultType.Execution.equals((Object)handlerResult.getResultType())) {
            ExecutionEntity execution = this.findProcessInstanceExecution(commandContext, handlerResult);
            ExecutionEntity processInstance = execution.getProcessInstance();
            resultWithVariables.setProcessInstance(processInstance);
            if (this.variablesInResultEnabled && execution != null) {
                this.variablesListener = new ExecutionVariableSnapshotObserver(execution, false, this.deserializeVariableValues);
            }
            this.triggerExecution(commandContext, handlerResult);
        } else {
            ProcessInstance instance = this.instantiateProcess(commandContext, handlerResult);
            resultWithVariables.setProcessInstance(instance);
        }
        if (this.variablesListener != null) {
            resultWithVariables.setVariables(this.variablesListener.getVariables());
        }
        return resultWithVariables;
    }

    protected ExecutionEntity findProcessInstanceExecution(CommandContext commandContext, CorrelationHandlerResult handlerResult) {
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(handlerResult.getExecution().getProcessInstanceId());
        return execution;
    }

    protected VariableMap resolveVariables() {
        VariableMap mergedVariables = Variables.createVariables();
        mergedVariables.putAll(this.builder.getPayloadProcessInstanceVariables());
        mergedVariables.putAll((Map)this.builder.getPayloadProcessInstanceVariablesLocal());
        mergedVariables.putAll((Map)this.builder.getPayloadProcessInstanceVariablesToTriggeredScope());
        return mergedVariables;
    }

    protected void countVariables() {
        if (this.builder.getPayloadProcessInstanceVariables() != null) {
            this.variablesCount += (long)this.builder.getPayloadProcessInstanceVariables().size();
        }
        if (this.builder.getPayloadProcessInstanceVariablesLocal() != null) {
            this.variablesCount += (long)this.builder.getPayloadProcessInstanceVariablesLocal().size();
        }
        if (this.builder.getPayloadProcessInstanceVariablesToTriggeredScope() != null) {
            this.variablesCount += (long)this.builder.getPayloadProcessInstanceVariablesToTriggeredScope().size();
        }
    }
}

