/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.cibseven.bpm.engine.impl.AbstractQueryVariableValueCondition;
import org.cibseven.bpm.engine.impl.CompositeQueryVariableValueCondition;
import org.cibseven.bpm.engine.impl.QueryOperator;
import org.cibseven.bpm.engine.impl.SingleQueryVariableValueCondition;
import org.cibseven.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.cibseven.bpm.engine.variable.Variables;
import org.cibseven.bpm.engine.variable.value.TypedValue;

public class QueryVariableValue
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected String name;
    protected TypedValue value;
    protected QueryOperator operator;
    protected boolean local;
    protected AbstractQueryVariableValueCondition valueCondition;
    protected boolean variableNameIgnoreCase;
    protected boolean variableValueIgnoreCase;

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local) {
        this(name, value, operator, local, false, false);
    }

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local, boolean variableNameIgnoreCase, boolean variableValueIgnoreCase) {
        this.name = name;
        this.value = Variables.untypedValue((Object)value);
        this.operator = operator;
        this.local = local;
        this.variableNameIgnoreCase = variableNameIgnoreCase;
        this.variableValueIgnoreCase = variableValueIgnoreCase;
    }

    public void initialize(VariableSerializers serializers, String dbType) {
        this.valueCondition = this.value.getType() != null && this.value.getType().isAbstract() ? new CompositeQueryVariableValueCondition(this) : new SingleQueryVariableValueCondition(this);
        this.valueCondition.initializeValue(serializers, dbType);
    }

    public List<SingleQueryVariableValueCondition> getValueConditions() {
        return this.valueCondition.getDisjunctiveConditions();
    }

    public String getName() {
        return this.name;
    }

    public QueryOperator getOperator() {
        if (this.operator != null) {
            return this.operator;
        }
        return QueryOperator.EQUALS;
    }

    public String getOperatorName() {
        return this.getOperator().toString();
    }

    public Object getValue() {
        return this.value.getValue();
    }

    public TypedValue getTypedValue() {
        return this.value;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isVariableNameIgnoreCase() {
        return this.variableNameIgnoreCase;
    }

    public void setVariableNameIgnoreCase(boolean variableNameIgnoreCase) {
        this.variableNameIgnoreCase = variableNameIgnoreCase;
    }

    public boolean isVariableValueIgnoreCase() {
        return this.variableValueIgnoreCase;
    }

    public void setVariableValueIgnoreCase(boolean variableValueIgnoreCase) {
        this.variableValueIgnoreCase = variableValueIgnoreCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryVariableValue that = (QueryVariableValue)o;
        return this.local == that.local && this.variableNameIgnoreCase == that.variableNameIgnoreCase && this.variableValueIgnoreCase == that.variableValueIgnoreCase && this.name.equals(that.name) && this.value.equals(that.value) && this.operator == that.operator && Objects.equals(this.valueCondition, that.valueCondition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.value, this.operator, this.local, this.valueCondition, this.variableNameIgnoreCase, this.variableValueIgnoreCase});
    }
}

