/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.delegate;

import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class BpmnError
extends ProcessEngineException {
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private String errorMessage;

    public BpmnError(String errorCode) {
        super(BpmnError.exceptionMessage(errorCode, null));
        this.setErrorCode(errorCode);
    }

    public BpmnError(String errorCode, String message) {
        super(BpmnError.exceptionMessage(errorCode, message));
        this.setErrorCode(errorCode);
        this.setMessage(message);
    }

    public BpmnError(String errorCode, String message, Throwable cause) {
        super(BpmnError.exceptionMessage(errorCode, message), cause);
        this.setErrorCode(errorCode);
        this.setMessage(message);
    }

    public BpmnError(String errorCode, Throwable cause) {
        super(BpmnError.exceptionMessage(errorCode, null), cause);
        this.setErrorCode(errorCode);
    }

    private static String exceptionMessage(String errorCode, String message) {
        if (message == null) {
            return "";
        }
        return message + " (errorCode='" + errorCode + "')";
    }

    protected void setErrorCode(String errorCode) {
        EnsureUtil.ensureNotEmpty("Error Code", errorCode);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return super.toString() + " (errorCode='" + this.errorCode + "')";
    }

    protected void setMessage(String errorMessage) {
        EnsureUtil.ensureNotEmpty("Error Message", errorMessage);
        this.errorMessage = errorMessage;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }
}

