/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.container.impl.metadata;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cibseven.bpm.container.impl.metadata.BpmPlatformXmlImpl;
import org.cibseven.bpm.container.impl.metadata.DeploymentMetadataParse;
import org.cibseven.bpm.container.impl.metadata.JobAcquisitionXmlImpl;
import org.cibseven.bpm.container.impl.metadata.JobExecutorXmlImpl;
import org.cibseven.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.cibseven.bpm.container.impl.metadata.spi.JobAcquisitionXml;
import org.cibseven.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.cibseven.bpm.engine.impl.util.xml.Element;
import org.cibseven.bpm.engine.impl.util.xml.Parser;

public class BpmPlatformXmlParse
extends DeploymentMetadataParse {
    protected BpmPlatformXml bpmPlatformXml;

    public BpmPlatformXmlParse(Parser parser) {
        super(parser);
    }

    @Override
    public BpmPlatformXmlParse execute() {
        super.execute();
        return this;
    }

    @Override
    protected void parseRootElement() {
        JobExecutorXmlImpl jobExecutor = new JobExecutorXmlImpl();
        ArrayList<ProcessEngineXml> processEngines = new ArrayList<ProcessEngineXml>();
        for (Element element : this.rootElement.elements()) {
            if ("job-executor".equals(element.getTagName())) {
                this.parseJobExecutor(element, jobExecutor);
                continue;
            }
            if (!"process-engine".equals(element.getTagName())) continue;
            this.parseProcessEngine(element, processEngines);
        }
        this.bpmPlatformXml = new BpmPlatformXmlImpl(jobExecutor, processEngines);
    }

    protected void parseJobExecutor(Element element, JobExecutorXmlImpl jobExecutorXml) {
        ArrayList<JobAcquisitionXml> jobAcquisitions = new ArrayList<JobAcquisitionXml>();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element childElement : element.elements()) {
            if ("job-acquisition".equals(childElement.getTagName())) {
                this.parseJobAcquisition(childElement, jobAcquisitions);
                continue;
            }
            if (!"properties".equals(childElement.getTagName())) continue;
            this.parseProperties(childElement, properties);
        }
        jobExecutorXml.setJobAcquisitions(jobAcquisitions);
        jobExecutorXml.setProperties(properties);
    }

    protected void parseJobAcquisition(Element element, List<JobAcquisitionXml> jobAcquisitions) {
        JobAcquisitionXmlImpl jobAcquisition = new JobAcquisitionXmlImpl();
        jobAcquisition.setName(element.attribute("name"));
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Element childElement : element.elements()) {
            if ("job-executor-class".equals(childElement.getTagName())) {
                jobAcquisition.setJobExecutorClassName(childElement.getText());
                continue;
            }
            if (!"properties".equals(childElement.getTagName())) continue;
            this.parseProperties(childElement, properties);
        }
        jobAcquisition.setProperties(properties);
        jobAcquisitions.add(jobAcquisition);
    }

    public BpmPlatformXml getBpmPlatformXml() {
        return this.bpmPlatformXml;
    }

    @Override
    public BpmPlatformXmlParse sourceUrl(URL url) {
        super.sourceUrl(url);
        return this;
    }
}

