/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSOrdinaryObject;
import com.oracle.truffle.js.runtime.objects.JSPrototypeData;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.JSSharedData;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class JSObjectUtil {
    private static final HiddenKey PROTOTYPE_DATA = new HiddenKey("PROTOTYPE_DATA");

    private JSObjectUtil() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatToString(String object) {
        return "[object " + object + "]";
    }

    public static DynamicObject createOrdinaryPrototypeObject(JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        return JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getObjectPrototype());
    }

    public static DynamicObject createOrdinaryPrototypeObject(JSRealm realm, DynamicObject prototype) {
        DynamicObject obj;
        CompilerAsserts.neverPartOfCompilation();
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        JSContext context = realm.getContext();
        if (context.isMultiContext()) {
            obj = JSOrdinary.createInitWithInstancePrototype(prototype, context);
        } else {
            Shape initialShape = prototype == Null.instance ? context.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, JSOrdinary.INSTANCE, context);
            obj = JSOrdinaryObject.create(initialShape);
        }
        return obj;
    }

    public static void setOrVerifyPrototype(JSContext context, DynamicObject obj, DynamicObject prototype) {
        CompilerAsserts.neverPartOfCompilation();
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        if (context.isMultiContext()) {
            JSObjectUtil.putHiddenProperty(obj, JSObject.HIDDEN_PROTO, prototype);
        } else assert (JSObjectUtil.getHiddenProperty(obj, JSObject.HIDDEN_PROTO) == prototype);
    }

    public static boolean isValidPrototype(Object proto) {
        return proto == Null.instance || JSRuntime.isObject(proto);
    }

    private static LocationFactory declaredLocationFactory() {
        return (shape, val) -> shape.allocator().declaredLocation(val);
    }

    public static Shape shapeDefineDataProperty(JSContext context, Shape shape, Object key, Object value, int flags) {
        CompilerAsserts.neverPartOfCompilation();
        return shape.defineProperty(JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key), value, flags);
    }

    public static Shape shapeDefineDeclaredDataProperty(JSContext context, Shape shape, Object key, Object value, int flags) {
        CompilerAsserts.neverPartOfCompilation();
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key);
        return shape.defineProperty(key, value, flags, JSObjectUtil.declaredLocationFactory());
    }

    @CompilerDirectives.TruffleBoundary
    public static void putDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        JSObjectUtil.defineDataProperty(context, thisObj, key, value, flags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void putDataProperty(DynamicObject thisObj, Object name, Object value, int flags) {
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.putDataProperty(context, thisObj, name, value, flags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void defineDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key);
        DynamicObjectLibrary.getUncached().putWithFlags(thisObj, key, value, flags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void defineDataProperty(DynamicObject thisObj, Object key, Object value, int flags) {
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.defineDataProperty(context, thisObj, key, value, flags);
    }

    public static void putOrSetDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        if (!JSObject.hasOwnProperty(thisObj, key)) {
            JSObjectUtil.putDataProperty(context, thisObj, key, value, flags);
        } else {
            JSObject.set(thisObj, key, value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void defineAccessorProperty(DynamicObject thisObj, Object key, Accessor accessor, int flags) {
        int finalFlags = flags | 8;
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key);
        DynamicObjectLibrary.getUncached().putWithFlags(thisObj, key, accessor, finalFlags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void defineProxyProperty(DynamicObject thisObj, Object key, PropertyProxy proxy, int flags) {
        int finalFlags = flags | 0x10;
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key);
        DynamicObjectLibrary.getUncached().putConstant(thisObj, key, proxy, finalFlags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void changePropertyFlags(DynamicObject thisObj, Object key, int flags) {
        assert (flags == (flags & 7));
        JSDynamicObject.updatePropertyFlags(thisObj, key, attr -> attr & 0xFFFFFFF8 | flags);
    }

    public static void putDataProperty(JSContext context, DynamicObject thisObj, String name, Object value) {
        JSObjectUtil.putDataProperty(context, thisObj, name, value, JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    @CompilerDirectives.TruffleBoundary
    public static void putDeclaredDataProperty(JSContext context, DynamicObject thisObj, Object key, Object value, int flags) {
        assert (JSRuntime.isPropertyKey(key));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key);
        DynamicObjectLibrary.getUncached().putConstant(thisObj, key, value, flags);
    }

    public static void putConstructorProperty(JSContext context, DynamicObject prototype, DynamicObject constructor) {
        JSObjectUtil.putDataProperty(context, prototype, "constructor", constructor, JSAttributes.configurableNotEnumerableWritable());
    }

    public static void putConstructorPrototypeProperty(JSContext ctx, DynamicObject constructor, DynamicObject prototype) {
        JSObjectUtil.putDataProperty(ctx, constructor, "prototype", prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    public static void putToStringTag(DynamicObject prototype, String toStringTag) {
        assert (JSObjectUtil.checkForExistingProperty(prototype, Symbol.SYMBOL_TO_STRING_TAG));
        DynamicObjectLibrary.getUncached().putWithFlags(prototype, Symbol.SYMBOL_TO_STRING_TAG, toStringTag, JSAttributes.configurableNotEnumerableNotWritable());
    }

    @CompilerDirectives.TruffleBoundary
    public static void putAccessorProperty(JSContext context, DynamicObject thisObj, Object key, DynamicObject getter, DynamicObject setter, int flags) {
        Accessor accessor = new Accessor(getter, setter);
        JSObjectUtil.putAccessorProperty(context, thisObj, key, accessor, flags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void putAccessorProperty(JSContext context, DynamicObject thisObj, Object key, Accessor accessor, int flags) {
        assert (JSRuntime.isPropertyKey(key));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        JSObjectUtil.checkForNoSuchPropertyOrMethod(context, key);
        DynamicObjectLibrary.getUncached().putWithFlags(thisObj, key, accessor, flags | 8);
    }

    public static void putBuiltinAccessorProperty(DynamicObject thisObj, Object key, DynamicObject getter, DynamicObject setter) {
        JSObjectUtil.putBuiltinAccessorProperty(thisObj, key, getter, setter, JSAttributes.configurableNotEnumerable());
    }

    @CompilerDirectives.TruffleBoundary
    public static void putBuiltinAccessorProperty(DynamicObject thisObj, Object key, DynamicObject getter, DynamicObject setter, int flags) {
        Accessor accessor = new Accessor(getter, setter);
        JSObjectUtil.putBuiltinAccessorProperty(thisObj, key, accessor, flags);
    }

    @CompilerDirectives.TruffleBoundary
    public static void putBuiltinAccessorProperty(DynamicObject thisObj, Object key, Accessor accessor, int flags) {
        assert (JSRuntime.isPropertyKey(key) && !JSObjectUtil.isNoSuchPropertyOrMethod(key));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        DynamicObjectLibrary.getUncached().putWithFlags(thisObj, key, accessor, flags | 8);
    }

    public static void putBuiltinAccessorProperty(DynamicObject thisObj, Object key, Accessor accessor) {
        JSObjectUtil.putBuiltinAccessorProperty(thisObj, key, accessor, JSAttributes.configurableNotEnumerable());
    }

    public static void putProxyProperty(DynamicObject thisObj, Object key, PropertyProxy proxy, int flags) {
        assert (JSRuntime.isPropertyKey(key) && !JSObjectUtil.isNoSuchPropertyOrMethod(key));
        assert (JSObjectUtil.checkForExistingProperty(thisObj, key));
        JSObjectUtil.defineProxyProperty(thisObj, key, proxy, flags);
    }

    private static boolean checkForExistingProperty(DynamicObject thisObj, Object key) {
        assert (!thisObj.getShape().hasProperty(key)) : "Don't put a property that already exists. Use the setters.";
        return true;
    }

    public static Shape getProtoChildShape(DynamicObject obj, JSClass jsclass, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        if (obj == null) {
            return context.makeEmptyShapeWithPrototypeInObject(jsclass);
        }
        assert (JSRuntime.isObject(obj));
        Shape protoChild = JSObjectUtil.getProtoChildShapeMaybe(obj, jsclass);
        if (protoChild != null) {
            return protoChild;
        }
        return JSObjectUtil.getProtoChildShapeSlowPath(obj, jsclass, context);
    }

    public static Shape getProtoChildShape(DynamicObject obj, JSClass jsclass, JSContext context, BranchProfile branchProfile) {
        Shape protoChild = JSObjectUtil.getProtoChildShapeMaybe(obj, jsclass);
        if (protoChild != null) {
            return protoChild;
        }
        branchProfile.enter();
        return JSObjectUtil.getProtoChildShapeSlowPath(obj, jsclass, context);
    }

    private static Shape getProtoChildShapeMaybe(DynamicObject obj, JSClass jsclass) {
        Shape protoChild = JSShape.getProtoChildTree(obj, jsclass);
        assert (protoChild == null || JSShape.getJSClassNoCast(protoChild) == jsclass);
        return protoChild;
    }

    @CompilerDirectives.TruffleBoundary
    private static Shape getProtoChildShapeSlowPath(DynamicObject obj, JSClass jsclass, JSContext context) {
        JSPrototypeData prototypeData = JSObjectUtil.getPrototypeData(obj);
        if (prototypeData == null) {
            prototypeData = JSObjectUtil.putPrototypeData(obj);
        }
        return prototypeData.getOrAddProtoChildTree(jsclass, JSObjectUtil.createChildRootShape(obj, jsclass, context));
    }

    private static Shape createChildRootShape(DynamicObject proto, JSClass jsclass, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        assert (proto != null && proto != Null.instance);
        return JSShape.createObjectShape(context, jsclass, proto);
    }

    public static JSPrototypeData putPrototypeData(DynamicObject obj) {
        CompilerAsserts.neverPartOfCompilation();
        assert (JSObjectUtil.getPrototypeData(obj) == null);
        JSPrototypeData prototypeData = new JSPrototypeData();
        JSObjectUtil.putPrototypeData(obj, prototypeData);
        return prototypeData;
    }

    private static void putPrototypeData(DynamicObject obj, JSPrototypeData prototypeData) {
        boolean extensible = JSShape.isExtensible(obj.getShape());
        JSObjectUtil.putHiddenProperty(obj, PROTOTYPE_DATA, prototypeData);
        assert (extensible == JSShape.isExtensible(obj.getShape()));
    }

    static JSPrototypeData getPrototypeData(DynamicObject obj) {
        return (JSPrototypeData)JSDynamicObject.getOrNull(obj, PROTOTYPE_DATA);
    }

    public static Map<Object, Object> archive(DynamicObject obj) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Shape shape = obj.getShape();
        for (Property prop : shape.getPropertyListInternal(false)) {
            if (prop.getLocation().isValue() || ret.containsKey(prop.getKey())) continue;
            ret.put(prop.getKey(), prop.get(obj, false));
        }
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setPrototypeImpl(DynamicObject object, DynamicObject newPrototype) {
        Shape newRootShape;
        CompilerAsserts.neverPartOfCompilation();
        assert (JSShape.isPrototypeInShape(object.getShape()));
        JSContext context = JSObject.getJSContext(object);
        Shape oldShape = object.getShape();
        JSShape.invalidatePrototypeAssumption(oldShape);
        JSClass jsclass = JSShape.getJSClass(oldShape);
        if (newPrototype == Null.instance) {
            newRootShape = context.makeEmptyShapeWithNullPrototype(jsclass);
        } else {
            assert (JSRuntime.isObject(newPrototype)) : newPrototype;
            newRootShape = context.isMultiContext() ? context.makeEmptyShapeWithPrototypeInObject(jsclass) : JSObjectUtil.getProtoChildShape(newPrototype, jsclass, context);
        }
        DynamicObjectLibrary lib = DynamicObjectLibrary.getUncached();
        List<Property> allProperties = oldShape.getPropertyListInternal(true);
        ArrayList<Object> archive = new ArrayList<Object>(allProperties.size());
        for (Property prop : allProperties) {
            Object value = lib.getOrDefault(object, prop.getKey(), null);
            archive.add(value);
        }
        lib.resetShape(object, newRootShape);
        for (int i = 0; i < allProperties.size(); ++i) {
            Property property = allProperties.get(i);
            Object key = property.getKey();
            if (newRootShape.hasProperty(key)) continue;
            Object value = archive.get(i);
            int propertyFlags = property.getFlags();
            if (JSObject.HIDDEN_PROTO.equals(key)) {
                lib.putWithFlags(object, key, newPrototype, propertyFlags);
                continue;
            }
            if (property.getLocation().isConstant()) {
                lib.putConstant(object, key, value, propertyFlags);
                continue;
            }
            lib.putWithFlags(object, key, value, propertyFlags);
        }
        assert (JSObjectUtil.getPrototype(object) == newPrototype);
    }

    public static JSDynamicObject getPrototype(DynamicObject thisObj) {
        JSSharedData sharedData = JSShape.getSharedData(thisObj.getShape());
        JSDynamicObject proto = sharedData.getPrototype();
        if (proto != null) {
            assert (proto == JSDynamicObject.getOrDefault(thisObj, JSObject.HIDDEN_PROTO, Null.instance));
            return proto;
        }
        return (JSDynamicObject)JSDynamicObject.getOrDefault(thisObj, JSObject.HIDDEN_PROTO, Null.instance);
    }

    public static <T> T checkForNoSuchPropertyOrMethod(JSContext context, T key) {
        CompilerAsserts.neverPartOfCompilation();
        if (context != null && key != null && context.isOptionNashornCompatibilityMode()) {
            if (context.getNoSuchPropertyUnusedAssumption().isValid() && "__noSuchProperty__".equals(key)) {
                context.getNoSuchPropertyUnusedAssumption().invalidate("NoSuchProperty is used");
            }
            if (context.getNoSuchMethodUnusedAssumption().isValid() && "__noSuchMethod__".equals(key)) {
                context.getNoSuchMethodUnusedAssumption().invalidate("NoSuchMethod is used");
            }
        }
        return key;
    }

    public static boolean isNoSuchPropertyOrMethod(Object key) {
        CompilerAsserts.neverPartOfCompilation();
        return key instanceof String && (key.equals("__noSuchProperty__") || key.equals("__noSuchMethod__"));
    }

    public static DynamicObject createSymbolSpeciesGetterFunction(JSRealm realm) {
        return JSFunction.create(realm, JSFunctionData.createCallOnly(realm.getContext(), realm.getContext().getSpeciesGetterFunctionCallTarget(), 0, "get [Symbol.species]"));
    }

    public static void putFunctionsFromContainer(final JSRealm realm, final DynamicObject thisObj, JSBuiltinsContainer container) {
        final JSContext context = realm.getContext();
        container.forEachBuiltin((Consumer<? super JSBuiltin>)new Consumer<Builtin>(){

            @Override
            public void accept(Builtin builtin) {
                if (!builtin.isIncluded(context)) {
                    return;
                }
                if (builtin.isGetter() || builtin.isSetter()) {
                    return;
                }
                JSFunctionData functionData = builtin.createFunctionData(context);
                JSObjectUtil.putDataProperty(context, thisObj, builtin.getKey(), JSFunction.create(realm, functionData), builtin.getAttributeFlags());
            }
        });
    }

    public static void putHiddenProperty(DynamicObject obj, Object key, Object value) {
        assert (key instanceof HiddenKey);
        DynamicObjectLibrary.getUncached().put(obj, key, value);
    }

    public static Object getHiddenProperty(DynamicObject obj, Object key) {
        assert (key instanceof HiddenKey);
        return DynamicObjectLibrary.getUncached().getOrDefault(obj, key, null);
    }

    public static boolean hasHiddenProperty(DynamicObject obj, Object key) {
        assert (key instanceof HiddenKey);
        return DynamicObjectLibrary.getUncached().containsKey(obj, key);
    }

    public static DynamicObjectLibrary createCached(Object key, DynamicObject obj) {
        assert (key != null);
        return DynamicObjectLibrary.getFactory().create(obj);
    }

    public static DynamicObjectLibrary createDispatched(Object key, int limit) {
        assert (key != null);
        return DynamicObjectLibrary.getFactory().createDispatched(limit);
    }

    public static DynamicObjectLibrary createDispatched(Object key) {
        return JSObjectUtil.createDispatched(key, 5);
    }

    public static <T extends DynamicObject> T copyProperties(T target, DynamicObject source) {
        DynamicObjectLibrary objectLibrary = DynamicObjectLibrary.getUncached();
        for (Property property : source.getShape().getPropertyListInternal(true)) {
            Object key = property.getKey();
            if (objectLibrary.containsKey(target, key)) continue;
            Object value = objectLibrary.getOrDefault(source, key, null);
            if (property.getLocation().isConstant()) {
                objectLibrary.putConstant(target, key, value, property.getFlags());
                continue;
            }
            objectLibrary.putWithFlags(target, key, value, property.getFlags());
        }
        return target;
    }
}

