/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.FrameDescriptorProvider;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Dead;
import java.util.ArrayList;

@ExportLibrary(value=InteropLibrary.class)
final class ScopeMembers
implements TruffleObject {
    private final Frame frame;
    private final Node blockOrRoot;
    private final Frame functionFrame;
    private Object[] members;

    ScopeMembers(Frame frame, Node blockOrRoot, Frame functionFrame) {
        this.frame = frame;
        this.blockOrRoot = blockOrRoot;
        this.functionFrame = functionFrame;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    Object readArrayElement(long index) throws InvalidArrayIndexException {
        Object[] allMembers = this.getAllMembers();
        if (0L <= index && index < (long)allMembers.length) {
            return allMembers[(int)index];
        }
        throw InvalidArrayIndexException.create(index);
    }

    @ExportMessage
    long getArraySize() {
        return this.getAllMembers().length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return 0L <= index && index < (long)this.getAllMembers().length;
    }

    private Object[] getAllMembers() {
        if (CompilerDirectives.injectBranchProbability(1.0E-4, this.members == null)) {
            this.members = this.collectAllMembers();
        }
        return this.members;
    }

    /*
     * WARNING - void declaration
     */
    @CompilerDirectives.TruffleBoundary
    private Object[] collectAllMembers() {
        ArrayList<Key> membersList = new ArrayList<Key>();
        if (this.frame == null) {
            Node descNode = this.blockOrRoot;
            while (descNode != null && descNode instanceof FrameDescriptorProvider) {
                FrameDescriptor desc = ((FrameDescriptorProvider)((Object)descNode)).getFrameDescriptor();
                for (FrameSlot frameSlot : desc.getSlots()) {
                    if (JSFrameUtil.isInternal(frameSlot)) continue;
                    membersList.add(new Key(frameSlot.getIdentifier().toString(), descNode, frameSlot));
                }
                descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
            }
        } else {
            Node descNode = this.blockOrRoot;
            Frame outerFrame = this.frame;
            Frame currentFunctionFrame = this.functionFrame;
            do {
                Frame frame = outerFrame;
                boolean seenThis = false;
                while (true) {
                    FrameSlot frameSlot;
                    void var5_9;
                    FrameDescriptor frameDescriptor = var5_9.getFrameDescriptor();
                    for (FrameSlot frameSlot2 : frameDescriptor.getSlots()) {
                        if (JSFrameUtil.isInternal(frameSlot2)) {
                            if (!JSFrameUtil.isThisSlot(frameSlot2)) continue;
                            membersList.add(new Key("this", descNode, null));
                            seenThis = true;
                            continue;
                        }
                        if (ScopeMembers.isUnsetFrameSlot((Frame)var5_9, frameSlot2)) continue;
                        membersList.add(new Key(frameSlot2.getIdentifier().toString(), descNode, frameSlot2));
                    }
                    FrameSlot evalScopeSlot = frameDescriptor.findFrameSlot("<evalscope>");
                    if (evalScopeSlot != null) {
                        DynamicObject dynamicObject = (DynamicObject)FrameUtil.getObjectSafe((Frame)var5_9, evalScopeSlot);
                        DynamicObjectLibrary objLib = DynamicObjectLibrary.getUncached();
                        for (Object key : objLib.getKeyArray(dynamicObject)) {
                            membersList.add(new Key(key.toString(), descNode, null));
                        }
                    }
                    if ((frameSlot = frameDescriptor.findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER)) == null) break;
                    Object parent = FrameUtil.getObjectSafe((Frame)var5_9, frameSlot);
                    if (parent instanceof Frame) {
                        Frame frame2 = (Frame)parent;
                    } else {
                        if (currentFunctionFrame == null || currentFunctionFrame == var5_9) break;
                        Frame frame3 = currentFunctionFrame;
                    }
                    if (descNode == null) continue;
                    descNode = JavaScriptNode.findBlockScopeNode(descNode.getParent());
                }
                if (!seenThis) {
                    membersList.add(new Key("this", descNode, null));
                }
                outerFrame = JSArguments.getEnclosingFrame(outerFrame.getArguments());
                currentFunctionFrame = null;
            } while (outerFrame != JSFrameUtil.NULL_MATERIALIZED_FRAME);
        }
        return membersList.toArray();
    }

    static boolean isUnsetFrameSlot(Frame frame, FrameSlot slot) {
        Object value;
        return frame != null && frame.isObject(slot) && ((value = FrameUtil.getObjectSafe(frame, slot)) == null || value == Dead.instance() || value instanceof Frame);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class Key
    implements TruffleObject {
        private final String name;
        private final Node blockOrRoot;
        private final FrameSlot slot;
        private SourceSection sourceLocation;

        Key(String name, Node blockOrRoot, FrameSlot slot) {
            this.name = name;
            this.slot = slot;
            this.blockOrRoot = blockOrRoot;
        }

        @ExportMessage
        boolean isString() {
            return true;
        }

        @ExportMessage
        String asString() {
            return this.name;
        }

        public String toString() {
            return this.asString();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean hasSourceLocation() {
            return this.getOrFindSourceLocation().isAvailable();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        SourceSection getSourceLocation() throws UnsupportedMessageException {
            if (!this.hasSourceLocation()) {
                throw UnsupportedMessageException.create();
            }
            return this.sourceLocation;
        }

        private SourceSection getOrFindSourceLocation() {
            CompilerAsserts.neverPartOfCompilation();
            if (this.sourceLocation == null && this.blockOrRoot != null) {
                this.sourceLocation = this.findSourceLocation();
            }
            if (this.sourceLocation == null) {
                this.sourceLocation = JSBuiltin.createSourceSection();
            }
            return this.sourceLocation;
        }

        private SourceSection findSourceLocation() {
            if (this.slot != null) {
                class DeclarationFinder
                implements NodeVisitor {
                    JavaScriptNode found;

                    DeclarationFinder() {
                    }

                    @Override
                    public boolean visit(Node node) {
                        if (node instanceof JavaScriptNode) {
                            JSWriteFrameSlotNode write;
                            if (node instanceof JSWriteFrameSlotNode && (write = (JSWriteFrameSlotNode)node).getFrameSlot() == Key.this.slot && write.hasSourceSection()) {
                                this.found = write;
                                return false;
                            }
                            return true;
                        }
                        if (node == Key.this.blockOrRoot) {
                            return true;
                        }
                        return node instanceof BlockNode;
                    }
                }
                DeclarationFinder finder = new DeclarationFinder();
                this.blockOrRoot.accept(finder);
                if (finder.found != null) {
                    return finder.found.getSourceSection();
                }
            }
            return this.blockOrRoot.getEncapsulatingSourceSection();
        }
    }
}

