/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.SegmentIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmenterFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmenterPrototypeBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmentsPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmentIteratorObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenterObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmentsObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.Locale;

public final class JSSegmenter
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "Segmenter";
    public static final String PROTOTYPE_NAME = "Segmenter.prototype";
    public static final String SEGMENTS_PROTOTYPE_NAME = "Segments.prototype";
    public static final String ITERATOR_CLASS_NAME = "Segmenter String Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Segment Iterator.prototype";
    public static final JSSegmenter INSTANCE = new JSSegmenter();

    private JSSegmenter() {
    }

    public static boolean isJSSegmenter(Object obj) {
        return obj instanceof JSSegmenterObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject segmenterPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, segmenterPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, segmenterPrototype, SegmenterPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(segmenterPrototype, "Intl.Segmenter");
        return segmenterPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, SegmenterFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getSegmenterFactory();
        JSSegmenterObject obj = new JSSegmenterObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSSegmenter.isJSSegmenter(obj));
        return context.trackAllocation(obj);
    }

    public static DynamicObject createSegmentIterator(JSContext context, JSRealm realm, DynamicObject segmenter, String value) {
        BreakIterator icuIterator = JSSegmenter.createBreakIterator(segmenter, value);
        Granularity granularity = JSSegmenter.getGranularity(segmenter);
        IteratorState iteratorState = new IteratorState(value, icuIterator, granularity);
        JSObjectFactory factory = context.getSegmentIteratorFactory();
        JSSegmentIteratorObject segmentIterator = new JSSegmentIteratorObject(factory.getShape(realm), iteratorState);
        factory.initProto(segmentIterator, realm);
        return context.trackAllocation(segmentIterator);
    }

    public static DynamicObject createSegments(JSContext context, JSRealm realm, JSSegmenterObject segmenter, String string) {
        JSObjectFactory factory = context.getSegmentsFactory();
        JSSegmentsObject segments = new JSSegmentsObject(factory.getShape(realm), segmenter, string);
        factory.initProto(segments, realm);
        return context.trackAllocation(segments);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setLocale(JSContext ctx, InternalState state, String[] locales) {
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        state.locale = strippedLocale.toLanguageTag();
        state.javaLocale = strippedLocale;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalBreakIterator(InternalState state, String granularity) {
        state.javaLocale = Locale.forLanguageTag(state.locale);
        switch (granularity) {
            case "grapheme": {
                state.granularity = Granularity.GRAPHEME;
                break;
            }
            case "word": {
                state.granularity = Granularity.WORD;
                break;
            }
            case "sentence": {
                state.granularity = Granularity.SENTENCE;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(String.format("Segmenter with granularity, %s, is not supported", granularity));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static BreakIterator createBreakIterator(DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        ULocale ulocale = ULocale.forLocale(state.javaLocale);
        BreakIterator icuIterator = state.granularity.getIterator(ulocale);
        return icuIterator;
    }

    @CompilerDirectives.TruffleBoundary
    public static BreakIterator createBreakIterator(DynamicObject segmenterObj, String text) {
        BreakIterator icuIterator = JSSegmenter.createBreakIterator(segmenterObj);
        icuIterator.setText(text);
        return icuIterator;
    }

    public static Granularity getGranularity(DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        return state.granularity;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, JSRealm realm, DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        return state.toResolvedOptionsObject(context, realm);
    }

    public static InternalState getInternalState(DynamicObject segmenterObj) {
        assert (JSSegmenter.isJSSegmenter(segmenterObj));
        return ((JSSegmenterObject)segmenterObj).getInternalState();
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSegmenterPrototype();
    }

    public static Shape makeInitialSegmentsShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, JSOrdinary.BARE_INSTANCE, ctx);
    }

    public static boolean isJSSegments(Object obj) {
        return obj instanceof JSSegmentsObject;
    }

    public static DynamicObject createSegmentsPrototype(JSRealm realm) {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SegmentsPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    public static Shape makeInitialSegmentIteratorShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, JSOrdinary.BARE_INSTANCE, ctx);
    }

    public static boolean isJSSegmentIterator(Object obj) {
        return obj instanceof JSSegmentIteratorObject;
    }

    public static DynamicObject createSegmentIteratorPrototype(JSRealm realm) {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getIteratorPrototype());
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SegmentIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, ITERATOR_CLASS_NAME);
        return prototype;
    }

    public static class InternalState {
        private String locale;
        private Locale javaLocale;
        Granularity granularity = Granularity.GRAPHEME;

        DynamicObject toResolvedOptionsObject(JSContext context, JSRealm realm) {
            DynamicObject result = JSOrdinary.create(context, realm);
            JSObjectUtil.defineDataProperty(context, result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(context, result, "granularity", this.granularity.getName(), JSAttributes.getDefault());
            return result;
        }
    }

    public static enum Granularity implements IcuIteratorHelper
    {
        GRAPHEME("grapheme"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getCharacterInstance(locale);
            }
        }
        ,
        WORD("word"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getWordInstance(locale);
            }
        }
        ,
        SENTENCE("sentence"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getSentenceInstance(locale);
            }
        };

        private String name;

        private Granularity(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static interface IcuIteratorHelper {
        public BreakIterator getIterator(ULocale var1);
    }

    public static class IteratorState {
        private final String iteratedString;
        private final BreakIterator breakIterator;
        private final Granularity granularity;

        public IteratorState(String iteratedObject, BreakIterator breakIterator, Granularity granularity) {
            this.iteratedString = iteratedObject;
            this.breakIterator = breakIterator;
            this.granularity = granularity;
        }

        public String getIteratedString() {
            return this.iteratedString;
        }

        public Granularity getSegmenterGranularity() {
            return this.granularity;
        }

        public BreakIterator getBreakIterator() {
            return this.breakIterator;
        }
    }
}

