/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

public abstract class JSClass
extends ObjectType {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected JSClass() {
    }

    @CompilerDirectives.TruffleBoundary
    public abstract DynamicObject getPrototypeOf(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean setPrototypeOf(DynamicObject var1, DynamicObject var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean isExtensible(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean preventExtensions(DynamicObject var1, boolean var2);

    @CompilerDirectives.TruffleBoundary
    public abstract PropertyDescriptor getOwnProperty(DynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean defineOwnProperty(DynamicObject var1, Object var2, PropertyDescriptor var3, boolean var4);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasProperty(DynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasProperty(DynamicObject var1, long var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOwnProperty(DynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOwnProperty(DynamicObject var1, long var2);

    public final Object get(DynamicObject thisObj, Object key) {
        return JSRuntime.nullToUndefined(this.getHelper(thisObj, (Object)thisObj, key, null));
    }

    public Object get(DynamicObject thisObj, long index) {
        return JSRuntime.nullToUndefined(this.getHelper(thisObj, (Object)thisObj, index, (Node)null));
    }

    @CompilerDirectives.TruffleBoundary
    public abstract Object getHelper(DynamicObject var1, Object var2, Object var3, Node var4);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getHelper(DynamicObject var1, Object var2, long var3, Node var5);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getOwnHelper(DynamicObject var1, Object var2, Object var3, Node var4);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getOwnHelper(DynamicObject var1, Object var2, long var3, Node var5);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getMethodHelper(DynamicObject var1, Object var2, Object var3, Node var4);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean set(DynamicObject var1, Object var2, Object var3, Object var4, boolean var5, Node var6);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean set(DynamicObject var1, long var2, Object var4, Object var5, boolean var6, Node var7);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean delete(DynamicObject var1, Object var2, boolean var3);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean delete(DynamicObject var1, long var2, boolean var4);

    public final List<Object> ownPropertyKeys(DynamicObject obj) {
        return this.getOwnPropertyKeys(obj, true, true);
    }

    @CompilerDirectives.TruffleBoundary
    public abstract List<Object> getOwnPropertyKeys(DynamicObject var1, boolean var2, boolean var3);

    @CompilerDirectives.TruffleBoundary
    public static List<Object> filterOwnPropertyKeys(List<Object> ownPropertyKeys, boolean strings, boolean symbols) {
        if (strings && symbols) {
            return ownPropertyKeys;
        }
        ArrayList<Object> names = new ArrayList<Object>();
        for (Object key : ownPropertyKeys) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof String) continue;
            names.add(key);
        }
        return names;
    }

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOnlyShapeProperties(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract String getClassName(DynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract String toString();

    @CompilerDirectives.TruffleBoundary
    public String defaultToString(DynamicObject object) {
        JSContext context = JSObject.getJSContext(object);
        if (context.getEcmaScriptVersion() <= 5) {
            return this.formatToString(this.getClassName(object));
        }
        String result = this.getToStringTag(object);
        return this.formatToString(result);
    }

    protected String getToStringTag(DynamicObject object) {
        Object toStringTag;
        String result = this.getBuiltinToStringTag(object);
        if (JSRuntime.isObject(object) && JSRuntime.isString(toStringTag = JSObject.get(object, Symbol.SYMBOL_TO_STRING_TAG))) {
            result = JSRuntime.toStringIsString(toStringTag);
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @CompilerDirectives.TruffleBoundary
    protected String formatToString(String object) {
        return "[object " + object + "]";
    }

    @CompilerDirectives.TruffleBoundary
    public abstract String toDisplayStringImpl(DynamicObject var1, int var2, boolean var3);

    public final boolean isInstance(DynamicObject object) {
        return JSClass.isInstance(object, this);
    }

    public final boolean isInstance(Object object) {
        return JSClass.isInstance(object, this);
    }

    public static boolean isInstance(Object object, JSClass jsclass) {
        return JSDynamicObject.isJSDynamicObject(object) && JSClass.isInstance((DynamicObject)object, jsclass);
    }

    public static boolean isInstance(DynamicObject object, JSClass jsclass) {
        return object.getShape().getDynamicType() == jsclass;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean testIntegrityLevel(DynamicObject obj, boolean frozen) {
        return this.testIntegrityLevelDefault(obj, frozen);
    }

    @CompilerDirectives.TruffleBoundary
    protected final boolean testIntegrityLevelDefault(DynamicObject obj, boolean frozen) {
        assert (JSRuntime.isObject(obj));
        boolean status = this.isExtensible(obj);
        if (status) {
            return false;
        }
        for (Object key : JSObject.ownPropertyKeys(obj)) {
            PropertyDescriptor desc = JSObject.getOwnProperty(obj, key);
            if (desc == null) continue;
            if (desc.getConfigurable()) {
                return false;
            }
            if (!frozen || !desc.isDataDescriptor() || !desc.getWritable()) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(DynamicObject obj, boolean freeze, boolean doThrow) {
        return this.setIntegrityLevelDefault(obj, freeze, doThrow);
    }

    @CompilerDirectives.TruffleBoundary
    private boolean setIntegrityLevelDefault(DynamicObject obj, boolean freeze, boolean doThrow) {
        assert (JSRuntime.isObject(obj));
        if (!this.preventExtensions(obj, doThrow)) {
            return false;
        }
        List<Object> keys = JSObject.ownPropertyKeys(obj);
        if (freeze) {
            for (Object t : keys) {
                PropertyDescriptor currentDesc = JSObject.getOwnProperty(obj, t);
                if (currentDesc == null) continue;
                PropertyDescriptor newDesc = null;
                newDesc = currentDesc.isAccessorDescriptor() ? FreezeHolder.FREEZE_ACC_DESC : FreezeHolder.FREEZE_DATA_DESC;
                JSRuntime.definePropertyOrThrow(obj, t, newDesc);
            }
        } else {
            for (Object t : keys) {
                JSRuntime.definePropertyOrThrow(obj, t, FreezeHolder.FREEZE_ACC_DESC);
            }
        }
        return true;
    }

    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        throw Errors.shouldNotReachHere(this.getClass().getName());
    }

    public abstract boolean usesOrdinaryGetOwnProperty();

    public abstract boolean usesOrdinaryIsExtensible();

    private static final class FreezeHolder {
        private static final PropertyDescriptor FREEZE_ACC_DESC = PropertyDescriptor.createEmpty();
        private static final PropertyDescriptor FREEZE_DATA_DESC;

        private FreezeHolder() {
        }

        static {
            FREEZE_ACC_DESC.setConfigurable(false);
            FREEZE_DATA_DESC = PropertyDescriptor.createEmpty();
            FREEZE_DATA_DESC.setConfigurable(false);
            FREEZE_DATA_DESC.setWritable(false);
        }
    }
}

