/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BaseNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BlockExpression;
import com.oracle.js.parser.ir.BlockStatement;
import com.oracle.js.parser.ir.BreakNode;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.CaseNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ContinueNode;
import com.oracle.js.parser.ir.DebuggerNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IndexNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.LexicalContextScope;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.ParameterNode;
import com.oracle.js.parser.ir.Scope;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.SwitchNode;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.TemplateLiteralNode;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.ThrowNode;
import com.oracle.js.parser.ir.TryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WhileNode;
import com.oracle.js.parser.ir.WithNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.DeclareEvalVariableNode;
import com.oracle.truffle.js.nodes.access.DeclareGlobalNode;
import com.oracle.truffle.js.nodes.access.GlobalPropertyNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNode;
import com.oracle.truffle.js.nodes.access.OptionalChainNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.VarWrapperNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.access.WritePropertyNode;
import com.oracle.truffle.js.nodes.binary.DualNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSTypeofIdenticalNode;
import com.oracle.truffle.js.nodes.control.AbstractBlockNode;
import com.oracle.truffle.js.nodes.control.BreakTarget;
import com.oracle.truffle.js.nodes.control.ContinueTarget;
import com.oracle.truffle.js.nodes.control.DiscardResultNode;
import com.oracle.truffle.js.nodes.control.EmptyNode;
import com.oracle.truffle.js.nodes.control.GeneratorWrapperNode;
import com.oracle.truffle.js.nodes.control.IfNode;
import com.oracle.truffle.js.nodes.control.ModuleYieldNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.ReturnNode;
import com.oracle.truffle.js.nodes.control.ReturnTargetNode;
import com.oracle.truffle.js.nodes.control.SequenceNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.SuspendNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.nodes.function.JSNewNode;
import com.oracle.truffle.js.nodes.function.SpreadArgumentNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.nodes.unary.TypeOfNode;
import com.oracle.truffle.js.nodes.unary.VoidNode;
import com.oracle.truffle.js.parser.DirectEvalContext;
import com.oracle.truffle.js.parser.env.BlockEnvironment;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.parser.env.EvalEnvironment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.parser.env.GlobalEnvironment;
import com.oracle.truffle.js.parser.env.WithEnvironment;
import com.oracle.truffle.js.parser.internal.ir.debug.PrintVisitor;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.InternalSlotId;
import com.oracle.truffle.js.runtime.util.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

abstract class GraalJSTranslator
extends TranslatorNodeVisitor<LexicalContext, JavaScriptNode> {
    public static final JavaScriptNode[] EMPTY_NODE_ARRAY = new JavaScriptNode[0];
    private static final JavaScriptNode ANY_JAVA_SCRIPT_NODE = new JavaScriptNode(){

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException();
        }
    };
    private static final SourceSection unavailableInternalSection = Source.newBuilder("js", "<internal>", "<internal>").mimeType("application/javascript").internal(true).build().createUnavailableSection();
    private Environment environment;
    protected final JSContext context;
    protected final NodeFactory factory;
    protected final Source source;
    protected final String[] argumentNames;
    protected final int sourceLength;
    protected final int prologLength;
    private final boolean isParentStrict;
    private Consumer<ScriptOrModule> scriptOrModuleResolver;

    protected GraalJSTranslator(LexicalContext lc, NodeFactory factory, JSContext context, Source source, String[] argumentNames, int prologLength, Environment environment, boolean isParentStrict) {
        super(lc);
        this.context = context;
        this.environment = environment;
        this.factory = factory;
        this.source = source;
        this.argumentNames = argumentNames;
        this.isParentStrict = isParentStrict;
        this.sourceLength = source.getCharacters().length();
        this.prologLength = prologLength;
    }

    protected final JavaScriptNode transform(Node node) {
        if (node != null) {
            return node.accept(this);
        }
        return null;
    }

    private JavaScriptNode tagStatement(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
        }
        assert (resultNode.getSourceSection() != null);
        if (resultNode instanceof VarWrapperNode) {
            this.tagStatement(((VarWrapperNode)resultNode).getDelegateNode(), parseNode);
        } else {
            resultNode.addStatementTag();
        }
        return resultNode;
    }

    private JavaScriptNode tagExpression(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
        }
        assert (resultNode.getSourceSection() != null);
        if (resultNode instanceof VarWrapperNode) {
            this.tagExpression(((VarWrapperNode)resultNode).getDelegateNode(), parseNode);
        } else {
            resultNode.addExpressionTag();
        }
        return resultNode;
    }

    private static JavaScriptNode tagCall(JavaScriptNode resultNode) {
        resultNode.addCallTag();
        return resultNode;
    }

    private JavaScriptNode tagBody(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
        }
        assert (resultNode.getSourceSection() != null);
        if (resultNode instanceof VarWrapperNode) {
            this.tagBody(((VarWrapperNode)resultNode).getDelegateNode(), parseNode);
        } else {
            resultNode.addRootBodyTag();
        }
        return resultNode;
    }

    private FunctionEnvironment currentFunction() {
        return this.environment.function();
    }

    private JavaScriptNode createBlock(JavaScriptNode ... statements) {
        return this.createBlock(statements, false, false);
    }

    private JavaScriptNode createBlock(JavaScriptNode[] statements, boolean terminal, boolean expressionBlock) {
        if (terminal || expressionBlock || this.currentFunction().returnsLastStatementResult()) {
            return this.factory.createExprBlock(statements);
        }
        return this.factory.createVoidBlock(statements);
    }

    protected final JavaScriptNode transformFunction(FunctionNode functionNode) {
        return this.transform(functionNode);
    }

    protected abstract GraalJSTranslator newTranslator(Environment var1, LexicalContext var2);

    protected final void resolveScriptOrModule(ScriptOrModule scriptOrModule) {
        if (this.scriptOrModuleResolver != null) {
            this.scriptOrModuleResolver.accept(scriptOrModule);
        }
    }

    @Override
    public JavaScriptNode enterFunctionNode(final FunctionNode functionNode) {
        JavaScriptNode functionExpression;
        FunctionRootNode functionRoot;
        JSFunctionData functionData;
        FrameSlot blockScopeSlot;
        boolean isGlobal;
        boolean isConstructor;
        final boolean isStrict = functionNode.isStrict() || this.isParentStrict || this.environment != null && this.environment.function() != null && this.environment.isStrictMode();
        boolean isArrowFunction = functionNode.isArrow();
        boolean isGeneratorFunction = functionNode.isGenerator();
        boolean isAsyncFunction = functionNode.isAsync();
        boolean isDerivedConstructor = functionNode.isDerivedConstructor();
        boolean isMethod = functionNode.isMethod();
        boolean needsNewTarget = functionNode.needsNewTarget();
        boolean isClassConstructor = functionNode.isClassConstructor();
        boolean bl = isConstructor = !isArrowFunction && !isGeneratorFunction && !isAsyncFunction && (!isMethod || this.context.getEcmaScriptVersion() == 5 || isClassConstructor);
        assert (!isDerivedConstructor || isConstructor);
        boolean strictFunctionProperties = isStrict || isArrowFunction || isMethod || isGeneratorFunction;
        boolean isBuiltin = false;
        final boolean hasSyntheticArguments = functionNode.isScript() && this.argumentNames != null;
        boolean isEval = false;
        boolean isIndirectEval = false;
        boolean inDirectEval = false;
        if (this.environment instanceof EvalEnvironment) {
            isEval = true;
            boolean isDirectEval = ((EvalEnvironment)this.environment).isDirectEval();
            isIndirectEval = !isDirectEval;
            Environment evalParent = this.environment.getParent();
            isGlobal = evalParent == null || isDirectEval && !isStrict && evalParent.function().isGlobal();
            inDirectEval = isDirectEval || evalParent != null && evalParent.function().inDirectEval();
        } else if (this.environment instanceof DebugEnvironment) {
            isGlobal = this.environment.getParent() == null;
            isEval = true;
            inDirectEval = true;
        } else {
            isGlobal = this.environment == null && this.argumentNames == null;
            inDirectEval = this.environment != null && this.currentFunction().inDirectEval();
        }
        boolean functionMode = !isGlobal || isStrict && isIndirectEval;
        boolean lazyTranslation = this.context.getContextOptions().isLazyTranslation() && functionMode && !functionNode.isProgram() && !inDirectEval;
        final String functionName = this.getFunctionName(functionNode);
        if (lazyTranslation) {
            assert (functionMode && !functionNode.isProgram() && !functionNode.isModule());
            final boolean needsParentFrame = functionNode.usesAncestorScope();
            blockScopeSlot = needsParentFrame && this.environment != null ? this.environment.getCurrentBlockScopeSlot() : null;
            functionData = this.factory.createFunctionData(this.context, functionNode.getLength(), functionName, isConstructor, isDerivedConstructor, isStrict, isBuiltin, needsParentFrame, isGeneratorFunction, isAsyncFunction, isClassConstructor, strictFunctionProperties, needsNewTarget);
            final LexicalContext savedLC = this.lc.copy();
            final Environment parentEnv = this.environment;
            functionData.setLazyInit(new JSFunctionData.Initializer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void initializeRoot(JSFunctionData fd) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        if (fd.getRootTarget() == null) {
                            GraalJSTranslator translator = GraalJSTranslator.this.newTranslator(parentEnv, savedLC);
                            translator.translateFunctionOnDemand(functionNode, fd, isStrict, isGlobal, needsParentFrame, functionName, hasSyntheticArguments);
                            fd.releaseLazyInit();
                        }
                    }
                }
            });
            functionRoot = null;
        } else {
            Environment prevEnv = this.environment;
            try (EnvironmentCloseable functionEnv = this.enterFunctionEnvironment(functionNode, isStrict, isGlobal, hasSyntheticArguments);){
                List<JavaScriptNode> declarations;
                FunctionEnvironment currentFunction = this.currentFunction();
                currentFunction.setFunctionName(functionName);
                currentFunction.setInternalFunctionName(functionNode.getInternalName());
                currentFunction.setNamedFunctionExpression(functionNode.isNamedFunctionExpression());
                this.declareParameters(functionNode);
                if (functionMode) {
                    declarations = this.functionEnvInit(functionNode);
                } else if (functionNode.isModule()) {
                    assert (currentFunction.isGlobal());
                    declarations = Collections.emptyList();
                } else {
                    assert (currentFunction.isGlobal());
                    declarations = this.collectGlobalVars(functionNode, isEval);
                }
                if (functionNode.isProgram()) {
                    GraalJSTranslator.functionNeedsParentFramePass(functionNode, this.context);
                }
                boolean needsParentFrame = functionNode.usesAncestorScope();
                currentFunction.setNeedsParentFrame(needsParentFrame);
                JavaScriptNode body = this.translateFunctionBody(functionNode, declarations);
                needsParentFrame = currentFunction.needsParentFrame();
                blockScopeSlot = needsParentFrame && prevEnv != null ? prevEnv.getCurrentBlockScopeSlot() : null;
                functionData = this.factory.createFunctionData(this.context, functionNode.getLength(), functionName, isConstructor, isDerivedConstructor, isStrict, isBuiltin, needsParentFrame, isGeneratorFunction, isAsyncFunction, isClassConstructor, strictFunctionProperties, needsNewTarget);
                functionRoot = functionNode.isModule() ? this.createModuleRoot(functionNode, functionData, currentFunction, body) : this.createFunctionRoot(functionNode, functionData, currentFunction, body);
                currentFunction.freeze();
                if (isEval) {
                    functionData.getCallTarget();
                }
            }
        }
        if (isArrowFunction && functionNode.needsThis() && !this.currentFunction().getNonArrowParentFunction().isDerivedConstructor()) {
            JavaScriptNode thisNode = this.createThisNode();
            functionExpression = this.factory.createFunctionExpressionLexicalThis(functionData, functionRoot, blockScopeSlot, thisNode);
        } else {
            functionExpression = this.factory.createFunctionExpression(functionData, functionRoot, blockScopeSlot);
        }
        if (functionNode.isDeclared()) {
            this.ensureHasSourceSection(functionExpression, functionNode);
        } else {
            functionExpression = this.tagExpression(functionExpression, functionNode);
        }
        return functionExpression;
    }

    JavaScriptNode translateFunctionBody(FunctionNode functionNode, List<JavaScriptNode> declarations) {
        JavaScriptNode body = this.transform(functionNode.getBody());
        if (functionNode.isAsync() && !functionNode.isGenerator()) {
            this.ensureHasSourceSection(body, functionNode);
            body = this.handleAsyncFunctionBody(body);
        }
        if (!declarations.isEmpty()) {
            body = this.prepareDeclarations(declarations, body);
        }
        return body;
    }

    private FunctionRootNode translateFunctionOnDemand(FunctionNode functionNode, JSFunctionData functionData, boolean isStrict, boolean isGlobal, boolean needsParentFrame, String functionName, boolean hasSyntheticArguments) {
        try (EnvironmentCloseable functionEnv = this.enterFunctionEnvironment(functionNode, isStrict, isGlobal, hasSyntheticArguments);){
            FunctionEnvironment currentFunction = this.currentFunction();
            currentFunction.setFunctionName(functionName);
            currentFunction.setInternalFunctionName(functionNode.getInternalName());
            currentFunction.setNamedFunctionExpression(functionNode.isNamedFunctionExpression());
            currentFunction.setNeedsParentFrame(needsParentFrame);
            this.declareParameters(functionNode);
            this.functionEnvInit(functionNode);
            JavaScriptNode body = this.translateFunctionBody(functionNode, Collections.emptyList());
            currentFunction.freeze();
            assert (currentFunction.isDeepFrozen());
            FunctionRootNode functionRootNode = this.createFunctionRoot(functionNode, functionData, currentFunction, body);
            return functionRootNode;
        }
    }

    private FunctionRootNode createFunctionRoot(FunctionNode functionNode, JSFunctionData functionData, FunctionEnvironment currentFunction, JavaScriptNode body) {
        SourceSection functionSourceSection = this.createSourceSection(functionNode);
        FunctionBodyNode functionBody = this.factory.createFunctionBody(body);
        FunctionRootNode functionRoot = this.factory.createFunctionRootNode(functionBody, this.environment.getFunctionFrameDescriptor(), functionData, functionSourceSection, currentFunction.getInternalFunctionName());
        if (currentFunction.isScriptOrModule()) {
            this.scriptOrModuleResolver = currentFunction.getScriptOrModuleResolver();
        }
        return functionRoot;
    }

    private FunctionRootNode createModuleRoot(FunctionNode functionNode, JSFunctionData functionData, FunctionEnvironment currentFunction, JavaScriptNode body) {
        this.scriptOrModuleResolver = currentFunction.getScriptOrModuleResolver();
        SourceSection moduleSourceSection = this.createSourceSection(functionNode);
        String internalFunctionName = currentFunction.getInternalFunctionName();
        JavaScriptNode[] statements = null;
        if (body instanceof SequenceNode) {
            statements = ((SequenceNode)((Object)body)).getStatements();
        } else if (GraalJSTranslator.isModuleYieldStatement(body)) {
            statements = new JavaScriptNode[]{body};
        }
        if (statements != null) {
            for (int i = 0; i < statements.length; ++i) {
                JavaScriptNode statement = statements[i];
                if (!GraalJSTranslator.isModuleYieldStatement(statement)) continue;
                JavaScriptNode[] linkHalf = Arrays.copyOfRange(statements, 0, i);
                JavaScriptNode[] evalHalf = Arrays.copyOfRange(statements, i + 1, statements.length);
                JavaScriptNode linkBlock = this.tagBody(this.factory.createModuleInitializeEnvironment(this.factory.createVoidBlock(linkHalf)), functionNode);
                JavaScriptNode evalBlock = this.handleModuleBody(this.factory.createExprBlock(evalHalf));
                FunctionBodyNode linkBody = this.factory.createFunctionBody(linkBlock);
                FunctionBodyNode evalBody = this.factory.createFunctionBody(evalBlock);
                return this.factory.createModuleRootNode(linkBody, evalBody, this.environment.getFunctionFrameDescriptor(), functionData, moduleSourceSection, internalFunctionName);
            }
        }
        currentFunction.addYield();
        FunctionBodyNode generatorBody = this.factory.createFunctionBody(this.handleModuleBody(body));
        return this.factory.createModuleRootNode(generatorBody, generatorBody, this.environment.getFunctionFrameDescriptor(), functionData, moduleSourceSection, internalFunctionName);
    }

    private static void printAST(com.oracle.truffle.api.nodes.Node functionRoot) {
        NodeUtil.printCompactTree(System.out, functionRoot);
    }

    private static void printParse(FunctionNode functionNode) {
        System.out.printf(new PrintVisitor(functionNode).toString(), new Object[0]);
    }

    private JavaScriptNode finishDerivedConstructorBody(FunctionNode function, JavaScriptNode body) {
        JavaScriptNode getThisBinding = function.hasDirectSuper() || function.hasEval() || function.hasArrowEval() ? this.environment.findThisVar().createReadNode() : this.factory.createConstantUndefined();
        getThisBinding = this.checkThisBindingInitialized(getThisBinding);
        return this.factory.createDerivedConstructorResult(body, getThisBinding);
    }

    private JavaScriptNode handleAsyncFunctionBody(JavaScriptNode body) {
        assert (this.currentFunction().isAsyncFunction() && !this.currentFunction().isGeneratorFunction());
        Environment.VarRef asyncContextVar = this.environment.findAsyncContextVar();
        Environment.VarRef asyncResultVar = this.environment.findAsyncResultVar();
        JSWriteFrameSlotNode writeResultNode = (JSWriteFrameSlotNode)asyncResultVar.createWriteNode(null);
        JSWriteFrameSlotNode writeContextNode = (JSWriteFrameSlotNode)asyncContextVar.createWriteNode(null);
        JSReadFrameSlotNode readContextNode = (JSReadFrameSlotNode)asyncContextVar.createReadNode();
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        return this.factory.createAsyncFunctionBody(this.context, instrumentedBody, writeContextNode, readContextNode, writeResultNode);
    }

    private JavaScriptNode finishGeneratorBody(JavaScriptNode body) {
        assert (this.lc.getCurrentBlock().isFunctionBody());
        assert (!this.currentFunction().isModule());
        if (this.currentFunction().isAsyncGeneratorFunction()) {
            return this.handleAsyncGeneratorBody(body);
        }
        return this.handleGeneratorBody(body);
    }

    private JavaScriptNode handleGeneratorBody(JavaScriptNode body) {
        assert (this.currentFunction().isGeneratorFunction() && !this.currentFunction().isAsyncGeneratorFunction() && !this.currentFunction().isModule());
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        Environment.VarRef yieldVar = this.environment.findYieldValueVar();
        JSWriteFrameSlotNode writeYieldValueNode = (JSWriteFrameSlotNode)yieldVar.createWriteNode(null);
        JSReadFrameSlotNode readYieldResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getYieldResultSlot()).createReadNode();
        return this.factory.createGeneratorBody(this.context, instrumentedBody, writeYieldValueNode, readYieldResultNode);
    }

    private JavaScriptNode handleAsyncGeneratorBody(JavaScriptNode body) {
        assert (this.currentFunction().isAsyncGeneratorFunction() && !this.currentFunction().isModule());
        Environment.VarRef asyncContextVar = this.environment.findAsyncContextVar();
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        Environment.VarRef yieldVar = this.environment.findAsyncResultVar();
        JSWriteFrameSlotNode writeAsyncContextNode = (JSWriteFrameSlotNode)asyncContextVar.createWriteNode(null);
        JSReadFrameSlotNode readAsyncContextNode = (JSReadFrameSlotNode)asyncContextVar.createReadNode();
        JSWriteFrameSlotNode writeYieldValueNode = (JSWriteFrameSlotNode)yieldVar.createWriteNode(null);
        JSReadFrameSlotNode readYieldResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getYieldResultSlot()).createReadNode();
        return this.factory.createAsyncGeneratorBody(this.context, instrumentedBody, writeYieldValueNode, readYieldResultNode, writeAsyncContextNode, readAsyncContextNode);
    }

    private JavaScriptNode handleModuleBody(JavaScriptNode body) {
        assert (this.currentFunction().isModule());
        if (this.currentFunction().isAsyncGeneratorFunction()) {
            Environment.VarRef asyncContextVar = this.environment.findAsyncContextVar();
            JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
            Environment.VarRef yieldVar = this.environment.findAsyncResultVar();
            JSWriteFrameSlotNode writeAsyncContextNode = (JSWriteFrameSlotNode)asyncContextVar.createWriteNode(null);
            JSWriteFrameSlotNode writeYieldValueNode = (JSWriteFrameSlotNode)yieldVar.createWriteNode(null);
            return this.factory.createTopLevelAsyncModuleBody(this.context, instrumentedBody, writeYieldValueNode, writeAsyncContextNode);
        }
        JavaScriptNode instrumentedBody = this.instrumentSuspendNodes(body);
        return this.factory.createModuleBody(instrumentedBody);
    }

    private JavaScriptNode instrumentSuspendNodes(JavaScriptNode body) {
        if (!this.currentFunction().hasYield() && !this.currentFunction().hasAwait()) {
            return body;
        }
        JavaScriptNode newBody = (JavaScriptNode)this.instrumentSuspendHelper(body, null);
        Objects.requireNonNull(newBody);
        return newBody;
    }

    private com.oracle.truffle.api.nodes.Node instrumentSuspendHelper(com.oracle.truffle.api.nodes.Node parent, com.oracle.truffle.api.nodes.Node grandparent) {
        boolean hasSuspendChild = false;
        BitSet suspendableIndices = null;
        if (parent instanceof AbstractBlockNode) {
            JavaScriptNode[] statements = ((AbstractBlockNode)parent).getStatements();
            for (int i = 0; i < statements.length; ++i) {
                com.oracle.truffle.api.nodes.Node newChild = this.instrumentSuspendHelper((com.oracle.truffle.api.nodes.Node)statements[i], parent);
                if (newChild == null) continue;
                hasSuspendChild = true;
                statements[i] = newChild;
                if (suspendableIndices == null) {
                    suspendableIndices = new BitSet();
                }
                suspendableIndices.set(i);
            }
        } else {
            for (com.oracle.truffle.api.nodes.Node child : GraalJSTranslator.getChildrenInExecutionOrder(parent)) {
                com.oracle.truffle.api.nodes.Node newChild = this.instrumentSuspendHelper(child, parent);
                if (newChild == null) continue;
                hasSuspendChild = true;
                NodeUtil.replaceChild(parent, child, newChild);
                assert (!(child instanceof ResumableNode) || newChild instanceof GeneratorWrapperNode) : "resumable node not wrapped: " + child;
            }
        }
        if (parent instanceof SuspendNode) {
            return this.wrapResumableNode(parent);
        }
        if (!hasSuspendChild) {
            return null;
        }
        if (parent instanceof AbstractBlockNode) {
            assert (suspendableIndices != null && !suspendableIndices.isEmpty());
            return this.toGeneratorBlockNode((AbstractBlockNode)parent, suspendableIndices);
        }
        if (parent instanceof ResumableNode) {
            return this.wrapResumableNode(parent);
        }
        if (parent instanceof ReturnNode || parent instanceof ReturnTargetNode || GraalJSTranslator.isSideEffectFreeUnaryOpNode(parent)) {
            return parent;
        }
        if (GraalJSTranslator.isSupportedDispersibleExpression(parent)) {
            ArrayList<JavaScriptNode> extracted = new ArrayList<JavaScriptNode>();
            if (grandparent == null || NodeUtil.isReplacementSafe(grandparent, parent, ANY_JAVA_SCRIPT_NODE)) {
                this.extractChildrenTo(parent, extracted);
            }
            if (!extracted.isEmpty()) {
                extracted.add((JavaScriptNode)parent);
                JavaScriptNode exprBlock = this.wrapResumableNode(this.factory.createExprBlock(extracted.toArray(EMPTY_NODE_ARRAY)));
                GraalJSTranslator.tagHiddenExpression(exprBlock);
                return exprBlock;
            }
            return parent;
        }
        return parent;
    }

    private JavaScriptNode wrapResumableNode(com.oracle.truffle.api.nodes.Node resumableNode) {
        if (resumableNode instanceof AbstractBlockNode) {
            BitSet all = new BitSet();
            all.set(0, ((AbstractBlockNode)resumableNode).getStatements().length);
            return this.toGeneratorBlockNode((AbstractBlockNode)resumableNode, all);
        }
        FrameDescriptor functionFrameDescriptor = this.environment.getFunctionFrameDescriptor();
        InternalSlotId identifier = this.factory.createInternalSlotId("generatorstate", functionFrameDescriptor.getSize());
        FrameSlot frameSlot = functionFrameDescriptor.addFrameSlot(identifier);
        JavaScriptNode readState = this.factory.createReadCurrentFrameSlot(frameSlot);
        JSWriteFrameSlotNode writeState = this.factory.createWriteCurrentFrameSlot(frameSlot, functionFrameDescriptor, null);
        return this.factory.createGeneratorWrapper((JavaScriptNode)resumableNode, readState, writeState);
    }

    private JavaScriptNode toGeneratorBlockNode(AbstractBlockNode blockNode, BitSet suspendableIndices) {
        JavaScriptNode genBlock;
        FrameDescriptor functionFrameDescriptor = this.environment.getFunctionFrameDescriptor();
        InternalSlotId identifier = this.factory.createInternalSlotId("generatorstate", functionFrameDescriptor.getSize());
        FrameSlot frameSlot = functionFrameDescriptor.addFrameSlot(identifier);
        JavaScriptNode readState = this.factory.createReadCurrentFrameSlot(frameSlot);
        JSWriteFrameSlotNode writeState = this.factory.createWriteCurrentFrameSlot(frameSlot, functionFrameDescriptor, null);
        JavaScriptNode[] statements = blockNode.getStatements();
        boolean returnsResult = !blockNode.isResultAlwaysOfType(Undefined.class);
        int resumePoints = suspendableIndices.cardinality() + (suspendableIndices.get(0) ? 0 : 1);
        if (resumePoints == statements.length) {
            genBlock = returnsResult ? this.factory.createGeneratorExprBlock(statements, readState, writeState) : this.factory.createGeneratorVoidBlock(statements, readState, writeState);
        } else {
            JavaScriptNode[] chunks = new JavaScriptNode[resumePoints];
            int fromIndex = 0;
            for (int chunkI = 0; chunkI < resumePoints; ++chunkI) {
                JavaScriptNode chunk;
                int toIndex = suspendableIndices.nextSetBit(fromIndex + 1);
                if (toIndex < 0) {
                    assert (chunkI == resumePoints - 1);
                    toIndex = statements.length;
                }
                boolean bl = returnsResult = chunkI == resumePoints - 1 && !blockNode.isResultAlwaysOfType(Undefined.class);
                if (fromIndex + 1 == toIndex) {
                    chunk = statements[fromIndex];
                } else {
                    JavaScriptNode[] chunkStatements = Arrays.copyOfRange(statements, fromIndex, toIndex);
                    chunk = returnsResult && chunkI == resumePoints - 1 ? this.factory.createExprBlock(chunkStatements) : this.factory.createVoidBlock(chunkStatements);
                }
                chunks[chunkI] = chunk;
                fromIndex = toIndex;
            }
            genBlock = returnsResult ? this.factory.createGeneratorExprBlock(chunks, readState, writeState) : this.factory.createGeneratorVoidBlock(chunks, readState, writeState);
        }
        JavaScriptNode.transferSourceSectionAndTags(blockNode, genBlock);
        return genBlock;
    }

    private static boolean isSideEffectFreeUnaryOpNode(com.oracle.truffle.api.nodes.Node node) {
        return node instanceof DiscardResultNode || node instanceof VoidNode || node instanceof TypeOfNode || node instanceof JSTypeofIdenticalNode;
    }

    private static boolean isSupportedDispersibleExpression(com.oracle.truffle.api.nodes.Node node) {
        return node instanceof JSBinaryNode || node instanceof JSUnaryNode || node instanceof ArrayLiteralNode || node instanceof ObjectLiteralNode || node instanceof PropertyNode || node instanceof GlobalPropertyNode || node instanceof ReadElementNode || node instanceof WritePropertyNode || node instanceof WriteElementNode || node instanceof JSFunctionCallNode || node instanceof JSNewNode;
    }

    private static boolean isStatelessExpression(com.oracle.truffle.api.nodes.Node child) {
        return child instanceof JSConstantNode || child instanceof CreateObjectNode || child instanceof RepeatableNode && !(child instanceof ReadNode);
    }

    private static boolean skipOverToChildren(com.oracle.truffle.api.nodes.Node node) {
        return node instanceof ObjectLiteralNode.ObjectLiteralMemberNode || node instanceof AbstractFunctionArgumentsNode || node instanceof ArrayLiteralNode.SpreadArrayNode || node instanceof SpreadArgumentNode;
    }

    private void extractChildTo(com.oracle.truffle.api.nodes.Node child, com.oracle.truffle.api.nodes.Node parent, List<JavaScriptNode> extracted) {
        if (GraalJSTranslator.isStatelessExpression(child)) {
            return;
        }
        if (GraalJSTranslator.skipOverToChildren(child)) {
            this.extractChildrenTo(child, extracted);
        } else if (child instanceof JavaScriptNode) {
            JavaScriptNode jschild = (JavaScriptNode)child;
            if (NodeUtil.isReplacementSafe(parent, child, ANY_JAVA_SCRIPT_NODE)) {
                FrameDescriptor functionFrameDescriptor = this.environment.getFunctionFrameDescriptor();
                InternalSlotId identifier = this.factory.createInternalSlotId("generatorexpr", functionFrameDescriptor.getSize());
                FrameSlot frameSlot = functionFrameDescriptor.addFrameSlot(identifier);
                JavaScriptNode readState = this.factory.createReadCurrentFrameSlot(frameSlot);
                if (jschild.hasTag(StandardTags.ExpressionTag.class) || jschild instanceof GeneratorWrapperNode && ((GeneratorWrapperNode)jschild).getResumableNode().hasTag(StandardTags.ExpressionTag.class)) {
                    GraalJSTranslator.tagHiddenExpression(readState);
                }
                JSWriteFrameSlotNode writeState = this.factory.createWriteCurrentFrameSlot(frameSlot, functionFrameDescriptor, jschild);
                extracted.add(writeState);
                boolean ok = NodeUtil.replaceChild(parent, child, readState);
                assert (ok);
            } else {
                this.extractChildrenTo(child, extracted);
            }
        }
    }

    private static Iterable<com.oracle.truffle.api.nodes.Node> getChildrenInExecutionOrder(com.oracle.truffle.api.nodes.Node parent) {
        return parent.getChildren();
    }

    private void extractChildrenTo(com.oracle.truffle.api.nodes.Node parent, List<JavaScriptNode> extracted) {
        for (com.oracle.truffle.api.nodes.Node child : GraalJSTranslator.getChildrenInExecutionOrder(parent)) {
            this.extractChildTo(child, parent, extracted);
        }
    }

    private JavaScriptNode handleFunctionReturn(FunctionNode functionNode, JavaScriptNode body) {
        assert ((this.currentFunction().isGlobal() || this.currentFunction().isEval() || this.currentFunction().hasSyntheticArguments()) == (functionNode.isScript() || functionNode.isModule()));
        if (this.currentFunction().returnsLastStatementResult()) {
            assert (!this.currentFunction().hasReturn());
            return this.wrapGetCompletionValue(body);
        }
        if (this.currentFunction().hasReturn()) {
            return this.factory.createFrameReturnTarget(body, this.factory.createReadCurrentFrameSlot(this.currentFunction().getReturnSlot()));
        }
        return body;
    }

    private EnvironmentCloseable enterFunctionEnvironment(FunctionNode function, boolean isStrict, boolean isGlobal, boolean hasSyntheticArguments) {
        FunctionEnvironment functionEnv;
        if (this.environment instanceof EvalEnvironment) {
            assert (!(function.isArrow() || function.isGenerator() || function.isDerivedConstructor() || function.isAsync()));
            functionEnv = new FunctionEnvironment(this.environment.getParent(), this.factory, this.context, isStrict, true, ((EvalEnvironment)this.environment).isDirectEval(), false, false, false, false, isGlobal, hasSyntheticArguments, function.isModule());
        } else if (this.environment instanceof DebugEnvironment) {
            assert (!(function.isArrow() || function.isGenerator() || function.isDerivedConstructor() || function.isAsync()));
            functionEnv = new FunctionEnvironment(this.environment, this.factory, this.context, isStrict, true, true, false, false, false, false, isGlobal, hasSyntheticArguments, function.isModule());
        } else {
            functionEnv = new FunctionEnvironment(this.environment, this.factory, this.context, isStrict, false, false, function.isArrow(), function.isGenerator(), function.isDerivedConstructor(), function.isAsync(), isGlobal, hasSyntheticArguments, function.isModule());
        }
        return new EnvironmentCloseable(functionEnv);
    }

    private void declareParameters(FunctionNode functionNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        currentFunction.setSimpleParameterList(functionNode.hasSimpleParameterList());
        List<IdentNode> parameters = functionNode.getParameters();
        if (parameters.size() > 0 && parameters.get(parameters.size() - 1).isRestParameter()) {
            currentFunction.setRestParameter(true);
        }
        if ((long)functionNode.getNumOfParams() > this.context.getFunctionArgumentsLimit()) {
            throw Errors.createSyntaxError("function has too many arguments");
        }
    }

    private JavaScriptNode prepareDeclarations(List<JavaScriptNode> declarations, JavaScriptNode body) {
        declarations.add(body);
        return this.factory.createExprBlock(declarations.toArray(EMPTY_NODE_ARRAY));
    }

    private static JavaScriptNode[] javaScriptNodeArray(int size) {
        return size == 0 ? EMPTY_NODE_ARRAY : new JavaScriptNode[size];
    }

    private String getFunctionName(FunctionNode functionNode) {
        if (this.context.getEcmaScriptVersion() < 6 && (functionNode.isGetter() || functionNode.isSetter())) {
            assert (!functionNode.isAnonymous());
            String name = functionNode.getName();
            if (functionNode.isGetter() && name.startsWith("get ") || functionNode.isSetter() && name.startsWith("set ")) {
                name = name.substring(4);
            }
            return name;
        }
        return functionNode.getName();
    }

    private void prepareParameters(List<JavaScriptNode> init) {
        int parameterCount;
        FunctionEnvironment currentFunction;
        FunctionNode function = this.lc.getCurrentFunction();
        if (this.needsThisSlot(function, currentFunction = this.currentFunction()) && !function.isDerivedConstructor()) {
            assert (this.environment.findThisVar() != null);
            init.add(this.prepareThis(function));
        }
        if (function.needsSuper()) {
            assert (function.isMethod());
            init.add(this.prepareSuper());
        }
        if (function.needsNewTarget()) {
            init.add(this.prepareNewTarget());
        }
        if (function.needsArguments() && !currentFunction.isDirectArgumentsAccess() && !currentFunction.isDirectEval()) {
            assert (!function.isArrow() && !function.isClassFieldInitializer());
            init.add(this.prepareArguments());
        }
        if ((parameterCount = function.getParameters().size()) == 0) {
            return;
        }
        int i = 0;
        boolean hasRestParameter = currentFunction.hasRestParameter();
        boolean hasMappedArguments = function.needsArguments() && !function.isStrict() && function.hasSimpleParameterList();
        int argIndex = currentFunction.getLeadingArgumentCount();
        while (i < parameterCount) {
            JavaScriptNode valueNode = hasRestParameter && i == parameterCount - 1 ? GraalJSTranslator.tagHiddenExpression(this.factory.createAccessRestArgument(this.context, argIndex, currentFunction.getTrailingArgumentCount())) : GraalJSTranslator.tagHiddenExpression(this.factory.createAccessArgument(argIndex));
            String paramName = function.getParameters().get(i).getName();
            Environment.VarRef paramRef = this.environment.findLocalVar(paramName);
            if (paramRef != null) {
                init.add(GraalJSTranslator.tagHiddenExpression(paramRef.createWriteNode(valueNode)));
                if (hasMappedArguments) {
                    currentFunction.addMappedParameter(paramRef.getFrameSlot(), i);
                }
            } else assert (!currentFunction.isStrictMode());
            ++i;
            ++argIndex;
        }
    }

    private static JavaScriptNode tagHiddenExpression(JavaScriptNode node) {
        node.setSourceSection(unavailableInternalSection);
        if (node instanceof VarWrapperNode) {
            GraalJSTranslator.tagHiddenExpression(((VarWrapperNode)node).getDelegateNode());
        } else {
            node.addExpressionTag();
        }
        return node;
    }

    static int getBlockScopedSymbolFlags(VarNode varNode) {
        if (varNode.isConst()) {
            return 2;
        }
        assert (varNode.isLet());
        return 1 | (varNode.getName().isCatchParameter() ? 33792 : 0);
    }

    private List<JavaScriptNode> functionEnvInit(FunctionNode functionNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        assert (!currentFunction.isGlobal() || currentFunction.isIndirectEval());
        GraalJSTranslator.markTerminalReturnNodes(functionNode.getBody());
        if (functionNode.needsArguments() && functionNode.hasApplyArgumentsCall() && !functionNode.isArrow() && !functionNode.hasEval() && !functionNode.hasArrowEval() && !currentFunction.isDirectEval() && functionNode.getNumOfParams() == 0 && GraalJSTranslator.checkDirectArgumentsAccess(functionNode)) {
            currentFunction.setDirectArgumentsAccess(true);
        }
        if (functionNode.needsDynamicScope() && !currentFunction.isDirectEval()) {
            currentFunction.setIsDynamicallyScoped(true);
        }
        if (functionNode.needsNewTarget()) {
            currentFunction.setNeedsNewTarget(true);
        }
        return Collections.emptyList();
    }

    private static void functionNeedsParentFramePass(FunctionNode rootFunctionNode, JSContext context) {
        if (!context.getContextOptions().isLazyTranslation()) {
            return;
        }
        NodeVisitor<LexicalContext> visitor = new NodeVisitor<LexicalContext>(new LexicalContext()){

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (!identNode.isPropertyName()) {
                    String varName = identNode.getName();
                    this.findSymbol(varName);
                }
                return true;
            }

            @Override
            public boolean enterAccessNode(AccessNode accessNode) {
                if (accessNode.isPrivate()) {
                    this.findSymbol(accessNode.getPrivateName());
                }
                return true;
            }

            private void findSymbol(String varName) {
                boolean local = true;
                FunctionNode lastFunction = null;
                Iterator<LexicalContextNode> iterator = this.lc.getAllNodes();
                while (iterator.hasNext()) {
                    LexicalContextNode node = iterator.next();
                    if (node instanceof LexicalContextScope) {
                        Symbol foundSymbol = ((LexicalContextScope)node).getScope().getExistingSymbol(varName);
                        if (foundSymbol == null || foundSymbol.isGlobal()) continue;
                        if (local) break;
                        this.markUsesAncestorScopeUntil(lastFunction, true);
                        break;
                    }
                    if (node instanceof FunctionNode) {
                        FunctionNode function = (FunctionNode)node;
                        if (function.isNamedFunctionExpression() && varName.equals(function.getIdent().getName())) {
                            if (local) break;
                            this.markUsesAncestorScopeUntil(lastFunction, true);
                            break;
                        }
                        if (!function.isProgram() && varName.equals("arguments")) {
                            assert (local || lastFunction != null && lastFunction.isArrow());
                            if (!function.isArrow()) {
                                if (local) break;
                                this.markUsesAncestorScopeUntil(lastFunction, true);
                                break;
                            }
                        } else if (function.isArrow() && this.isVarLexicallyScopedInArrowFunction(varName)) {
                            assert (!varName.equals("arguments"));
                            FunctionNode nonArrowFunction = this.lc.getCurrentNonArrowFunction();
                            if (varName.equals("this") && !nonArrowFunction.isDerivedConstructor() || nonArrowFunction.isProgram()) break;
                            this.markUsesAncestorScopeUntil(nonArrowFunction, false);
                            break;
                        }
                        if (function.hasEval() && !function.isProgram()) {
                            if (!local) {
                                this.markUsesAncestorScopeUntil(lastFunction, true);
                            }
                        } else if (function.isModule() && this.isImport(varName) && !local) {
                            this.markUsesAncestorScopeUntil(lastFunction, true);
                        }
                        lastFunction = function;
                        local = false;
                        continue;
                    }
                    if (!(node instanceof WithNode) || local) continue;
                    this.markUsesAncestorScopeUntil(lastFunction, true);
                }
            }

            private boolean isVarLexicallyScopedInArrowFunction(String varName) {
                switch (varName) {
                    case "arguments": 
                    case "new.target": 
                    case "super": 
                    case "this": {
                        return true;
                    }
                }
                return false;
            }

            private boolean isImport(String varName) {
                switch (varName) {
                    case "import": 
                    case "import.meta": {
                        return true;
                    }
                }
                return false;
            }

            private void markUsesAncestorScopeUntil(FunctionNode untilFunction, boolean inclusive) {
                Iterator<FunctionNode> functions = this.lc.getFunctions();
                while (functions.hasNext()) {
                    FunctionNode function = functions.next();
                    if (!inclusive && function == untilFunction) break;
                    if (!function.isProgram()) {
                        function.setUsesAncestorScope(true);
                    }
                    if (!inclusive || function != untilFunction) continue;
                    break;
                }
            }

            @Override
            public boolean enterFunctionNode(FunctionNode functionNode) {
                if (functionNode.hasEval()) {
                    this.markUsesAncestorScopeUntil(null, false);
                }
                return true;
            }
        };
        rootFunctionNode.accept((NodeVisitor<? extends LexicalContext>)visitor);
    }

    private static boolean checkDirectArgumentsAccess(FunctionNode functionNode) {
        assert (functionNode.needsArguments() && functionNode.hasApplyArgumentsCall() && !functionNode.isArrow() && !functionNode.hasEval() && !functionNode.hasArrowEval());
        assert (functionNode.getNumOfParams() == 0 || functionNode.isStrict() || !functionNode.hasSimpleParameterList()) : "must not have mapped parameters";
        class DirectArgumentsAccessVisitor
        extends NodeVisitor<LexicalContext> {
            boolean directArgumentsAccess;
            final /* synthetic */ FunctionNode val$functionNode;

            DirectArgumentsAccessVisitor(LexicalContext lexicalContext) {
                this.val$functionNode = lexicalContext;
                super(lc);
                this.directArgumentsAccess = true;
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                if (!identNode.isPropertyName() && !identNode.isApplyArguments() && identNode.getName().equals("arguments")) {
                    this.directArgumentsAccess = false;
                }
                return false;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode nestedFunctionNode) {
                if (nestedFunctionNode == this.val$functionNode) {
                    return true;
                }
                if (nestedFunctionNode.isArrow()) {
                    this.directArgumentsAccess = false;
                }
                return false;
            }
        }
        DirectArgumentsAccessVisitor visitor = new DirectArgumentsAccessVisitor(new LexicalContext(), functionNode);
        functionNode.accept(visitor);
        return visitor.directArgumentsAccess;
    }

    private static void markTerminalReturnNodes(Node node) {
        if (node instanceof Block && ((Block)node).isTerminal()) {
            Statement lastStatement = ((Block)node).getLastStatement();
            if (lastStatement != null) {
                GraalJSTranslator.markTerminalReturnNodes(lastStatement);
            }
        } else if (node instanceof BlockStatement && ((BlockStatement)node).isTerminal()) {
            GraalJSTranslator.markTerminalReturnNodes(((BlockStatement)node).getBlock());
        } else if (node instanceof com.oracle.js.parser.ir.IfNode && ((com.oracle.js.parser.ir.IfNode)node).isTerminal()) {
            GraalJSTranslator.markTerminalReturnNodes(((com.oracle.js.parser.ir.IfNode)node).getPass());
            GraalJSTranslator.markTerminalReturnNodes(((com.oracle.js.parser.ir.IfNode)node).getFail());
        } else if (node instanceof com.oracle.js.parser.ir.ReturnNode) {
            ((com.oracle.js.parser.ir.ReturnNode)node).setInTerminalPosition(true);
        }
    }

    private List<JavaScriptNode> collectGlobalVars(FunctionNode functionNode, boolean configurable) {
        int symbolCount = functionNode.getBody().getSymbolCount();
        if (symbolCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<DeclareGlobalNode> declarations = new ArrayList<DeclareGlobalNode>(symbolCount);
        for (Symbol symbol : functionNode.getBody().getSymbols()) {
            if (symbol.isGlobal() && symbol.isVar()) {
                if (symbol.isHoistableDeclaration()) {
                    declarations.add(this.factory.createDeclareGlobalFunction(symbol.getName(), configurable, null));
                    continue;
                }
                declarations.add(this.factory.createDeclareGlobalVariable(symbol.getName(), configurable));
                continue;
            }
            if (configurable) continue;
            assert (symbol.isBlockScoped());
            declarations.add(this.factory.createDeclareGlobalLexicalVariable(symbol.getName(), symbol.isConst()));
        }
        ArrayList<JavaScriptNode> nodes = new ArrayList<JavaScriptNode>(2);
        nodes.add(this.factory.createGlobalDeclarationInstantiation(this.context, declarations));
        return nodes;
    }

    private JavaScriptNode prepareArguments() {
        Environment.VarRef argumentsVar = this.environment.findLocalVar("arguments");
        boolean unmappedArgumentsObject = this.currentFunction().isStrictMode() || !this.currentFunction().hasSimpleParameterList();
        JavaScriptNode argumentsObject = this.factory.createArgumentsObjectNode(this.context, unmappedArgumentsObject, this.currentFunction().getLeadingArgumentCount(), this.currentFunction().getTrailingArgumentCount());
        if (!unmappedArgumentsObject) {
            argumentsObject = this.environment.findArgumentsVar().createWriteNode(argumentsObject);
        }
        return argumentsVar.createWriteNode(argumentsObject);
    }

    private JavaScriptNode prepareThis(FunctionNode functionNode) {
        JavaScriptNode getThisNode;
        assert (!this.currentFunction().getNonArrowParentFunction().isDerivedConstructor());
        Environment.VarRef thisVar = this.environment.findThisVar();
        boolean isLexicalThis = functionNode.isArrow();
        JavaScriptNode javaScriptNode = getThisNode = isLexicalThis ? this.factory.createAccessLexicalThis() : this.factory.createAccessThis();
        if (!this.environment.isStrictMode() && !isLexicalThis) {
            getThisNode = this.factory.createPrepareThisBinding(this.context, getThisNode);
        }
        if (functionNode.isClassConstructor()) {
            getThisNode = this.initializeInstanceElements(getThisNode);
        }
        return thisVar.createWriteNode(getThisNode);
    }

    private JavaScriptNode prepareSuper() {
        JavaScriptNode getHomeObject = this.factory.createAccessHomeObject(this.context);
        return this.environment.findSuperVar().createWriteNode(getHomeObject);
    }

    private JavaScriptNode prepareNewTarget() {
        JavaScriptNode getNewTarget = this.factory.createAccessNewTarget();
        return this.environment.findNewTargetVar().createWriteNode(getNewTarget);
    }

    @Override
    public JavaScriptNode enterReturnNode(com.oracle.js.parser.ir.ReturnNode returnNode) {
        JavaScriptNode expression;
        if (returnNode.getExpression() != null) {
            expression = this.transform(returnNode.getExpression());
            if (this.currentFunction().isAsyncGeneratorFunction()) {
                expression = this.createAwaitNode(expression);
            }
        } else {
            expression = this.factory.createConstantUndefined();
        }
        ReturnNode returnStatement = returnNode.isInTerminalPosition() ? this.factory.createTerminalPositionReturn(expression) : this.createReturnNode(expression);
        return this.tagStatement(returnStatement, returnNode);
    }

    private ReturnNode createReturnNode(JavaScriptNode expression) {
        FunctionEnvironment currentFunction = this.currentFunction();
        currentFunction.addReturn();
        JavaScriptNode writeReturnSlotNode = this.environment.findTempVar(currentFunction.getReturnSlot()).createWriteNode(expression);
        return this.factory.createFrameReturn(writeReturnSlotNode);
    }

    @Override
    public JavaScriptNode enterBlock(Block block) {
        JavaScriptNode result;
        FunctionEnvironment currentFunction = this.currentFunction();
        try (EnvironmentCloseable blockEnv = this.enterBlockEnvironment(block);){
            JavaScriptNode blockNode;
            List<Statement> blockStatements = block.getStatements();
            ArrayList<JavaScriptNode> scopeInit = new ArrayList<JavaScriptNode>(block.getSymbolCount());
            if ((block.getScope().hasBlockScopedOrRedeclaredSymbols() || block.isModuleBody()) && !(this.environment instanceof GlobalEnvironment)) {
                this.createTemporalDeadZoneInit(block, scopeInit);
            }
            if (block.getScope().isFunctionTopScope() || block.getScope().isEvalScope()) {
                this.prepareParameters(scopeInit);
            }
            if (block.isParameterBlock() || block.isFunctionBody()) {
                if (!currentFunction.isGlobal() && currentFunction.isDynamicallyScoped()) {
                    this.environment.reserveDynamicScopeSlot();
                }
                if (block.isFunctionBody() && currentFunction.isCallerContextEval()) {
                    this.prependDynamicScopeBindingInit(block, scopeInit);
                }
            }
            if (block.isFunctionBody()) {
                blockNode = this.transformStatements(blockStatements, block.isTerminal(), block.isExpressionBlock() || block.isParameterBlock());
                if (block.isModuleBody()) {
                    blockNode = this.splitModuleBodyAtYield(blockNode, scopeInit);
                }
                FunctionNode function = this.lc.getCurrentFunction();
                blockNode = this.handleFunctionReturn(function, blockNode);
                if (currentFunction.isDerivedConstructor()) {
                    blockNode = this.finishDerivedConstructorBody(function, blockNode);
                }
                this.tagBody(blockNode, block);
                if (!scopeInit.isEmpty()) {
                    scopeInit.add(blockNode);
                    blockNode = this.factory.createExprBlock(scopeInit.toArray(EMPTY_NODE_ARRAY));
                }
            } else {
                blockNode = this.transformStatements(blockStatements, block.isTerminal(), block.isExpressionBlock() || block.isParameterBlock(), scopeInit);
            }
            result = blockEnv.wrapBlockScope(blockNode);
        }
        if (block.isFunctionBody() && currentFunction.isGeneratorFunction() && !currentFunction.isModule()) {
            result = this.finishGeneratorBody(result);
        }
        this.ensureHasSourceSection(result, block);
        return result;
    }

    private void createTemporalDeadZoneInit(Block block, List<JavaScriptNode> blockWithInit) {
        assert ((block.getScope().hasBlockScopedOrRedeclaredSymbols() || block.isModuleBody()) && !(this.environment instanceof GlobalEnvironment));
        for (Symbol symbol : block.getSymbols()) {
            if (symbol.isImportBinding()) continue;
            if (symbol.isBlockScoped() && !symbol.hasBeenDeclared()) {
                blockWithInit.add(this.findScopeVar(symbol.getName(), true).createWriteNode(this.factory.createConstant(Dead.instance())));
            }
            if (!symbol.isVarRedeclaredHere()) continue;
            assert (block.isFunctionBody());
            JavaScriptNode outerVar = this.createReadFromParentEnv(symbol.getName());
            blockWithInit.add(this.findScopeVar(symbol.getName(), true).createWriteNode(outerVar));
        }
        if (block.isModuleBody()) {
            this.createResolveImports(this.lc.getCurrentFunction(), blockWithInit);
        }
    }

    private JavaScriptNode createReadFromParentEnv(String symbolName) {
        assert (this.environment.getScopeLevel() >= 1);
        ScopeFrameNode parentScope = this.environment.getScopeLevel() == 1 ? this.factory.createScopeFrame(0, 0, ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY, null) : this.factory.createScopeFrame(0, 1, this.environment.getParentSlots(0, 1), this.environment.function().getBlockScopeSlot());
        return this.factory.createReadFrameSlot(this.environment.getParent().findLocalVar(symbolName).getFrameSlot(), parentScope);
    }

    private void createResolveImports(FunctionNode functionNode, List<JavaScriptNode> declarations) {
        assert (functionNode.isModule());
        for (Module.ImportEntry importEntry : functionNode.getModule().getImportEntries()) {
            Module.ModuleRequest moduleRequest = importEntry.getModuleRequest();
            String localName = importEntry.getLocalName();
            JSWriteFrameSlotNode writeLocalNode = (JSWriteFrameSlotNode)this.environment.findLocalVar(localName).createWriteNode(null);
            JavaScriptNode thisModule = this.getActiveModule();
            if (importEntry.getImportName().equals("*")) {
                assert (functionNode.getBody().getScope().hasSymbol(localName) && functionNode.getBody().getScope().getExistingSymbol(localName).hasBeenDeclared());
                declarations.add(this.factory.createResolveStarImport(this.context, thisModule, moduleRequest, writeLocalNode));
                continue;
            }
            assert (functionNode.getBody().getScope().hasSymbol(localName) && functionNode.getBody().getScope().getExistingSymbol(localName).isImportBinding());
            declarations.add(this.factory.createResolveNamedImport(this.context, thisModule, moduleRequest, importEntry.getImportName(), writeLocalNode));
        }
    }

    private JavaScriptNode splitModuleBodyAtYield(JavaScriptNode blockNode, List<JavaScriptNode> scopeInit) {
        if (blockNode instanceof SequenceNode) {
            JavaScriptNode[] statements = ((SequenceNode)((Object)blockNode)).getStatements();
            for (int i = 0; i < statements.length; ++i) {
                JavaScriptNode statement = statements[i];
                if (!GraalJSTranslator.isModuleYieldStatement(statement)) continue;
                scopeInit.addAll(Arrays.asList(statements).subList(0, i + 1));
                return this.factory.createExprBlock(Arrays.copyOfRange(statements, i + 1, statements.length));
            }
        } else if (GraalJSTranslator.isModuleYieldStatement(blockNode)) {
            scopeInit.add(blockNode);
            return this.factory.createEmpty();
        }
        return blockNode;
    }

    private static boolean isModuleYieldStatement(JavaScriptNode statement) {
        return statement instanceof ModuleYieldNode || statement instanceof JSWriteFrameSlotNode && ((JSWriteFrameSlotNode)statement).getRhs() instanceof ModuleYieldNode;
    }

    private void prependDynamicScopeBindingInit(Block block, List<JavaScriptNode> blockWithInit) {
        assert (this.currentFunction().isCallerContextEval());
        for (Symbol symbol : block.getSymbols()) {
            if (!symbol.isVar() || this.environment.getVariableEnvironment().hasLocalVar(symbol.getName())) continue;
            blockWithInit.add(this.createDynamicScopeBinding(symbol.getName(), true));
        }
    }

    private JavaScriptNode createDynamicScopeBinding(String varName, boolean deleteable) {
        assert (deleteable);
        Environment.VarRef dynamicScopeVar = this.environment.findDynamicScopeVar();
        return new DeclareEvalVariableNode(this.context, varName, dynamicScopeVar.createReadNode(), (WriteNode)((Object)dynamicScopeVar.createWriteNode(null)));
    }

    private JavaScriptNode transformStatements(List<Statement> blockStatements, boolean terminal, boolean expressionBlock) {
        return this.transformStatements(blockStatements, terminal, expressionBlock, GraalJSTranslator.javaScriptNodeArray(blockStatements.size()), 0);
    }

    private JavaScriptNode transformStatements(List<Statement> blockStatements, boolean terminal, boolean expressionBlock, List<JavaScriptNode> prolog) {
        int pos;
        int size = prolog.size() + blockStatements.size();
        JavaScriptNode[] statements = GraalJSTranslator.javaScriptNodeArray(size);
        if (!prolog.isEmpty()) {
            for (pos = 0; pos < prolog.size(); ++pos) {
                statements[pos] = prolog.get(pos);
            }
        }
        return this.transformStatements(blockStatements, terminal, expressionBlock, statements, pos);
    }

    private JavaScriptNode transformStatements(List<Statement> blockStatements, boolean terminal, boolean expressionBlock, JavaScriptNode[] statements, int destPos) {
        int pos = destPos;
        int lastNonEmptyIndex = -1;
        for (int i = 0; i < blockStatements.size(); ++i) {
            Statement statement = blockStatements.get(i);
            JavaScriptNode statementNode = this.transformStatementInBlock(statement);
            if (this.currentFunction().returnsLastStatementResult()) {
                if (!statement.isCompletionValueNeverEmpty()) {
                    if (lastNonEmptyIndex >= 0) {
                        statements[lastNonEmptyIndex] = this.wrapSetCompletionValue(statements[lastNonEmptyIndex]);
                        lastNonEmptyIndex = -1;
                    }
                } else {
                    lastNonEmptyIndex = pos;
                }
            }
            statements[pos++] = statementNode;
        }
        if (this.currentFunction().returnsLastStatementResult() && lastNonEmptyIndex >= 0) {
            statements[lastNonEmptyIndex] = this.wrapSetCompletionValue(statements[lastNonEmptyIndex]);
        }
        assert (pos == statements.length);
        return this.createBlock(statements, terminal, expressionBlock);
    }

    private EnvironmentCloseable enterBlockEnvironment(Block block) {
        if (block.isFunctionBody() && this.lc.getCurrentFunction().isScript() && this.argumentNames == null) {
            FunctionEnvironment currentFunction = this.currentFunction();
            if (!currentFunction.isEval()) {
                GlobalEnvironment globalEnv = new GlobalEnvironment(this.environment, this.factory, this.context);
                GraalJSTranslator.setupGlobalEnvironment(globalEnv, block);
                return new EnvironmentCloseable(globalEnv);
            }
            if (currentFunction.isIndirectEval()) {
                GlobalEnvironment globalEnv = new GlobalEnvironment(this.environment, this.factory, this.context);
                BlockEnvironment blockEnv = new BlockEnvironment(globalEnv, this.factory, this.context);
                blockEnv.addFrameSlotsFromSymbols(block.getScope().getSymbols());
                return new EnvironmentCloseable(blockEnv);
            }
            assert (currentFunction.isDirectEval());
        }
        return this.enterBlockEnvironment(block.getScope());
    }

    private EnvironmentCloseable enterBlockEnvironment(Scope scope) {
        if (scope != null) {
            if (scope.isFunctionTopScope() || scope.isEvalScope()) {
                boolean parametersFirst;
                assert (this.environment instanceof FunctionEnvironment);
                Environment functionEnv = this.environment;
                FunctionNode function = this.lc.getCurrentFunction();
                assert (function.hasClosures() || !GraalJSTranslator.hasClosures(function.getBody())) : function;
                if (!function.isModule() && !function.isGenerator() && (function.hasClosures() || function.hasEval())) {
                    functionEnv = new BlockEnvironment(this.environment, this.factory, this.context, true);
                }
                boolean onlyBlockScoped = this.currentFunction().isCallerContextEval();
                boolean bl = parametersFirst = function.hasSimpleParameterList() && function.getNumOfParams() > 0;
                if (parametersFirst) {
                    functionEnv.addFrameSlotsFromSymbols(scope.getSymbols(), onlyBlockScoped, s -> s.isParam());
                }
                this.addFunctionFrameSlots(functionEnv, function);
                functionEnv.addFrameSlotsFromSymbols(scope.getSymbols(), onlyBlockScoped, parametersFirst ? s -> !s.isParam() : null);
                return new EnvironmentCloseable(functionEnv);
            }
            if (scope.hasDeclarations()) {
                BlockEnvironment blockEnv = new BlockEnvironment(this.environment, this.factory, this.context);
                blockEnv.addFrameSlotsFromSymbols(scope.getSymbols());
                return new EnvironmentCloseable(blockEnv);
            }
        }
        return new EnvironmentCloseable(this.environment);
    }

    private void addFunctionFrameSlots(Environment env, FunctionNode function) {
        FunctionEnvironment currentFunction;
        if (function.needsArguments()) {
            assert (function.getBody().getScope().hasSymbol("arguments")) : function;
            env.reserveArgumentsSlot();
        }
        if (this.needsThisSlot(function, currentFunction = env.function())) {
            env.reserveThisSlot();
        }
        if (function.needsSuper()) {
            assert (function.isMethod());
            env.reserveSuperSlot();
        }
        if (function.needsNewTarget()) {
            env.reserveNewTargetSlot();
        }
    }

    private boolean needsThisSlot(FunctionNode function, FunctionEnvironment currentFunction) {
        if (currentFunction.isGlobal()) {
            return false;
        }
        if (function.needsThis() && (!function.isArrow() && !currentFunction.isDirectEval() || !currentFunction.getNonArrowParentFunction().isDerivedConstructor())) {
            return true;
        }
        if (function.needsSuper()) {
            assert (function.isMethod());
            return true;
        }
        return function.isClassConstructor() && (this.lc.getCurrentClass().hasInstanceFields() || this.lc.getCurrentClass().hasPrivateInstanceMethods());
    }

    private static void setupGlobalEnvironment(GlobalEnvironment globalEnv, Block block) {
        for (Symbol symbol : block.getSymbols()) {
            if (symbol.isImportBinding()) continue;
            if (symbol.isBlockScoped()) {
                globalEnv.addLexicalDeclaration(symbol.getName(), symbol.isConst());
                continue;
            }
            if (!symbol.isGlobal() || !symbol.isVar()) continue;
            globalEnv.addVarDeclaration(symbol.getName());
        }
    }

    private JavaScriptNode transformStatementInBlock(Statement statement) {
        return this.transform(statement);
    }

    @Override
    public JavaScriptNode enterBlockStatement(BlockStatement blockStatement) {
        return this.transform(blockStatement.getBlock());
    }

    @Override
    public JavaScriptNode enterLiteralNode(LiteralNode<?> literalNode) {
        if (literalNode instanceof LiteralNode.ArrayLiteralNode) {
            return this.tagExpression(this.createArrayLiteral(((LiteralNode.ArrayLiteralNode)literalNode).getElementExpressions()), literalNode);
        }
        return this.tagExpression(this.enterLiteralDefaultNode(literalNode), literalNode);
    }

    private JavaScriptNode enterLiteralDefaultNode(LiteralNode<?> literalNode) {
        Object value = literalNode.getValue();
        if (value == null) {
            return this.factory.createConstantNull();
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            if (JSRuntime.isSafeInteger(longValue)) {
                return this.factory.createConstantSafeInteger(longValue);
            }
            return this.factory.createConstantDouble(longValue);
        }
        if (value instanceof Lexer.RegexToken) {
            return this.factory.createRegExpLiteral(this.context, ((Lexer.RegexToken)value).getExpression(), ((Lexer.RegexToken)value).getOptions());
        }
        if (value instanceof BigInteger) {
            value = BigInt.fromBigInteger((BigInteger)value);
        }
        return this.factory.createConstant(value);
    }

    private JavaScriptNode createArrayLiteral(List<? extends Expression> elementExpressions) {
        JavaScriptNode[] elements = GraalJSTranslator.javaScriptNodeArray(elementExpressions.size());
        boolean hasSpread = false;
        for (int i = 0; i < elementExpressions.size(); ++i) {
            Expression elementExpression = elementExpressions.get(i);
            hasSpread = hasSpread || elementExpression != null && elementExpression.isTokenType(TokenType.SPREAD_ARRAY);
            elements[i] = elementExpression != null ? this.transform(elementExpression) : this.factory.createEmpty();
        }
        return hasSpread ? this.factory.createArrayLiteralWithSpread(this.context, elements) : this.factory.createArrayLiteral(this.context, elements);
    }

    @Override
    public JavaScriptNode enterIdentNode(IdentNode identNode) {
        JavaScriptNode result;
        assert (!identNode.isPropertyName());
        if (identNode.isThis()) {
            result = this.createThisNode();
        } else if (identNode.isSuper()) {
            result = this.enterIdentNodeSuper(identNode);
        } else if (identNode.isNewTarget()) {
            result = this.enterNewTarget();
        } else if (identNode.isImportMeta()) {
            result = this.enterImportMeta();
        } else if (identNode.isPrivateInCheck()) {
            String privateVarName = identNode.getName();
            Environment.VarRef privateVarRef = this.environment.findLocalVar(privateVarName);
            JavaScriptNode readNode = privateVarRef.createReadNode();
            FrameSlot frameSlot = privateVarRef.getFrameSlot();
            result = JSFrameUtil.needsPrivateBrandCheck(frameSlot) ? this.getPrivateBrandNode(frameSlot, privateVarRef) : readNode;
        } else {
            String varName = identNode.getName();
            Environment.VarRef varRef = this.findScopeVarCheckTDZ(varName, false);
            result = varRef.createReadNode();
        }
        return this.tagExpression(result, identNode);
    }

    private JavaScriptNode enterNewTarget() {
        return this.environment.findNewTargetVar().createReadNode();
    }

    private JavaScriptNode enterIdentNodeSuper(IdentNode identNode) {
        if (!identNode.isDirectSuper()) {
            JavaScriptNode getSuperBase = this.factory.createGetPrototype(this.environment.findSuperVar().createReadNode());
            JavaScriptNode receiver = this.checkThisBindingInitialized(this.environment.findThisVar().createReadNode());
            return this.factory.createSuperPropertyReference(getSuperBase, receiver);
        }
        assert (identNode.isDirectSuper());
        JavaScriptNode activeFunction = this.factory.createAccessCallee(this.currentFunction().getThisFunctionLevel());
        JavaScriptNode superConstructor = this.factory.createGetPrototype(activeFunction);
        JavaScriptNode receiver = this.environment.findThisVar().createReadNode();
        return this.factory.createTargetableWrapper(superConstructor, receiver);
    }

    private JavaScriptNode createThisNode() {
        if (this.currentFunction().isGlobal()) {
            return this.factory.createAccessThis();
        }
        return this.checkThisBindingInitialized(this.environment.findThisVar().createReadNode());
    }

    private JavaScriptNode createThisNodeUnchecked() {
        if (this.currentFunction().isGlobal()) {
            return this.factory.createAccessThis();
        }
        return this.environment.findThisVar().createReadNode();
    }

    private JavaScriptNode checkThisBindingInitialized(JavaScriptNode accessThisNode) {
        if (this.currentFunction().getNonArrowParentFunction().isDerivedConstructor()) {
            return this.factory.createDerivedConstructorThis(accessThisNode);
        }
        return accessThisNode;
    }

    private JavaScriptNode enterImportMeta() {
        return this.factory.createImportMeta(this.getActiveModule());
    }

    private JavaScriptNode getActiveModule() {
        assert (this.lc.inModule());
        return this.factory.createAccessFrameArgument(this.currentFunction().getOutermostFunctionLevel(), 0);
    }

    private JavaScriptNode getActiveScriptOrModule() {
        return this.environment.findActiveScriptOrModule().createReadNode();
    }

    private Environment.VarRef findScopeVar(String name, boolean skipWith) {
        return this.environment.findVar(name, skipWith);
    }

    private Environment.VarRef findScopeVarCheckTDZ(String name, boolean initializationAssignment) {
        final Environment.VarRef varRef = this.findScopeVar(name, false);
        if (varRef.isFunctionLocal()) {
            Symbol symbol = this.lc.getCurrentScope().findBlockScopedSymbolInFunction(varRef.getName());
            if (symbol == null) {
                return varRef;
            }
            if (symbol.hasBeenDeclared()) {
                return varRef;
            }
            if (symbol.isDeclaredInSwitchBlock()) {
                return varRef.withTDZCheck();
            }
            assert (!symbol.hasBeenDeclared());
            if (initializationAssignment) {
                symbol.setHasBeenDeclared();
                return varRef;
            }
            return new Environment.VarRef(name){

                @Override
                public boolean isGlobal() {
                    return varRef.isGlobal();
                }

                @Override
                public boolean isFunctionLocal() {
                    return varRef.isFunctionLocal();
                }

                @Override
                public FrameSlot getFrameSlot() {
                    return null;
                }

                @Override
                public JavaScriptNode createReadNode() {
                    return GraalJSTranslator.this.factory.createThrowError(JSErrorType.ReferenceError, String.format("\"%s\" is not defined", varRef.getName()));
                }

                @Override
                public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
                    JavaScriptNode throwErrorNode = this.createReadNode();
                    return GraalJSTranslator.isPotentiallySideEffecting(rhs) ? DualNode.create(rhs, throwErrorNode) : throwErrorNode;
                }

                @Override
                public JavaScriptNode createDeleteNode() {
                    return this.createReadNode();
                }
            };
        }
        return varRef.withTDZCheck();
    }

    @Override
    public JavaScriptNode enterVarNode(VarNode varNode) {
        JavaScriptNode assignment;
        String varName = varNode.getName().getName();
        assert (this.currentFunction().isGlobal() && (!varNode.isBlockScoped() || this.lc.getCurrentBlock().isFunctionBody()) || !this.findScopeVar(varName, true).isGlobal() || this.currentFunction().isCallerContextEval()) : varNode;
        Symbol symbol = null;
        if (varNode.isBlockScoped()) {
            symbol = this.lc.getCurrentScope().getExistingSymbol(varName);
            assert (symbol != null) : varName;
        }
        if (varNode.isAssignment()) {
            assignment = this.createVarAssignNode(varNode, varName);
        } else if (!(symbol == null || varNode.isDestructuring() && !symbol.isDeclaredInSwitchBlock() || symbol.hasBeenDeclared())) {
            assert (varNode.isBlockScoped());
            assignment = this.findScopeVar(varName, false).createWriteNode(this.factory.createConstantUndefined());
        } else {
            assignment = this.factory.createEmpty();
        }
        if (symbol != null && !symbol.isDeclaredInSwitchBlock() && !varNode.isDestructuring()) {
            assert (varNode.isBlockScoped());
            symbol.setHasBeenDeclared();
        }
        return assignment;
    }

    private JavaScriptNode createVarAssignNode(VarNode varNode, String varName) {
        Symbol symbol;
        FunctionNode fn;
        JavaScriptNode rhs = this.transform(varNode.getAssignmentSource());
        JavaScriptNode assignment = this.findScopeVar(varName, false).createWriteNode(rhs);
        if (varNode.isBlockScoped() && varNode.isFunctionDeclaration() && this.context.isOptionAnnexB() && !(fn = this.lc.getCurrentFunction()).isStrict() && !varName.equals("arguments") && (symbol = this.lc.getCurrentScope().getExistingSymbol(varName)).isHoistedBlockFunctionDeclaration()) {
            assert (GraalJSTranslator.hasVarSymbol(fn.getVarDeclarationBlock().getScope(), varName)) : varName;
            assignment = this.environment.findVar(varName, true, false, true, false, false).withRequired(false).createWriteNode(assignment);
            this.tagExpression(assignment, varNode);
        }
        if (varNode.isClassDeclaration()) {
            return this.discardResult(assignment);
        }
        if (!varNode.isHoistableDeclaration()) {
            this.tagStatement(assignment, varNode);
        }
        this.ensureHasSourceSection(assignment, varNode);
        return this.discardResult(assignment);
    }

    private static boolean hasVarSymbol(Scope scope, String varName) {
        Symbol varSymbol = scope.getExistingSymbol(varName);
        return varSymbol != null && varSymbol.isVar() && !varSymbol.isParam();
    }

    @Override
    public JavaScriptNode enterWhileNode(WhileNode whileNode) {
        JavaScriptNode test = this.transform(whileNode.getTest());
        this.tagStatement(test, whileNode.getTest());
        try (FunctionEnvironment.JumpTargetCloseable<ContinueTarget> target = this.currentFunction().pushContinueTarget(null);){
            JavaScriptNode body = this.transform(whileNode.getBody());
            JavaScriptNode wrappedBody = this.wrapClearCompletionValue(target.wrapContinueTargetNode(body));
            JavaScriptNode result = whileNode.isDoWhile() ? this.createDoWhile(test, wrappedBody) : this.createWhileDo(test, wrappedBody);
            JavaScriptNode javaScriptNode = this.wrapClearAndGetCompletionValue(target.wrapBreakTargetNode(this.ensureHasSourceSection(result, whileNode)));
            return javaScriptNode;
        }
    }

    private JavaScriptNode createDoWhile(JavaScriptNode condition, JavaScriptNode body) {
        return this.factory.createDoWhile(condition, body);
    }

    private JavaScriptNode createWhileDo(JavaScriptNode condition, JavaScriptNode body) {
        return this.factory.createWhileDo(condition, body);
    }

    private JavaScriptNode wrapGetCompletionValue(JavaScriptNode target) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return this.factory.createExprBlock(target, returnVar.createReadNode());
        }
        return target;
    }

    private JavaScriptNode wrapSetCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return returnVar.createWriteNode(statement);
        }
        return statement;
    }

    private JavaScriptNode wrapClearCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return this.factory.createExprBlock(returnVar.createWriteNode(this.factory.createConstantUndefined()), statement);
        }
        return statement;
    }

    private JavaScriptNode wrapClearAndGetCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            return this.factory.createExprBlock(returnVar.createWriteNode(this.factory.createConstantUndefined()), statement, returnVar.createReadNode());
        }
        return statement;
    }

    private JavaScriptNode wrapSaveAndRestoreCompletionValue(JavaScriptNode statement) {
        if (this.currentFunction().returnsLastStatementResult()) {
            Environment.VarRef returnVar = this.environment.findTempVar(this.currentFunction().getReturnSlot());
            Environment.VarRef tempVar = this.environment.createTempVar();
            return this.factory.createExprBlock(tempVar.createWriteNode(returnVar.createReadNode()), statement, returnVar.createWriteNode(tempVar.createReadNode()));
        }
        return statement;
    }

    @Override
    public JavaScriptNode enterForNode(ForNode forNode) {
        JavaScriptNode init = forNode.getInit() != null && !forNode.isForInOrOf() ? this.tagStatement(this.transform(forNode.getInit()), forNode.getInit()) : this.factory.createEmpty();
        JavaScriptNode test = forNode.getTest() != null && forNode.getTest().getExpression() != null ? this.tagStatement(this.transform(forNode.getTest()), forNode.getTest()) : this.factory.createConstantBoolean(true);
        JavaScriptNode modify = forNode.getModify() != null ? this.tagStatement(this.transform(forNode.getModify()), forNode.getModify()) : this.factory.createEmpty();
        try (FunctionEnvironment.JumpTargetCloseable<ContinueTarget> target = this.currentFunction().pushContinueTarget(null);){
            JavaScriptNode result;
            if (forNode.isForOf()) {
                result = this.desugarForOf(forNode, modify, target);
            } else if (forNode.isForIn()) {
                result = this.desugarForIn(forNode, modify, target);
            } else if (forNode.isForAwaitOf()) {
                result = this.desugarForAwaitOf(forNode, modify, target);
            } else {
                JavaScriptNode body = this.transform(forNode.getBody());
                JavaScriptNode wrappedBody = this.wrapClearCompletionValue(target.wrapContinueTargetNode(body));
                result = target.wrapBreakTargetNode(this.desugarFor(forNode, init, test, modify, wrappedBody));
            }
            JavaScriptNode javaScriptNode = this.wrapClearAndGetCompletionValue(result);
            return javaScriptNode;
        }
    }

    private JavaScriptNode desugarFor(ForNode forNode, JavaScriptNode init, JavaScriptNode test, JavaScriptNode modify, JavaScriptNode wrappedBody) {
        if (this.needsPerIterationScope(forNode)) {
            Environment.VarRef firstTempVar = this.environment.createTempVar();
            FrameDescriptor iterationBlockFrameDescriptor = this.environment.getBlockFrameDescriptor();
            StatementNode newFor = this.factory.createFor(test, wrappedBody, modify, iterationBlockFrameDescriptor, firstTempVar.createReadNode(), firstTempVar.createWriteNode(this.factory.createConstantBoolean(false)), this.currentFunction().getBlockScopeSlot());
            this.ensureHasSourceSection(newFor, forNode);
            return this.createBlock(init, firstTempVar.createWriteNode(this.factory.createConstantBoolean(true)), newFor);
        }
        JavaScriptNode whileDo = this.factory.createDesugaredFor(test, this.createBlock(wrappedBody, modify));
        if (forNode.getTest() == null) {
            this.tagStatement(test, forNode);
        } else {
            this.ensureHasSourceSection(whileDo, forNode);
        }
        return this.createBlock(init, whileDo);
    }

    private JavaScriptNode desugarForIn(ForNode forNode, JavaScriptNode modify, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        JavaScriptNode createIteratorNode;
        if (forNode.isForEach()) {
            createIteratorNode = this.factory.createEnumerate(this.context, modify, true);
        } else {
            assert (forNode.isForIn() && !forNode.isForEach() && !forNode.isForOf());
            createIteratorNode = this.factory.createEnumerate(this.context, modify, false);
        }
        return this.desugarForInOrOfBody(forNode, this.factory.createGetIterator(this.context, createIteratorNode), jumpTarget);
    }

    private JavaScriptNode desugarForOf(ForNode forNode, JavaScriptNode modify, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        assert (forNode.isForOf());
        JavaScriptNode getIterator = this.factory.createGetIterator(this.context, modify);
        return this.desugarForInOrOfBody(forNode, getIterator, jumpTarget);
    }

    private JavaScriptNode desugarForInOrOfBody(ForNode forNode, JavaScriptNode iterator, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        JavaScriptNode wrappedBody;
        assert (forNode.isForInOrOf());
        Environment.VarRef iteratorVar = this.environment.createTempVar();
        JavaScriptNode iteratorInit = iteratorVar.createWriteNode(iterator);
        Environment.VarRef nextResultVar = this.environment.createTempVar();
        JavaScriptNode iteratorNext = this.factory.createIteratorNext(iteratorVar.createReadNode());
        JavaScriptNode condition = this.factory.createDual(this.context, this.factory.createIteratorSetDone(iteratorVar.createReadNode(), this.factory.createConstantBoolean(true)), this.factory.createUnary(NodeFactory.UnaryOperation.NOT, this.factory.createIteratorComplete(this.context, nextResultVar.createWriteNode(iteratorNext))));
        try (EnvironmentCloseable blockEnv = this.needsPerIterationScope(forNode) ? this.enterBlockEnvironment(this.lc.getCurrentBlock()) : new EnvironmentCloseable(this.environment);){
            Environment.VarRef nextResultVar2 = this.environment.findTempVar(nextResultVar.getFrameSlot());
            Environment.VarRef nextValueVar = this.environment.createTempVar();
            Environment.VarRef iteratorVar2 = this.environment.findTempVar(iteratorVar.getFrameSlot());
            JavaScriptNode nextResult = nextResultVar2.createReadNode();
            JavaScriptNode nextValue = this.factory.createIteratorValue(this.context, nextResult);
            JavaScriptNode writeNextValue = nextValueVar.createWriteNode(nextValue);
            JavaScriptNode writeNext = this.tagStatement(this.desugarForHeadAssignment(forNode, nextValueVar.createReadNode()), forNode);
            JavaScriptNode body = this.transform(forNode.getBody());
            wrappedBody = blockEnv.wrapBlockScope(this.createBlock(writeNextValue, this.factory.createIteratorSetDone(iteratorVar2.createReadNode(), this.factory.createConstantBoolean(false)), writeNext, body));
        }
        wrappedBody = jumpTarget.wrapContinueTargetNode(wrappedBody);
        JavaScriptNode whileNode = forNode.isForOf() ? this.factory.createDesugaredForOf(condition, wrappedBody) : this.factory.createDesugaredForIn(condition, wrappedBody);
        JavaScriptNode wrappedWhile = this.factory.createIteratorCloseIfNotDone(this.context, jumpTarget.wrapBreakTargetNode(whileNode), iteratorVar.createReadNode());
        JavaScriptNode resetIterator = iteratorVar.createWriteNode(this.factory.createConstant(JSFrameUtil.DEFAULT_VALUE));
        wrappedWhile = this.factory.createTryFinally(wrappedWhile, resetIterator);
        this.ensureHasSourceSection(whileNode, forNode);
        return this.createBlock(iteratorInit, wrappedWhile);
    }

    private JavaScriptNode desugarForHeadAssignment(ForNode forNode, JavaScriptNode next) {
        boolean lexicalBindingInit = forNode.hasPerIterationScope();
        if (forNode.getInit() instanceof IdentNode && lexicalBindingInit) {
            return this.tagExpression(this.findScopeVarCheckTDZ(((IdentNode)forNode.getInit()).getName(), lexicalBindingInit).createWriteNode(next), forNode);
        }
        return this.tagExpression(this.transformAssignment(forNode.getInit(), forNode.getInit(), next, lexicalBindingInit), forNode);
    }

    private JavaScriptNode desugarForAwaitOf(ForNode forNode, JavaScriptNode modify, FunctionEnvironment.JumpTargetCloseable<ContinueTarget> jumpTarget) {
        JavaScriptNode wrappedBody;
        assert (forNode.isForAwaitOf());
        JavaScriptNode getIterator = this.factory.createGetAsyncIterator(this.context, modify);
        Environment.VarRef iteratorVar = this.environment.createTempVar();
        JavaScriptNode iteratorInit = iteratorVar.createWriteNode(getIterator);
        Environment.VarRef nextResultVar = this.environment.createTempVar();
        this.currentFunction().addAwait();
        JSReadFrameSlotNode asyncResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getAsyncResultSlot()).createReadNode();
        JSReadFrameSlotNode asyncContextNode = (JSReadFrameSlotNode)this.environment.findTempVar(this.currentFunction().getAsyncContextSlot()).createReadNode();
        JavaScriptNode iteratorNext = this.factory.createAsyncIteratorNext(this.context, iteratorVar.createReadNode(), asyncContextNode, asyncResultNode);
        JavaScriptNode condition = this.factory.createDual(this.context, this.factory.createIteratorSetDone(iteratorVar.createReadNode(), this.factory.createConstantBoolean(true)), this.factory.createUnary(NodeFactory.UnaryOperation.NOT, this.factory.createIteratorComplete(this.context, nextResultVar.createWriteNode(iteratorNext))));
        try (EnvironmentCloseable blockEnv = this.needsPerIterationScope(forNode) ? this.enterBlockEnvironment(this.lc.getCurrentBlock()) : new EnvironmentCloseable(this.environment);){
            Environment.VarRef nextResultVar2 = this.environment.findTempVar(nextResultVar.getFrameSlot());
            Environment.VarRef nextValueVar = this.environment.createTempVar();
            Environment.VarRef iteratorVar2 = this.environment.findTempVar(iteratorVar.getFrameSlot());
            JavaScriptNode nextResult = nextResultVar2.createReadNode();
            JavaScriptNode nextValue = this.factory.createIteratorValue(this.context, nextResult);
            JavaScriptNode writeNextValue = nextValueVar.createWriteNode(nextValue);
            JavaScriptNode writeNext = this.tagStatement(this.desugarForHeadAssignment(forNode, nextValueVar.createReadNode()), forNode);
            JavaScriptNode body = this.transform(forNode.getBody());
            wrappedBody = blockEnv.wrapBlockScope(this.createBlock(writeNextValue, this.factory.createIteratorSetDone(iteratorVar2.createReadNode(), this.factory.createConstantBoolean(false)), writeNext, body));
        }
        wrappedBody = jumpTarget.wrapContinueTargetNode(wrappedBody);
        JavaScriptNode whileNode = this.factory.createDesugaredForAwaitOf(condition, wrappedBody);
        this.currentFunction().addAwait();
        JavaScriptNode wrappedWhile = this.factory.createAsyncIteratorCloseWrapper(this.context, jumpTarget.wrapBreakTargetNode(whileNode), iteratorVar.createReadNode(), asyncContextNode, asyncResultNode);
        JavaScriptNode resetIterator = iteratorVar.createWriteNode(this.factory.createConstant(JSFrameUtil.DEFAULT_VALUE));
        wrappedWhile = this.factory.createTryFinally(wrappedWhile, resetIterator);
        this.ensureHasSourceSection(whileNode, forNode);
        return this.createBlock(iteratorInit, wrappedWhile);
    }

    private boolean needsPerIterationScope(ForNode forNode) {
        if (forNode.hasPerIterationScope()) {
            FunctionNode function = this.lc.getCurrentFunction();
            if (function.hasClosures() && GraalJSTranslator.hasClosures(this.lc.getCurrentBlock())) {
                return true;
            }
            if (function.hasEval()) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasClosures(Node node) {
        class HasClosuresVisitor
        extends NodeVisitor<LexicalContext> {
            boolean hasClosures;

            HasClosuresVisitor(LexicalContext lc) {
                super(lc);
            }

            @Override
            public boolean enterFunctionNode(FunctionNode functionNode) {
                this.hasClosures = true;
                return false;
            }
        }
        HasClosuresVisitor visitor = new HasClosuresVisitor(new LexicalContext());
        node.accept(visitor);
        return visitor.hasClosures;
    }

    @Override
    public JavaScriptNode enterLabelNode(LabelNode labelNode) {
        try (FunctionEnvironment.JumpTargetCloseable<BreakTarget> breakTarget = this.currentFunction().pushBreakTarget(labelNode.getLabelName());){
            JavaScriptNode body = this.transform(labelNode.getBody());
            JavaScriptNode javaScriptNode = breakTarget.wrapLabelBreakTargetNode(body);
            return javaScriptNode;
        }
    }

    @Override
    public JavaScriptNode enterBreakNode(BreakNode breakNode) {
        return this.tagStatement(this.factory.createBreak(this.currentFunction().findBreakTarget(breakNode.getLabelName())), breakNode);
    }

    @Override
    public JavaScriptNode enterContinueNode(ContinueNode continueNode) {
        return this.tagStatement(this.factory.createContinue(this.currentFunction().findContinueTarget(continueNode.getLabelName())), continueNode);
    }

    @Override
    public JavaScriptNode enterIfNode(com.oracle.js.parser.ir.IfNode ifNode) {
        JavaScriptNode test = this.transform(ifNode.getTest());
        JavaScriptNode pass = this.transform(ifNode.getPass());
        JavaScriptNode fail = this.transform(ifNode.getFail());
        return this.tagStatement(this.factory.createIf(test, pass, fail), ifNode);
    }

    @Override
    public JavaScriptNode enterTernaryNode(TernaryNode ternaryNode) {
        JavaScriptNode test = this.transform(ternaryNode.getTest());
        JavaScriptNode pass = this.transform(ternaryNode.getTrueExpression());
        JavaScriptNode fail = this.transform(ternaryNode.getFalseExpression());
        return this.tagExpression(this.factory.createIf(test, pass, fail), ternaryNode);
    }

    @Override
    public JavaScriptNode enterUnaryNode(UnaryNode unaryNode) {
        switch (unaryNode.tokenType()) {
            case ADD: 
            case BIT_NOT: 
            case NOT: 
            case SUB: 
            case VOID: {
                return this.enterUnaryDefaultNode(unaryNode);
            }
            case TYPEOF: {
                return this.enterTypeofNode(unaryNode);
            }
            case INCPREFIX: 
            case INCPOSTFIX: 
            case DECPREFIX: 
            case DECPOSTFIX: {
                return this.enterUnaryIncDecNode(unaryNode);
            }
            case NEW: {
                return this.enterNewNode(unaryNode);
            }
            case DELETE: {
                return this.enterDelete(unaryNode);
            }
            case SPREAD_ARGUMENT: {
                return this.tagExpression(this.factory.createSpreadArgument(this.context, this.transform(unaryNode.getExpression())), unaryNode);
            }
            case SPREAD_ARRAY: {
                return this.tagExpression(this.factory.createSpreadArray(this.context, this.transform(unaryNode.getExpression())), unaryNode);
            }
            case YIELD: 
            case YIELD_STAR: {
                return this.tagExpression(this.createYieldNode(unaryNode), unaryNode);
            }
            case AWAIT: {
                return this.tagExpression(this.translateAwaitNode(unaryNode), unaryNode);
            }
            case NAMEDEVALUATION: {
                return this.enterNamedEvaluation(unaryNode);
            }
        }
        throw new UnsupportedOperationException(unaryNode.tokenType().toString());
    }

    private JavaScriptNode translateAwaitNode(UnaryNode unaryNode) {
        JavaScriptNode expression = this.transform(unaryNode.getExpression());
        return this.createAwaitNode(expression);
    }

    private JavaScriptNode createAwaitNode(JavaScriptNode expression) {
        FunctionEnvironment currentFunction = this.currentFunction();
        currentFunction.addAwait();
        JSReadFrameSlotNode asyncContextNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncContextSlot()).createReadNode();
        JSReadFrameSlotNode asyncResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncResultSlot()).createReadNode();
        return this.factory.createAwait(this.context, expression, asyncContextNode, asyncResultNode);
    }

    private JavaScriptNode createYieldNode(UnaryNode unaryNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        assert (currentFunction.isGeneratorFunction());
        if (this.lc.getCurrentFunction().isModule()) {
            return this.factory.createModuleYield();
        }
        boolean asyncGeneratorYield = currentFunction.isAsyncFunction();
        boolean yieldStar = unaryNode.tokenType() == TokenType.YIELD_STAR;
        JavaScriptNode expression = this.transform(unaryNode.getExpression());
        ReturnNode returnNode = this.createReturnNode(null);
        if (asyncGeneratorYield) {
            currentFunction.addAwait();
            JSReadFrameSlotNode asyncContextNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncContextSlot()).createReadNode();
            JSReadFrameSlotNode asyncResultNode = (JSReadFrameSlotNode)this.environment.findTempVar(currentFunction.getAsyncResultSlot()).createReadNode();
            if (yieldStar) {
                Environment.VarRef tempVar = this.environment.createTempVar();
                return this.factory.createAsyncGeneratorYieldStar(this.context, expression, asyncContextNode, asyncResultNode, returnNode, tempVar.createReadNode(), (WriteNode)((Object)tempVar.createWriteNode(null)));
            }
            return this.factory.createAsyncGeneratorYield(this.context, expression, asyncContextNode, asyncResultNode, returnNode);
        }
        currentFunction.addYield();
        JSWriteFrameSlotNode writeYieldResultNode = (JSWriteFrameSlotNode)this.environment.findTempVar(currentFunction.getYieldResultSlot()).createWriteNode(null);
        return this.factory.createYield(this.context, expression, this.environment.findYieldValueVar().createReadNode(), yieldStar, returnNode, writeYieldResultNode);
    }

    private JavaScriptNode enterUnaryDefaultNode(UnaryNode unaryNode) {
        assert (unaryNode.tokenType() != TokenType.TYPEOF);
        JavaScriptNode operand = this.transform(unaryNode.getExpression());
        return this.tagExpression(this.factory.createUnary(GraalJSTranslator.tokenTypeToUnaryOperation(unaryNode.tokenType()), operand), unaryNode);
    }

    private JavaScriptNode enterTypeofNode(UnaryNode unaryNode) {
        assert (unaryNode.tokenType() == TokenType.TYPEOF);
        JavaScriptNode operand = null;
        if (unaryNode.getExpression() instanceof IdentNode) {
            IdentNode identNode = (IdentNode)unaryNode.getExpression();
            String identNodeName = identNode.getName();
            if (this.context.isOptionNashornCompatibilityMode() && (identNodeName.equals("__LINE__") || identNodeName.equals("__FILE__") || identNodeName.equals("__DIR__"))) {
                operand = GlobalPropertyNode.createPropertyNode(this.context, identNodeName);
            } else if (!identNode.isThis() && !identNode.isMetaProperty()) {
                operand = this.findScopeVarCheckTDZ(identNodeName, false).withRequired(false).createReadNode();
            }
        }
        if (operand == null) {
            operand = this.transform(unaryNode.getExpression());
        } else {
            this.tagExpression(operand, unaryNode.getExpression());
        }
        return this.tagExpression(this.factory.createUnary(GraalJSTranslator.tokenTypeToUnaryOperation(unaryNode.tokenType()), operand), unaryNode);
    }

    private JavaScriptNode enterUnaryIncDecNode(UnaryNode unaryNode) {
        if (unaryNode.getExpression() instanceof IdentNode) {
            IdentNode identNode = (IdentNode)unaryNode.getExpression();
            assert (!(identNode.isPropertyName() || identNode.isThis() || identNode.isMetaProperty() || identNode.isSuper()));
            Environment.VarRef varRef = this.findScopeVarCheckTDZ(identNode.getName(), false);
            if (varRef instanceof Environment.FrameSlotVarRef) {
                Environment.FrameSlotVarRef frameVarRef = (Environment.FrameSlotVarRef)varRef;
                FrameSlot frameSlot = frameVarRef.getFrameSlot();
                if (JSFrameUtil.isConst(frameSlot)) {
                    return this.tagExpression(this.checkMutableBinding(frameVarRef.createReadNode(), frameSlot.getIdentifier()), unaryNode);
                }
                return this.tagExpression(this.factory.createLocalVarInc(GraalJSTranslator.tokenTypeToUnaryOperation(unaryNode.tokenType()), frameSlot, frameVarRef.hasTDZCheck(), frameVarRef.createScopeFrameNode(), frameVarRef.getFrameDescriptor()), unaryNode);
            }
        }
        NodeFactory.BinaryOperation operation = unaryNode.tokenType() == TokenType.INCPREFIX || unaryNode.tokenType() == TokenType.INCPOSTFIX ? NodeFactory.BinaryOperation.ADD : NodeFactory.BinaryOperation.SUBTRACT;
        boolean isPostfix = unaryNode.tokenType() == TokenType.INCPOSTFIX || unaryNode.tokenType() == TokenType.DECPOSTFIX;
        return this.tagExpression(this.transformCompoundAssignment(unaryNode, unaryNode.getExpression(), this.factory.createConstantNumericUnit(), operation, isPostfix, true), unaryNode);
    }

    private static NodeFactory.UnaryOperation tokenTypeToUnaryOperation(TokenType tokenType) {
        switch (tokenType) {
            case ADD: {
                return NodeFactory.UnaryOperation.PLUS;
            }
            case BIT_NOT: {
                return NodeFactory.UnaryOperation.BITWISE_COMPLEMENT;
            }
            case NOT: {
                return NodeFactory.UnaryOperation.NOT;
            }
            case SUB: {
                return NodeFactory.UnaryOperation.MINUS;
            }
            case TYPEOF: {
                return NodeFactory.UnaryOperation.TYPE_OF;
            }
            case VOID: {
                return NodeFactory.UnaryOperation.VOID;
            }
            case DECPREFIX: {
                return NodeFactory.UnaryOperation.PREFIX_LOCAL_DECREMENT;
            }
            case DECPOSTFIX: {
                return NodeFactory.UnaryOperation.POSTFIX_LOCAL_DECREMENT;
            }
            case INCPREFIX: {
                return NodeFactory.UnaryOperation.PREFIX_LOCAL_INCREMENT;
            }
            case INCPOSTFIX: {
                return NodeFactory.UnaryOperation.POSTFIX_LOCAL_INCREMENT;
            }
        }
        throw new UnsupportedOperationException(tokenType.toString());
    }

    private JavaScriptNode enterNamedEvaluation(UnaryNode unaryNode) {
        return this.factory.createNamedEvaluation(this.transform(unaryNode.getExpression()), this.factory.createAccessArgument(0));
    }

    private JavaScriptNode enterDelete(UnaryNode unaryNode) {
        Expression rhs = unaryNode.getExpression();
        if (rhs instanceof AccessNode || rhs instanceof IndexNode) {
            return this.enterDeleteProperty(unaryNode);
        }
        return this.enterDeleteIdent(unaryNode);
    }

    private JavaScriptNode enterDeleteIdent(UnaryNode unaryNode) {
        JavaScriptNode result;
        Expression rhs = unaryNode.getExpression();
        if (rhs instanceof IdentNode) {
            String varName = ((IdentNode)rhs).getName();
            Environment.VarRef varRef = this.findScopeVar(varName, varName.equals("this"));
            result = varRef.createDeleteNode();
        } else {
            result = rhs instanceof LiteralNode.PrimitiveLiteralNode ? this.factory.createConstantBoolean(true) : this.factory.createDual(this.context, this.transform(rhs), this.factory.createConstantBoolean(true));
        }
        return this.tagExpression(result, unaryNode);
    }

    private JavaScriptNode enterDeleteProperty(UnaryNode deleteNode) {
        JavaScriptNode key;
        BaseNode baseNode = (BaseNode)deleteNode.getExpression();
        if (baseNode.isSuper()) {
            return this.tagExpression(this.factory.createThrowError(JSErrorType.ReferenceError, "Unsupported reference to 'super'"), deleteNode);
        }
        JavaScriptNode target = this.transform(baseNode.getBase());
        if (baseNode instanceof AccessNode) {
            AccessNode accessNode = (AccessNode)baseNode;
            assert (!accessNode.isPrivate());
            key = this.factory.createConstantString(accessNode.getProperty());
        } else {
            assert (baseNode instanceof IndexNode);
            IndexNode indexNode = (IndexNode)baseNode;
            key = this.transform(indexNode.getIndex());
        }
        if (baseNode.isOptionalChain()) {
            target = this.filterOptionalChainTarget(target, baseNode.isOptional());
        }
        JavaScriptNode delete = this.factory.createDeleteProperty(target, key, this.environment.isStrictMode(), this.context);
        this.tagExpression(delete, deleteNode);
        if (baseNode.isOptionalChain()) {
            delete = this.factory.createOptionalChain(delete);
        }
        return delete;
    }

    private JavaScriptNode filterOptionalChainTarget(JavaScriptNode target, boolean optional) {
        JavaScriptNode innerAccess = target instanceof OptionalChainNode ? ((OptionalChainNode)target).getAccessNode() : (target instanceof OptionalChainNode.OptionalTargetableNode ? ((OptionalChainNode.OptionalTargetableNode)target).getDelegateNode() : target);
        if (optional) {
            innerAccess = this.factory.createOptionalChainShortCircuit(innerAccess);
        }
        return innerAccess;
    }

    private JavaScriptNode[] transformArgs(List<Expression> argList) {
        int len = argList.size();
        if ((long)len > this.context.getFunctionArgumentsLimit()) {
            throw Errors.createSyntaxError("function has too many parameters");
        }
        JavaScriptNode[] args = GraalJSTranslator.javaScriptNodeArray(len);
        for (int i = 0; i < len; ++i) {
            args[i] = this.transform(argList.get(i));
        }
        return args;
    }

    private JavaScriptNode enterNewNode(UnaryNode unaryNode) {
        CallNode callNode = (CallNode)unaryNode.getExpression();
        JavaScriptNode function = this.transform(callNode.getFunction());
        JavaScriptNode[] args = this.transformArgs(callNode.getArgs());
        JavaScriptNode call = this.factory.createNew(this.context, function, args);
        return this.tagExpression(GraalJSTranslator.tagCall(call), unaryNode);
    }

    @Override
    public JavaScriptNode enterCallNode(CallNode callNode) {
        JavaScriptNode function = this.transform(callNode.getFunction());
        JavaScriptNode[] args = this.transformArgs(callNode.getArgs());
        if (callNode.isOptionalChain()) {
            function = this.filterOptionalChainTarget(function, callNode.isOptional());
        }
        JavaScriptNode call = callNode.isEval() && args.length >= 1 ? this.createCallEvalNode(function, args) : (callNode.isApplyArguments() && this.currentFunction().isDirectArgumentsAccess() ? this.createCallApplyArgumentsNode(function, args) : (callNode.getFunction() instanceof IdentNode && ((IdentNode)callNode.getFunction()).isDirectSuper() ? this.createCallDirectSuper(function, args) : (callNode.isImport() ? this.createImportCallNode(args) : this.factory.createFunctionCall(this.context, function, args))));
        this.tagExpression(GraalJSTranslator.tagCall(call), callNode);
        if (callNode.isOptionalChain()) {
            call = this.factory.createOptionalChain(call);
        }
        return call;
    }

    private JavaScriptNode[] insertNewTargetArg(JavaScriptNode[] args) {
        JavaScriptNode[] result = new JavaScriptNode[args.length + 1];
        result[0] = this.environment.findNewTargetVar().createReadNode();
        System.arraycopy(args, 0, result, 1, args.length);
        return result;
    }

    private JavaScriptNode initializeThis(JavaScriptNode thisValueNode) {
        Environment.VarRef thisVar = this.environment.findThisVar();
        Environment.VarRef tempVar = this.environment.createTempVar();
        JavaScriptNode uninitialized = this.factory.createBinary(this.context, NodeFactory.BinaryOperation.IDENTICAL, thisVar.createReadNode(), this.factory.createConstantUndefined());
        return this.factory.createIf(this.factory.createDual(this.context, tempVar.createWriteNode(thisValueNode), uninitialized), this.initializeInstanceElements(thisVar.createWriteNode(tempVar.createReadNode())), this.factory.createThrowError(JSErrorType.ReferenceError, "super() called twice"));
    }

    private JavaScriptNode initializeInstanceElements(JavaScriptNode thisValueNode) {
        ClassNode classNode = this.lc.getCurrentClass();
        if (!classNode.hasInstanceFields() && !classNode.hasPrivateInstanceMethods()) {
            return thisValueNode;
        }
        JavaScriptNode constructor = this.factory.createAccessCallee(this.currentFunction().getThisFunctionLevel());
        return this.factory.createInitializeInstanceElements(this.context, thisValueNode, constructor);
    }

    private JavaScriptNode createCallEvalNode(JavaScriptNode function, JavaScriptNode[] args) {
        assert (this.currentFunction().isGlobal() || this.currentFunction().isStrictMode() || this.currentFunction().isDirectEval() || this.currentFunction().isDynamicallyScoped());
        this.currentFunction().prepareForDirectEval();
        return EvalNode.create(this.context, function, args, this.createThisNodeUnchecked(), new DirectEvalContext(this.lc.getCurrentScope(), this.environment, this.lc.getCurrentClass()), this.environment.getCurrentBlockScopeSlot());
    }

    private JavaScriptNode createCallApplyArgumentsNode(JavaScriptNode function, JavaScriptNode[] args) {
        return this.factory.createCallApplyArguments((JSFunctionCallNode)this.factory.createFunctionCall(this.context, function, args));
    }

    private JavaScriptNode createCallDirectSuper(JavaScriptNode function, JavaScriptNode[] args) {
        return this.initializeThis(this.factory.createFunctionCallWithNewTarget(this.context, function, this.insertNewTargetArg(args)));
    }

    private JavaScriptNode createImportCallNode(JavaScriptNode[] args) {
        assert (args.length == 1 || this.context.getContextOptions().isImportAssertions() && args.length == 2);
        JavaScriptNode activeScriptOrModule = this.getActiveScriptOrModule();
        if (this.context.getContextOptions().isImportAssertions() && args.length == 2) {
            return this.factory.createImportCall(this.context, args[0], activeScriptOrModule, args[1]);
        }
        return this.factory.createImportCall(this.context, args[0], activeScriptOrModule);
    }

    @Override
    public JavaScriptNode enterBinaryNode(BinaryNode binaryNode) {
        switch (binaryNode.tokenType()) {
            case ASSIGN: 
            case ASSIGN_INIT: {
                return this.enterBinaryAssignNode(binaryNode);
            }
            case ASSIGN_ADD: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_EXP: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_SHR: 
            case ASSIGN_SUB: 
            case ASSIGN_AND: 
            case ASSIGN_OR: 
            case ASSIGN_NULLCOAL: {
                return this.enterBinaryTransformNode(binaryNode);
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case EXP: 
            case DIV: 
            case MOD: 
            case EQ: 
            case EQ_STRICT: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case NE: 
            case NE_STRICT: 
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case SAR: 
            case SHL: 
            case SHR: 
            case AND: 
            case OR: 
            case NULLISHCOALESC: 
            case INSTANCEOF: 
            case IN: 
            case COMMARIGHT: {
                return this.enterBinaryExpressionNode(binaryNode);
            }
        }
        throw new UnsupportedOperationException(binaryNode.tokenType().toString());
    }

    private JavaScriptNode enterBinaryExpressionNode(BinaryNode binaryNode) {
        Expression lhsExpr = binaryNode.getLhs();
        JavaScriptNode lhs = this.transform(lhsExpr);
        JavaScriptNode rhs = this.transform(binaryNode.getRhs());
        JavaScriptNode result = lhsExpr instanceof IdentNode && ((IdentNode)lhsExpr).isPrivateInCheck() ? this.factory.createPrivateFieldIn(lhs, rhs) : this.factory.createBinary(this.context, GraalJSTranslator.tokenTypeToBinaryOperation(binaryNode.tokenType()), lhs, rhs);
        return this.tagExpression(result, binaryNode);
    }

    private JavaScriptNode enterBinaryTransformNode(BinaryNode binaryNode) {
        JavaScriptNode assignedValue = this.transform(binaryNode.getAssignmentSource());
        return this.tagExpression(this.transformCompoundAssignment(binaryNode, binaryNode.getAssignmentDest(), assignedValue, GraalJSTranslator.tokenTypeToBinaryOperation(binaryNode.tokenType()), false, false), binaryNode);
    }

    private JavaScriptNode enterBinaryAssignNode(BinaryNode binaryNode) {
        Expression assignmentDest = binaryNode.getAssignmentDest();
        JavaScriptNode assignedValue = this.transform(binaryNode.getAssignmentSource());
        JavaScriptNode assignment = this.transformAssignment(binaryNode, assignmentDest, assignedValue, binaryNode.isTokenType(TokenType.ASSIGN_INIT));
        assert (assignedValue != null && (assignedValue.hasTag(StandardTags.ExpressionTag.class) || !assignedValue.isInstrumentable())) : "ExpressionTag expected but not found for: " + assignedValue;
        return this.tagExpression(assignment, binaryNode);
    }

    private static NodeFactory.BinaryOperation tokenTypeToBinaryOperation(TokenType tokenType) {
        switch (tokenType) {
            case ADD: 
            case ASSIGN_ADD: {
                return NodeFactory.BinaryOperation.ADD;
            }
            case SUB: 
            case ASSIGN_SUB: {
                return NodeFactory.BinaryOperation.SUBTRACT;
            }
            case ASSIGN_MUL: 
            case MUL: {
                return NodeFactory.BinaryOperation.MULTIPLY;
            }
            case ASSIGN_EXP: 
            case EXP: {
                return NodeFactory.BinaryOperation.EXPONENTIATE;
            }
            case ASSIGN_DIV: 
            case DIV: {
                return NodeFactory.BinaryOperation.DIVIDE;
            }
            case ASSIGN_MOD: 
            case MOD: {
                return NodeFactory.BinaryOperation.MODULO;
            }
            case ASSIGN_BIT_AND: 
            case BIT_AND: {
                return NodeFactory.BinaryOperation.BITWISE_AND;
            }
            case ASSIGN_BIT_OR: 
            case BIT_OR: {
                return NodeFactory.BinaryOperation.BITWISE_OR;
            }
            case ASSIGN_BIT_XOR: 
            case BIT_XOR: {
                return NodeFactory.BinaryOperation.BITWISE_XOR;
            }
            case ASSIGN_SHL: 
            case SHL: {
                return NodeFactory.BinaryOperation.BITWISE_LEFT_SHIFT;
            }
            case ASSIGN_SAR: 
            case SAR: {
                return NodeFactory.BinaryOperation.BITWISE_RIGHT_SHIFT;
            }
            case ASSIGN_SHR: 
            case SHR: {
                return NodeFactory.BinaryOperation.BITWISE_UNSIGNED_RIGHT_SHIFT;
            }
            case EQ: {
                return NodeFactory.BinaryOperation.EQUAL;
            }
            case EQ_STRICT: {
                return NodeFactory.BinaryOperation.IDENTICAL;
            }
            case GE: {
                return NodeFactory.BinaryOperation.GREATER_OR_EQUAL;
            }
            case GT: {
                return NodeFactory.BinaryOperation.GREATER;
            }
            case LE: {
                return NodeFactory.BinaryOperation.LESS_OR_EQUAL;
            }
            case LT: {
                return NodeFactory.BinaryOperation.LESS;
            }
            case NE: {
                return NodeFactory.BinaryOperation.NOT_EQUAL;
            }
            case NE_STRICT: {
                return NodeFactory.BinaryOperation.NOT_IDENTICAL;
            }
            case ASSIGN_AND: 
            case AND: {
                return NodeFactory.BinaryOperation.LOGICAL_AND;
            }
            case ASSIGN_OR: 
            case OR: {
                return NodeFactory.BinaryOperation.LOGICAL_OR;
            }
            case ASSIGN_NULLCOAL: 
            case NULLISHCOALESC: {
                return NodeFactory.BinaryOperation.NULLISH_COALESCING;
            }
            case INSTANCEOF: {
                return NodeFactory.BinaryOperation.INSTANCEOF;
            }
            case IN: {
                return NodeFactory.BinaryOperation.IN;
            }
            case COMMARIGHT: {
                return NodeFactory.BinaryOperation.DUAL;
            }
        }
        throw new UnsupportedOperationException(tokenType.toString());
    }

    private JavaScriptNode transformAssignment(Expression assignmentExpression, Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment) {
        return this.transformAssignmentImpl(assignmentExpression, lhsExpression, assignedValue, initializationAssignment, null, false, false);
    }

    private JavaScriptNode transformCompoundAssignment(Expression assignmentExpression, Expression lhsExpression, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertLHSToNumeric) {
        return this.transformAssignmentImpl(assignmentExpression, lhsExpression, assignedValue, false, binaryOp, returnOldValue, convertLHSToNumeric);
    }

    private JavaScriptNode transformAssignmentImpl(Expression assignmentExpression, Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertLHSToNumeric) {
        JavaScriptNode assignedNode;
        switch (lhsExpression.tokenType()) {
            default: {
                if (!(lhsExpression instanceof IdentNode)) {
                    throw Errors.unsupported("unsupported assignment to token type: " + lhsExpression.tokenType().toString() + " " + lhsExpression.toString());
                }
            }
            case IDENT: {
                assignedNode = this.transformAssignmentIdent((IdentNode)lhsExpression, assignedValue, binaryOp, returnOldValue, convertLHSToNumeric, initializationAssignment);
                break;
            }
            case LBRACKET: {
                assignedNode = this.transformIndexAssignment((IndexNode)lhsExpression, assignedValue, binaryOp, returnOldValue, convertLHSToNumeric);
                break;
            }
            case PERIOD: {
                assignedNode = this.transformPropertyAssignment((AccessNode)lhsExpression, assignedValue, binaryOp, returnOldValue, convertLHSToNumeric);
                break;
            }
            case ARRAY: {
                assert (binaryOp == null);
                assignedNode = this.transformDestructuringArrayAssignment(lhsExpression, assignedValue, initializationAssignment);
                break;
            }
            case LBRACE: {
                assert (binaryOp == null);
                assignedNode = this.transformDestructuringObjectAssignment(lhsExpression, assignedValue, initializationAssignment);
            }
        }
        if (returnOldValue && assignedNode instanceof DualNode) {
            this.ensureHasSourceSection(((DualNode)assignedNode).getLeft(), assignmentExpression);
        }
        return this.tagExpression(assignedNode, assignmentExpression);
    }

    private static boolean isLogicalOp(NodeFactory.BinaryOperation op) {
        return op == NodeFactory.BinaryOperation.LOGICAL_AND || op == NodeFactory.BinaryOperation.LOGICAL_OR || op == NodeFactory.BinaryOperation.NULLISH_COALESCING;
    }

    private JavaScriptNode transformAssignmentIdent(IdentNode identNode, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertLHSToNumeric, boolean initializationAssignment) {
        JavaScriptNode rhs = assignedValue;
        String ident = identNode.getName();
        Environment.VarRef scopeVar = this.findScopeVarCheckTDZ(ident, initializationAssignment);
        if (!initializationAssignment && scopeVar.isConst()) {
            if (this.context.getContextOptions().isV8LegacyConst() && !this.environment.isStrictMode()) {
                return rhs;
            }
            rhs = this.checkMutableBinding(rhs, scopeVar.getName());
        }
        if (binaryOp == null) {
            return scopeVar.createWriteNode(rhs);
        }
        if (GraalJSTranslator.isLogicalOp(binaryOp)) {
            assert (!convertLHSToNumeric && !returnOldValue);
            JavaScriptNode readNode = this.tagExpression(scopeVar.createReadNode(), identNode);
            JavaScriptNode writeNode = scopeVar.createWriteNode(assignedValue);
            return this.factory.createBinary(this.context, binaryOp, readNode, writeNode);
        }
        Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> pair = scopeVar.createCompoundAssignNode();
        JavaScriptNode readNode = this.tagExpression(pair.getFirst().get(), identNode);
        if (convertLHSToNumeric) {
            readNode = this.factory.createToNumericOperand(readNode);
        }
        Environment.VarRef prevValueTemp = null;
        if (returnOldValue) {
            prevValueTemp = this.environment.createTempVar();
            readNode = prevValueTemp.createWriteNode(readNode);
        }
        JavaScriptNode binOpNode = this.tagExpression(this.factory.createBinary(this.context, binaryOp, readNode, rhs), identNode);
        JavaScriptNode writeNode = (JavaScriptNode)pair.getSecond().apply(binOpNode);
        if (returnOldValue) {
            return this.factory.createDual(this.context, writeNode, prevValueTemp.createReadNode());
        }
        return writeNode;
    }

    private JavaScriptNode checkMutableBinding(JavaScriptNode rhsNode, Object identifier) {
        if (this.context.getContextOptions().isV8LegacyConst() && !this.environment.isStrictMode()) {
            return rhsNode;
        }
        String message = this.context.isOptionV8CompatibilityMode() ? "Assignment to constant variable." : "Assignment to constant \"" + identifier + "\"";
        JavaScriptNode throwTypeError = this.factory.createThrowError(JSErrorType.TypeError, message);
        return GraalJSTranslator.isPotentiallySideEffecting(rhsNode) ? this.createBlock(rhsNode, throwTypeError) : throwTypeError;
    }

    private JavaScriptNode transformPropertyAssignment(AccessNode accessNode, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertToNumeric) {
        JavaScriptNode assignedNode;
        JavaScriptNode target = this.transform(accessNode.getBase());
        if (binaryOp == null) {
            assignedNode = this.createWriteProperty(accessNode, target, assignedValue);
        } else {
            JavaScriptNode target2;
            JavaScriptNode target1;
            if (target instanceof RepeatableNode) {
                target1 = target;
                target2 = this.factory.copy(target);
            } else {
                Environment.VarRef targetTemp = this.environment.createTempVar();
                target1 = targetTemp.createWriteNode(target);
                target2 = targetTemp.createReadNode();
            }
            if (GraalJSTranslator.isLogicalOp(binaryOp)) {
                assert (!convertToNumeric && !returnOldValue);
                JavaScriptNode readNode = this.tagExpression(this.createReadProperty(accessNode, target1), accessNode);
                JavaScriptNode writeNode = this.createWriteProperty(accessNode, target2, assignedValue);
                assignedNode = this.factory.createBinary(this.context, binaryOp, readNode, writeNode);
            } else {
                Environment.VarRef prevValueTemp = null;
                JavaScriptNode readNode = this.tagExpression(this.createReadProperty(accessNode, target2), accessNode);
                if (convertToNumeric) {
                    readNode = this.factory.createToNumericOperand(readNode);
                }
                if (returnOldValue) {
                    prevValueTemp = this.environment.createTempVar();
                    readNode = prevValueTemp.createWriteNode(readNode);
                }
                JavaScriptNode binOpNode = this.tagExpression(this.factory.createBinary(this.context, binaryOp, readNode, assignedValue), accessNode);
                JavaScriptNode writeNode = this.createWriteProperty(accessNode, target1, binOpNode);
                assignedNode = returnOldValue ? this.factory.createDual(this.context, writeNode, prevValueTemp.createReadNode()) : writeNode;
            }
        }
        return assignedNode;
    }

    private JavaScriptNode transformIndexAssignment(IndexNode indexNode, JavaScriptNode assignedValue, NodeFactory.BinaryOperation binaryOp, boolean returnOldValue, boolean convertToNumeric) {
        JavaScriptNode assignedNode;
        JavaScriptNode target = this.transform(indexNode.getBase());
        JavaScriptNode elem = this.transform(indexNode.getIndex());
        if (binaryOp == null) {
            assignedNode = this.factory.createWriteElementNode(target, elem, assignedValue, this.context, this.environment.isStrictMode());
        } else {
            JavaScriptNode readNode;
            JavaScriptNode target2;
            JavaScriptNode target1;
            Environment.VarRef keyTemp = this.environment.createTempVar();
            JavaScriptNode readIndex = keyTemp.createReadNode();
            JSWriteFrameSlotNode writeIndex = (JSWriteFrameSlotNode)keyTemp.createWriteNode(null);
            if (target instanceof RepeatableNode) {
                target1 = target;
                target2 = this.factory.copy(target);
            } else {
                Environment.VarRef targetTemp = this.environment.createTempVar();
                target1 = targetTemp.createWriteNode(target);
                target2 = targetTemp.createReadNode();
            }
            if (GraalJSTranslator.isLogicalOp(binaryOp)) {
                assert (!convertToNumeric && !returnOldValue);
                readNode = this.tagExpression(this.factory.createReadElementNode(this.context, target1, keyTemp.createWriteNode(elem)), indexNode);
                WriteElementNode writeNode = this.factory.createCompoundWriteElementNode(target2, readIndex, assignedValue, null, this.context, this.environment.isStrictMode());
                assignedNode = this.factory.createBinary(this.context, binaryOp, readNode, writeNode);
            } else {
                readNode = this.tagExpression(this.factory.createReadElementNode(this.context, target2, readIndex), indexNode);
                if (convertToNumeric) {
                    readNode = this.factory.createToNumericOperand(readNode);
                }
                Environment.VarRef prevValueTemp = null;
                if (returnOldValue) {
                    prevValueTemp = this.environment.createTempVar();
                    readNode = prevValueTemp.createWriteNode(readNode);
                }
                JavaScriptNode binOpNode = this.tagExpression(this.factory.createBinary(this.context, binaryOp, readNode, assignedValue), indexNode);
                WriteElementNode writeNode = this.factory.createCompoundWriteElementNode(target1, elem, binOpNode, writeIndex, this.context, this.environment.isStrictMode());
                assignedNode = returnOldValue ? this.factory.createDual(this.context, writeNode, prevValueTemp.createReadNode()) : writeNode;
            }
        }
        return assignedNode;
    }

    private JavaScriptNode transformDestructuringArrayAssignment(Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment) {
        LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)lhsExpression;
        List<Expression> elementExpressions = arrayLiteralNode.getElementExpressions();
        JavaScriptNode[] initElements = GraalJSTranslator.javaScriptNodeArray(elementExpressions.size());
        Environment.VarRef iteratorTempVar = this.environment.createTempVar();
        Environment.VarRef valueTempVar = this.environment.createTempVar();
        JavaScriptNode initValue = valueTempVar.createWriteNode(assignedValue);
        JavaScriptNode getIterator = this.factory.createGetIterator(this.context, initValue);
        JavaScriptNode initIteratorTempVar = iteratorTempVar.createWriteNode(getIterator);
        for (int i = 0; i < elementExpressions.size(); ++i) {
            Expression lhsExpr;
            Expression element = elementExpressions.get(i);
            Expression init = null;
            if (element instanceof IdentNode) {
                lhsExpr = element;
            } else if (element instanceof BinaryNode) {
                assert (element.isTokenType(TokenType.ASSIGN) || element.isTokenType(TokenType.ASSIGN_INIT));
                lhsExpr = ((BinaryNode)element).getLhs();
                init = ((BinaryNode)element).getRhs();
            } else {
                lhsExpr = element;
            }
            JavaScriptNode rhsNode = this.factory.createIteratorGetNextValue(this.context, iteratorTempVar.createReadNode(), this.factory.createConstantUndefined(), true);
            if (init != null) {
                rhsNode = this.factory.createNotUndefinedOr(rhsNode, this.transform(init));
            }
            if (lhsExpr != null && lhsExpr.isTokenType(TokenType.SPREAD_ARRAY)) {
                rhsNode = this.factory.createIteratorToArray(this.context, iteratorTempVar.createReadNode());
                lhsExpr = ((UnaryNode)lhsExpr).getExpression();
            }
            initElements[i] = lhsExpr != null ? this.transformAssignment(lhsExpr, lhsExpr, rhsNode, initializationAssignment) : rhsNode;
        }
        JavaScriptNode closeIfNotDone = this.factory.createIteratorCloseIfNotDone(this.context, this.createBlock(initElements), iteratorTempVar.createReadNode());
        return this.factory.createExprBlock(initIteratorTempVar, closeIfNotDone, valueTempVar.createReadNode());
    }

    private JavaScriptNode transformDestructuringObjectAssignment(Expression lhsExpression, JavaScriptNode assignedValue, boolean initializationAssignment) {
        ObjectNode objectLiteralNode = (ObjectNode)lhsExpression;
        List<com.oracle.js.parser.ir.PropertyNode> propertyExpressions = objectLiteralNode.getElements();
        if (propertyExpressions.isEmpty()) {
            return this.factory.createRequireObjectCoercible(assignedValue);
        }
        int numberOfProperties = propertyExpressions.size();
        boolean hasRest = propertyExpressions.get(numberOfProperties - 1).isRest();
        boolean requireObjectCoercible = hasRest && numberOfProperties == 1;
        JavaScriptNode[] initElements = GraalJSTranslator.javaScriptNodeArray(numberOfProperties);
        JavaScriptNode[] excludedKeys = hasRest ? GraalJSTranslator.javaScriptNodeArray(numberOfProperties - 1) : null;
        Environment.VarRef valueTempVar = this.environment.createTempVar();
        JavaScriptNode initValueTempVar = valueTempVar.createWriteNode(requireObjectCoercible ? this.factory.createRequireObjectCoercible(assignedValue) : assignedValue);
        for (int i = 0; i < numberOfProperties; ++i) {
            JavaScriptNode rhsNode;
            Expression lhsExpr;
            com.oracle.js.parser.ir.PropertyNode property = propertyExpressions.get(i);
            Expression init = null;
            if (property.getValue() instanceof BinaryNode) {
                assert (property.getValue().isTokenType(TokenType.ASSIGN) || property.getValue().isTokenType(TokenType.ASSIGN_INIT));
                lhsExpr = ((BinaryNode)property.getValue()).getLhs();
                init = ((BinaryNode)property.getValue()).getRhs();
            } else if (property.isRest()) {
                assert (hasRest);
                lhsExpr = ((UnaryNode)property.getKey()).getExpression();
            } else {
                lhsExpr = property.getValue();
            }
            JavaScriptNode toPropertyKey = null;
            if (property.isRest()) {
                JavaScriptNode excludedItemsArray = excludedKeys.length == 0 ? null : this.factory.createArrayLiteral(this.context, excludedKeys);
                rhsNode = this.factory.createRestObject(this.context, valueTempVar.createReadNode(), excludedItemsArray);
            } else if (property.getKey() instanceof IdentNode && !property.isComputed()) {
                String keyName = property.getKeyName();
                if (hasRest) {
                    excludedKeys[i] = this.factory.createConstantString(keyName);
                }
                rhsNode = this.factory.createReadProperty(this.context, valueTempVar.createReadNode(), keyName);
            } else {
                JavaScriptNode key = this.transform(property.getKey());
                Environment.VarRef keyTempVar = this.environment.createTempVar();
                if (hasRest) {
                    excludedKeys[i] = keyTempVar.createReadNode();
                }
                toPropertyKey = keyTempVar.createWriteNode(this.factory.createToPropertyKey(key));
                rhsNode = this.factory.createReadElementNode(this.context, valueTempVar.createReadNode(), keyTempVar.createReadNode());
            }
            if (init != null) {
                rhsNode = this.factory.createNotUndefinedOr(rhsNode, this.transform(init));
            }
            JavaScriptNode initElement = this.transformAssignment(lhsExpr, lhsExpr, rhsNode, initializationAssignment);
            initElements[i] = toPropertyKey == null ? initElement : this.factory.createDual(this.context, toPropertyKey, initElement);
        }
        return this.factory.createExprBlock(initValueTempVar, this.createBlock(initElements), valueTempVar.createReadNode());
    }

    @Override
    public JavaScriptNode enterAccessNode(AccessNode accessNode) {
        JavaScriptNode base = this.transform(accessNode.getBase());
        if (accessNode.isOptionalChain()) {
            return this.createOptionalAccessNode(accessNode, base);
        }
        JavaScriptNode read = this.createReadProperty(accessNode, base);
        this.tagExpression(read, accessNode);
        return read;
    }

    private JavaScriptNode createOptionalAccessNode(AccessNode accessNode, JavaScriptNode base) {
        JavaScriptNode innerAccess = this.filterOptionalChainTarget(base, accessNode.isOptional());
        JavaScriptNode read = this.createReadProperty(accessNode, innerAccess);
        this.tagExpression(read, accessNode);
        return this.factory.createOptionalChain(read);
    }

    private JavaScriptNode createReadProperty(AccessNode accessNode, JavaScriptNode base) {
        if (accessNode.isPrivate()) {
            return this.createPrivateFieldGet(accessNode, base);
        }
        return this.factory.createReadProperty(this.context, base, accessNode.getProperty(), accessNode.isFunction());
    }

    private JavaScriptNode createWriteProperty(AccessNode accessNode, JavaScriptNode base, JavaScriptNode rhs) {
        if (accessNode.isPrivate()) {
            return this.createPrivateFieldSet(accessNode, base, rhs);
        }
        return this.factory.createWriteProperty(base, accessNode.getProperty(), rhs, this.context, this.environment.isStrictMode());
    }

    private JavaScriptNode createPrivateFieldGet(AccessNode accessNode, JavaScriptNode base) {
        Environment.VarRef privateNameVar = this.environment.findLocalVar(accessNode.getPrivateName());
        JavaScriptNode privateName = privateNameVar.createReadNode();
        return this.factory.createPrivateFieldGet(this.context, this.insertPrivateBrandCheck(base, privateNameVar), privateName);
    }

    private JavaScriptNode createPrivateFieldSet(AccessNode accessNode, JavaScriptNode base, JavaScriptNode rhs) {
        Environment.VarRef privateNameVar = this.environment.findLocalVar(accessNode.getPrivateName());
        JavaScriptNode privateName = privateNameVar.createReadNode();
        return this.factory.createPrivateFieldSet(this.context, this.insertPrivateBrandCheck(base, privateNameVar), privateName, rhs);
    }

    private JavaScriptNode insertPrivateBrandCheck(JavaScriptNode base, Environment.VarRef privateNameVar) {
        FrameSlot frameSlot = privateNameVar.getFrameSlot();
        if (JSFrameUtil.needsPrivateBrandCheck(frameSlot)) {
            JavaScriptNode brand = this.getPrivateBrandNode(frameSlot, privateNameVar);
            return this.factory.createPrivateBrandCheck(base, brand);
        }
        return base;
    }

    private JavaScriptNode getPrivateBrandNode(FrameSlot frameSlot, Environment.VarRef privateNameVar) {
        int frameLevel = ((Environment.AbstractFrameVarRef)privateNameVar).getFrameLevel();
        int scopeLevel = ((Environment.AbstractFrameVarRef)privateNameVar).getScopeLevel();
        Environment memberEnv = this.environment.getParentAt(frameLevel, scopeLevel);
        FrameSlot constructorSlot = memberEnv.getBlockFrameDescriptor().findFrameSlot("#constructor");
        JavaScriptNode constructor = this.environment.createLocal(constructorSlot, frameLevel, scopeLevel);
        if (JSFrameUtil.isPrivateNameStatic(frameSlot)) {
            return constructor;
        }
        return this.factory.createGetPrivateBrand(this.context, constructor);
    }

    @Override
    public JavaScriptNode enterIndexNode(IndexNode indexNode) {
        JavaScriptNode base = this.transform(indexNode.getBase());
        JavaScriptNode index = this.transform(indexNode.getIndex());
        if (indexNode.isOptionalChain()) {
            return this.createOptionalIndexNode(indexNode, base, index);
        }
        return this.tagExpression(this.factory.createReadElementNode(this.context, base, index), indexNode);
    }

    private JavaScriptNode createOptionalIndexNode(IndexNode indexNode, JavaScriptNode base, JavaScriptNode index) {
        ReadElementNode read = this.factory.createReadElementNode(this.context, this.filterOptionalChainTarget(base, indexNode.isOptional()), index);
        this.tagExpression(read, indexNode);
        return this.factory.createOptionalChain(read);
    }

    @Override
    public JavaScriptNode enterObjectNode(ObjectNode objectNode) {
        ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = this.transformPropertyDefinitionList(objectNode.getElements(), false, null);
        return this.tagExpression(this.factory.createObjectLiteral(this.context, members), objectNode);
    }

    private ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> transformPropertyDefinitionList(List<com.oracle.js.parser.ir.PropertyNode> properties, boolean isClass, Symbol classNameSymbol) {
        ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = new ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            ObjectLiteralNode.ObjectLiteralMemberNode member;
            com.oracle.js.parser.ir.PropertyNode property = properties.get(i);
            if (property.getValue() != null || property.isClassField()) {
                member = this.enterObjectPropertyNode(property, isClass, classNameSymbol);
            } else if (property.isRest()) {
                assert (!isClass);
                JavaScriptNode from = this.transform(((UnaryNode)property.getKey()).getExpression());
                member = this.factory.createSpreadObjectMember(property.isStatic(), from);
            } else {
                member = this.enterObjectAccessorNode(property, isClass);
            }
            members.add(member);
        }
        return members;
    }

    private ObjectLiteralNode.ObjectLiteralMemberNode enterObjectAccessorNode(com.oracle.js.parser.ir.PropertyNode property, boolean isClass) {
        boolean enumerable;
        assert (property.getGetter() != null || property.getSetter() != null);
        JavaScriptNode getter = this.getAccessor(property.getGetter());
        JavaScriptNode setter = this.getAccessor(property.getSetter());
        boolean bl = enumerable = !isClass;
        if (property.isComputed()) {
            return this.factory.createComputedAccessorMember(this.transform(property.getKey()), property.isStatic(), enumerable, getter, setter);
        }
        if (property.isPrivate()) {
            Environment.VarRef privateVar = this.environment.findLocalVar(property.getPrivateName());
            JSWriteFrameSlotNode writePrivateNode = (JSWriteFrameSlotNode)privateVar.createWriteNode(null);
            return this.factory.createPrivateAccessorMember(property.isStatic(), getter, setter, writePrivateNode);
        }
        return this.factory.createAccessorMember(property.getKeyName(), property.isStatic(), enumerable, getter, setter);
    }

    private JavaScriptNode getAccessor(FunctionNode accessorFunction) {
        if (accessorFunction == null) {
            return null;
        }
        JavaScriptNode function = this.transform(accessorFunction);
        if (accessorFunction.needsSuper()) {
            assert (accessorFunction.isMethod());
            function = this.factory.createMakeMethod(this.context, function);
        }
        return function;
    }

    private JavaScriptNode transformPropertyValue(Expression propertyValue, Symbol classNameSymbol) {
        if (propertyValue == null) {
            return this.factory.createConstantUndefined();
        }
        if (classNameSymbol != null) {
            classNameSymbol.setHasBeenDeclared(true);
        }
        JavaScriptNode value = this.transform(propertyValue);
        if (classNameSymbol != null) {
            classNameSymbol.setHasBeenDeclared(false);
        }
        if (propertyValue instanceof FunctionNode && ((FunctionNode)propertyValue).needsSuper()) {
            assert (((FunctionNode)propertyValue).isMethod());
            value = this.factory.createMakeMethod(this.context, value);
        }
        return value;
    }

    private ObjectLiteralNode.ObjectLiteralMemberNode enterObjectPropertyNode(com.oracle.js.parser.ir.PropertyNode property, boolean isClass, Symbol classNameSymbol) {
        boolean enumerable;
        JavaScriptNode value = this.transformPropertyValue(property.getValue(), classNameSymbol);
        boolean bl = enumerable = !isClass || property.isClassField();
        if (property.isComputed()) {
            JavaScriptNode computedKey = this.transform(property.getKey());
            return this.factory.createComputedDataMember(computedKey, property.isStatic(), enumerable, value, property.isClassField(), property.isAnonymousFunctionDefinition());
        }
        if (!isClass && property.isProto()) {
            return this.factory.createProtoMember(property.getKeyName(), property.isStatic(), value);
        }
        if (property.isPrivate()) {
            Environment.VarRef privateVar = this.environment.findLocalVar(property.getPrivateName());
            if (property.isClassField()) {
                JSWriteFrameSlotNode writePrivateNode = (JSWriteFrameSlotNode)privateVar.createWriteNode(this.factory.createNewPrivateName(property.getPrivateName()));
                return this.factory.createPrivateFieldMember(privateVar.createReadNode(), property.isStatic(), value, writePrivateNode);
            }
            JSWriteFrameSlotNode writePrivateNode = (JSWriteFrameSlotNode)privateVar.createWriteNode(null);
            return this.factory.createPrivateMethodMember(property.isStatic(), value, writePrivateNode);
        }
        if (isClass && property.isClassStaticBlock()) {
            return this.factory.createStaticBlockMember(value);
        }
        assert (property.getKey() != null);
        return this.factory.createDataMember(property.getKeyName(), property.isStatic(), enumerable, value, property.isClassField());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaScriptNode enterTryNode(TryNode tryNode) {
        JavaScriptNode tryBlock;
        JavaScriptNode result = tryBlock = this.transform(tryNode.getBody());
        if (!tryNode.getCatchBlocks().isEmpty()) {
            for (Block catchParamBlock : tryNode.getCatchBlocks()) {
                CatchNode catchClause = (CatchNode)catchParamBlock.getLastStatement();
                Expression catchParameter = catchClause.getException();
                Block catchBody = catchClause.getBody();
                Expression pattern = catchClause.getDestructuringPattern();
                EnvironmentCloseable catchParamEnv = this.enterBlockEnvironment(catchParamBlock);
                Throwable throwable = null;
                try {
                    this.lc.push(catchParamBlock);
                    try {
                        for (Statement statement : catchParamBlock.getStatements().subList(0, catchParamBlock.getStatementCount() - 1)) {
                            assert (statement instanceof VarNode);
                            JavaScriptNode empty = this.transform(statement);
                            assert (empty instanceof EmptyNode);
                        }
                        JavaScriptNode writeErrorVar = null;
                        JavaScriptNode destructuring = null;
                        if (catchParameter != null) {
                            String errorVarName = ((IdentNode)catchParameter).getName();
                            Environment.VarRef errorVar = this.environment.findLocalVar(errorVarName);
                            writeErrorVar = errorVar.createWriteNode(null);
                            if (pattern != null) {
                                destructuring = this.transformAssignment(pattern, pattern, errorVar.createReadNode(), true);
                            }
                        }
                        JavaScriptNode catchBlock = this.transform(catchBody);
                        JavaScriptNode conditionExpression = catchClause.getExceptionCondition() != null ? this.transform(catchClause.getExceptionCondition()) : null;
                        BlockScopeNode blockScope = (BlockScopeNode)catchParamEnv.wrapBlockScope(null);
                        result = this.factory.createTryCatch(this.context, result, catchBlock, writeErrorVar, blockScope, destructuring, conditionExpression);
                        this.ensureHasSourceSection(result, tryNode);
                    }
                    finally {
                        this.lc.pop(catchParamBlock);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (catchParamEnv == null) continue;
                    if (throwable != null) {
                        try {
                            catchParamEnv.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    catchParamEnv.close();
                }
            }
        }
        if (tryNode.getFinallyBody() != null) {
            JavaScriptNode finallyBlock = this.transform(tryNode.getFinallyBody());
            result = this.factory.createTryFinally(result, this.wrapSaveAndRestoreCompletionValue(this.wrapClearCompletionValue(finallyBlock)));
        }
        result = this.wrapClearAndGetCompletionValue(result);
        return result;
    }

    @Override
    public JavaScriptNode enterThrowNode(ThrowNode throwNode) {
        return this.tagStatement(this.factory.createThrow(this.context, this.transform(throwNode.getExpression())), throwNode);
    }

    @Override
    public JavaScriptNode enterSwitchNode(SwitchNode switchNode) {
        JavaScriptNode switchBody;
        Block switchBlock = this.lc.getCurrentBlock();
        assert (switchBlock.isSwitchBlock());
        InternalSlotId switchVarName = this.makeUniqueTempVarNameForStatement("switch", switchNode.getLineNumber());
        this.environment.declareLocalVar(switchVarName);
        JavaScriptNode switchExpression = this.transform(switchNode.getExpression());
        boolean isSwitchTypeofString = GraalJSTranslator.isSwitchTypeofStringConstant(switchNode, switchExpression);
        if (isSwitchTypeofString) {
            switchExpression = ((TypeOfNode)switchExpression).getOperand();
        }
        Environment.VarRef switchVar = this.environment.findInternalSlot(switchVarName);
        JavaScriptNode writeSwitchNode = switchVar.createWriteNode(switchExpression);
        try (FunctionEnvironment.JumpTargetCloseable<BreakTarget> target = this.currentFunction().pushBreakTarget(null);){
            switchBody = JSConfig.OptimizeNoFallthroughSwitch && GraalJSTranslator.isNoFallthroughSwitch(switchNode) ? this.ifElseFromSwitch(switchNode, switchVar, isSwitchTypeofString) : this.defaultSwitchNode(switchNode, switchVar, isSwitchTypeofString);
            this.tagStatement(switchBody, switchNode);
            switchBody = this.wrapClearAndGetCompletionValue(target.wrapBreakTargetNode(switchBody));
        }
        return this.createBlock(writeSwitchNode, switchBody);
    }

    private JavaScriptNode defaultSwitchNode(SwitchNode switchNode, Environment.VarRef switchVar, boolean isSwitchTypeofString) {
        List<CaseNode> cases = switchNode.getCases();
        int size = cases.size() + (switchNode.hasDefaultCase() ? 0 : 1);
        int[] jumptable = new int[size];
        int defaultpos = -1;
        ArrayList<JavaScriptNode> statementList = new ArrayList<JavaScriptNode>();
        ArrayList<JavaScriptNode> caseExprList = new ArrayList<JavaScriptNode>();
        int lastNonEmptyIndex = -1;
        for (CaseNode switchCase : cases) {
            if (switchCase.getTest() != null) {
                jumptable[caseExprList.size()] = statementList.size();
                JavaScriptNode readSwitchVarNode = switchVar.createReadNode();
                caseExprList.add(this.createSwitchCaseExpr(isSwitchTypeofString, switchCase, readSwitchVarNode));
            } else {
                defaultpos = statementList.size();
            }
            if (switchCase.getStatements().isEmpty()) continue;
            List<Statement> statements = switchCase.getStatements();
            for (int i = 0; i < statements.size(); ++i) {
                Statement statement = statements.get(i);
                JavaScriptNode statementNode = this.transform(statement);
                if (this.currentFunction().returnsLastStatementResult()) {
                    if (!statement.isCompletionValueNeverEmpty()) {
                        if (lastNonEmptyIndex >= 0) {
                            statementList.set(lastNonEmptyIndex, this.wrapSetCompletionValue((JavaScriptNode)statementList.get(lastNonEmptyIndex)));
                            lastNonEmptyIndex = -1;
                        }
                    } else {
                        lastNonEmptyIndex = statementList.size();
                    }
                }
                statementList.add(statementNode);
            }
        }
        if (this.currentFunction().returnsLastStatementResult() && lastNonEmptyIndex >= 0) {
            statementList.set(lastNonEmptyIndex, this.wrapSetCompletionValue((JavaScriptNode)statementList.get(lastNonEmptyIndex)));
        }
        jumptable[jumptable.length - 1] = defaultpos != -1 ? defaultpos : statementList.size();
        return this.factory.createSwitch(caseExprList.toArray(EMPTY_NODE_ARRAY), jumptable, statementList.toArray(EMPTY_NODE_ARRAY));
    }

    private JavaScriptNode createSwitchCaseExpr(boolean isSwitchTypeofString, CaseNode switchCase, JavaScriptNode readSwitchVarNode) {
        GraalJSTranslator.tagHiddenExpression(readSwitchVarNode);
        if (isSwitchTypeofString) {
            String typeString = (String)((LiteralNode)switchCase.getTest()).getValue();
            return this.tagExpression(this.factory.createTypeofIdentical(readSwitchVarNode, typeString), switchCase);
        }
        return this.tagExpression(this.factory.createBinary(this.context, NodeFactory.BinaryOperation.IDENTICAL, readSwitchVarNode, this.transform(switchCase.getTest())), switchCase);
    }

    private JavaScriptNode ifElseFromSwitch(SwitchNode switchNode, Environment.VarRef switchVar, boolean isSwitchTypeofString) {
        assert (GraalJSTranslator.isNoFallthroughSwitch(switchNode));
        List<CaseNode> cases = switchNode.getCases();
        CaseNode defaultCase = switchNode.getDefaultCase();
        JavaScriptNode curNode = null;
        if (defaultCase != null) {
            curNode = this.dropTerminalDirectBreakStatement(this.transformStatements(defaultCase.getStatements(), false, false));
            this.ensureHasSourceSection(curNode, defaultCase);
        }
        boolean defaultCascade = false;
        boolean lastCase = true;
        for (int i = cases.size() - 1; i >= 0; --i) {
            CaseNode caseNode = cases.get(i);
            if (caseNode.getTest() == null) {
                defaultCascade = true;
            } else {
                JavaScriptNode readSwitchVarNode = switchVar.createReadNode();
                JavaScriptNode test = this.createSwitchCaseExpr(isSwitchTypeofString, caseNode, readSwitchVarNode);
                if (caseNode.getStatements().isEmpty() && !lastCase) {
                    if (defaultCascade) {
                        if (GraalJSTranslator.isPotentiallySideEffecting(test)) {
                            test = this.factory.createIf(test, null, null);
                            this.ensureHasSourceSection(test, caseNode);
                            curNode = curNode == null ? this.discardResult(test) : this.createBlock(test, curNode);
                        }
                    } else {
                        assert (curNode instanceof IfNode);
                        IfNode prevIfNode = (IfNode)curNode;
                        curNode = this.factory.copyIfWithCondition(prevIfNode, this.factory.createLogicalOr(test, prevIfNode.getCondition()));
                    }
                } else {
                    JavaScriptNode pass = this.dropTerminalDirectBreakStatement(this.transformStatements(caseNode.getStatements(), false, false));
                    this.ensureHasSourceSection(pass, caseNode);
                    curNode = this.factory.createIf(test, pass, curNode);
                    defaultCascade = false;
                }
                this.ensureHasSourceSection(curNode, caseNode.getTest());
            }
            lastCase = false;
        }
        return curNode == null ? this.factory.createEmpty() : curNode;
    }

    static boolean isPotentiallySideEffecting(JavaScriptNode test) {
        if (test instanceof JSReadFrameSlotNode) {
            return ((JSReadFrameSlotNode)test).hasTemporalDeadZone();
        }
        return !(test instanceof RepeatableNode);
    }

    private JavaScriptNode dropTerminalDirectBreakStatement(JavaScriptNode pass) {
        JavaScriptNode[] statements;
        if (pass instanceof SequenceNode && (statements = ((SequenceNode)((Object)pass)).getStatements()).length > 0 && GraalJSTranslator.isDirectBreakStatement(statements[statements.length - 1])) {
            return this.createBlock(Arrays.copyOfRange(statements, 0, statements.length - 1));
        }
        return pass;
    }

    private static boolean isDirectBreakStatement(JavaScriptNode statement) {
        return statement instanceof com.oracle.truffle.js.nodes.control.BreakNode && ((com.oracle.truffle.js.nodes.control.BreakNode)statement).isDirectBreak();
    }

    private static boolean isNoFallthroughSwitch(SwitchNode switchNode) {
        List<CaseNode> cases = switchNode.getCases();
        for (int i = 0; i < cases.size() - 1; ++i) {
            Statement lastStatement;
            CaseNode caseNode = cases.get(i);
            List<Statement> statements = caseNode.getStatements();
            if (!(statements.isEmpty() ? caseNode.getTest() == null : !(lastStatement = statements.get(statements.size() - 1)).hasTerminalFlags())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSwitchTypeofStringConstant(SwitchNode switchNode, JavaScriptNode switchExpression) {
        if (!(switchExpression instanceof TypeOfNode)) {
            return false;
        }
        for (CaseNode switchCase : switchNode.getCases()) {
            Expression test = switchCase.getTest();
            if (test == null || test instanceof LiteralNode && ((LiteralNode)test).getValue() instanceof String) continue;
            return false;
        }
        return true;
    }

    private JavaScriptNode discardResult(JavaScriptNode test) {
        if (this.currentFunction().returnsLastStatementResult()) {
            return this.factory.createVoidBlock(test);
        }
        return test;
    }

    @Override
    public JavaScriptNode enterEmptyNode(com.oracle.js.parser.ir.EmptyNode emptyNode) {
        return this.factory.createEmpty();
    }

    @Override
    public JavaScriptNode enterWithNode(WithNode withNode) {
        if (this.context.isOptionDisableWith()) {
            throw Errors.createSyntaxError("with statement is disabled.");
        }
        FunctionNode function = this.lc.getCurrentFunction();
        Environment withParentEnv = function.hasClosures() || function.hasEval() ? new BlockEnvironment(this.environment, this.factory, this.context) : this.environment;
        try (EnvironmentCloseable withParent = new EnvironmentCloseable(withParentEnv);){
            JavaScriptNode withStatement;
            JavaScriptNode withExpression = this.transform(withNode.getExpression());
            JavaScriptNode toObject = this.factory.createToObjectFromWith(this.context, withExpression, true);
            InternalSlotId withVarName = this.makeUniqueTempVarNameForStatement("with", withNode.getLineNumber());
            this.environment.declareInternalSlot(withVarName);
            JavaScriptNode writeWith = this.environment.findInternalSlot(withVarName).createWriteNode(toObject);
            try (EnvironmentCloseable withEnv = this.enterWithEnvironment(withVarName);){
                JavaScriptNode withBody = this.transform(withNode.getBody());
                withStatement = this.tagStatement(this.factory.createWith(writeWith, this.wrapClearAndGetCompletionValue(withBody)), withNode);
            }
            JavaScriptNode javaScriptNode = withParent.wrapBlockScope(withStatement);
            return javaScriptNode;
        }
    }

    private EnvironmentCloseable enterWithEnvironment(Object withVarName) {
        return new EnvironmentCloseable(new WithEnvironment(this.environment, this.factory, this.context, withVarName));
    }

    @Override
    public JavaScriptNode enterTemplateLiteralNode(TemplateLiteralNode templateLiteralNode) {
        JavaScriptNode result = null;
        if (templateLiteralNode instanceof TemplateLiteralNode.TaggedTemplateLiteralNode) {
            TemplateLiteralNode.TaggedTemplateLiteralNode tagged = (TemplateLiteralNode.TaggedTemplateLiteralNode)templateLiteralNode;
            result = this.factory.createTemplateObject(this.context, this.createArrayLiteral(tagged.getRawStrings()), this.createArrayLiteral(tagged.getCookedStrings()));
        } else {
            List<Expression> expressions = ((TemplateLiteralNode.UntaggedTemplateLiteralNode)templateLiteralNode).getExpressions();
            for (int i = 0; i < expressions.size(); ++i) {
                JavaScriptNode expr = this.transform(expressions.get(i));
                assert (i % 2 != 0 || expr instanceof JSConstantNode) : expr;
                if (i % 2 != 0) {
                    expr = this.factory.createToString(expr);
                }
                result = result == null ? expr : this.factory.createBinary(this.context, NodeFactory.BinaryOperation.ADD, result, expr);
            }
        }
        return this.tagExpression(result, templateLiteralNode);
    }

    @Override
    public JavaScriptNode enterDebuggerNode(DebuggerNode debuggerNode) {
        return this.tagStatement(this.factory.createDebugger(), debuggerNode);
    }

    protected static String error(String message, long errorToken, LexicalContext lc) {
        int position = Token.descPosition(errorToken);
        com.oracle.js.parser.Source internalSource = lc.getCurrentFunction().getSource();
        int lineNum = internalSource.getLine(position);
        int columnNum = internalSource.getColumn(position);
        String formatted = ErrorManager.format(message, internalSource, lineNum, columnNum, errorToken);
        return formatted.replace("\r\n", "\n");
    }

    @Override
    public JavaScriptNode enterExpressionStatement(ExpressionStatement expressionStatement) {
        JavaScriptNode expression = this.transform(expressionStatement.getExpression());
        return this.tagStatement(expression, expressionStatement);
    }

    @Override
    public JavaScriptNode enterJoinPredecessorExpression(JoinPredecessorExpression expr) {
        return this.tagExpression(this.transform(expr.getExpression()), expr);
    }

    @Override
    public JavaScriptNode enterClassNode(ClassNode classNode) {
        Scope classScope = classNode.getScope();
        try (EnvironmentCloseable blockEnv = this.enterBlockEnvironment(classScope);){
            String className = null;
            Symbol classNameSymbol = null;
            if (classNode.getIdent() != null) {
                className = classNode.getIdent().getName();
                classNameSymbol = classScope.getExistingSymbol(className);
            }
            JavaScriptNode classHeritage = this.transform(classNode.getClassHeritage());
            JavaScriptNode classFunction = this.transform(classNode.getConstructor().getValue());
            ArrayList<ObjectLiteralNode.ObjectLiteralMemberNode> members = this.transformPropertyDefinitionList(classNode.getClassElements(), true, classNameSymbol);
            JSWriteFrameSlotNode writeClassBinding = className == null ? null : (JSWriteFrameSlotNode)this.findScopeVar(className, true).createWriteNode(null);
            JavaScriptNode classDefinition = this.factory.createClassDefinition(this.context, (JSFunctionExpressionNode)classFunction, classHeritage, members.toArray(ObjectLiteralNode.ObjectLiteralMemberNode.EMPTY), writeClassBinding, className, classNode.getInstanceFieldCount(), classNode.getStaticElementCount(), classNode.hasPrivateInstanceMethods(), this.currentFunction().getBlockScopeSlot());
            if (classNode.hasPrivateMethods()) {
                classDefinition = this.environment.findLocalVar("#constructor").createWriteNode(classDefinition);
            }
            JavaScriptNode javaScriptNode = this.tagExpression(blockEnv.wrapBlockScope(classDefinition), classNode);
            return javaScriptNode;
        }
    }

    @Override
    public JavaScriptNode enterBlockExpression(BlockExpression blockExpression) {
        return this.tagExpression(this.transform(blockExpression.getBlock()), blockExpression);
    }

    @Override
    public JavaScriptNode enterParameterNode(ParameterNode paramNode) {
        FunctionEnvironment currentFunction = this.currentFunction();
        JavaScriptNode valueNode = paramNode.isRestParameter() ? this.factory.createAccessRestArgument(this.context, currentFunction.getLeadingArgumentCount() + paramNode.getIndex(), currentFunction.getTrailingArgumentCount()) : this.factory.createAccessArgument(currentFunction.getLeadingArgumentCount() + paramNode.getIndex());
        return this.tagExpression(GraalJSTranslator.tagHiddenExpression(valueNode), paramNode);
    }

    @Override
    protected JavaScriptNode enterDefault(Node node) {
        throw GraalJSTranslator.shouldNotReachHere(node);
    }

    private static AssertionError shouldNotReachHere(Node node) {
        throw new AssertionError((Object)String.format("should not reach here. %s(%s)", node.getClass().getSimpleName(), node));
    }

    private SourceSection createSourceSection(FunctionNode functionNode) {
        int start = functionNode.getStartWithoutParens() - this.prologLength;
        int finish = functionNode.getFinishWithoutParens() - this.prologLength;
        int length = this.sourceLength;
        if (finish <= 0 || length <= start) {
            return this.source.createUnavailableSection();
        }
        start = Math.max(0, start);
        finish = Math.min(length, finish);
        return this.source.createSection(start, finish - start);
    }

    private JavaScriptNode ensureHasSourceSection(JavaScriptNode resultNode, Node parseNode) {
        if (!resultNode.hasSourceSection()) {
            this.assignSourceSection(resultNode, parseNode);
            if (resultNode instanceof VarWrapperNode) {
                this.ensureHasSourceSection(((VarWrapperNode)resultNode).getDelegateNode(), parseNode);
            }
        }
        return resultNode;
    }

    private void assignSourceSection(JavaScriptNode resultNode, Node parseNode) {
        int start = parseNode.getStart() - this.prologLength;
        int finish = parseNode.getFinish() - this.prologLength;
        int length = this.sourceLength;
        if (finish <= 0 || length <= start) {
            resultNode.setSourceSection(this.source.createUnavailableSection());
        } else {
            start = Math.max(0, start);
            finish = Math.min(length, finish);
            resultNode.setSourceSection(this.source, start, finish - start);
        }
    }

    private InternalSlotId makeUniqueTempVarNameForStatement(String prefix, int lineNumber) {
        InternalSlotId name = this.factory.createInternalSlotId(prefix, lineNumber);
        assert (!this.environment.hasLocalVar(name));
        return name;
    }

    private final class EnvironmentCloseable
    implements AutoCloseable {
        private final Environment prevEnv;
        private final Environment newEnv;
        private int wrappedInBlockScopeNode;

        EnvironmentCloseable(Environment newEnv) {
            this.prevEnv = GraalJSTranslator.this.environment;
            this.newEnv = newEnv;
            GraalJSTranslator.this.environment = newEnv;
        }

        public JavaScriptNode wrapBlockScope(JavaScriptNode block) {
            if (this.prevEnv != this.newEnv) {
                ++this.wrappedInBlockScopeNode;
                if (this.newEnv instanceof BlockEnvironment) {
                    BlockEnvironment blockEnv = (BlockEnvironment)this.newEnv;
                    boolean captureFunctionFrame = blockEnv.getParent() == blockEnv.function() && blockEnv.function().isGeneratorFunction();
                    return GraalJSTranslator.this.factory.createBlockScope(block, blockEnv.function().getBlockScopeSlot(), blockEnv.getBlockFrameDescriptor(), blockEnv.getParentSlot(), blockEnv.isFunctionBlock(), captureFunctionFrame);
                }
            }
            return block;
        }

        @Override
        public void close() {
            assert (GraalJSTranslator.this.environment == this.newEnv);
            assert (this.newEnv == this.prevEnv || !(this.newEnv instanceof BlockEnvironment) || this.wrappedInBlockScopeNode == 1);
            GraalJSTranslator.this.environment = this.prevEnv;
        }
    }
}

