/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.interop.InteropFunction;

@GeneratedBy(value=ImportValueNode.class)
public final class ImportValueNodeGen
extends ImportValueNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private ImportValueNodeGen() {
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        TruffleObject arg0Value_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return ImportValueNode.fromInt(arg0Value_2);
        }
        if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70000) >>> 16, arg0Value)) {
            String arg0Value_3 = JSTypesGen.asImplicitString((state_0 & 0x70000) >>> 16, arg0Value);
            return ImportValueNode.fromString(arg0Value_3);
        }
        if ((state_0 & 4) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_4 = (Boolean)arg0Value;
            return ImportValueNode.fromBoolean(arg0Value_4);
        }
        if ((state_0 & 8) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_5 = (BigInt)arg0Value;
            return ImportValueNode.fromBigInt(arg0Value_5);
        }
        if ((state_0 & 0x30) != 0 && arg0Value instanceof Long) {
            long arg0Value_6 = (Long)arg0Value;
            if ((state_0 & 0x10) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_6)) {
                return ImportValueNode.fromLongToInt(arg0Value_6);
            }
            if ((state_0 & 0x20) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_6)) {
                return ImportValueNode.fromLong(arg0Value_6);
            }
        }
        if ((state_0 & 0x40) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x780000) >>> 19, arg0Value)) {
            double arg0Value_7 = JSTypesGen.asImplicitDouble((state_0 & 0x780000) >>> 19, arg0Value);
            return ImportValueNode.fromDouble(arg0Value_7);
        }
        if ((state_0 & 0x80) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_8 = (Byte)arg0Value;
            return ImportValueNode.fromNumber(arg0Value_8);
        }
        if ((state_0 & 0x100) != 0 && arg0Value instanceof Short) {
            short arg0Value_9 = (Short)arg0Value;
            return ImportValueNode.fromNumber(arg0Value_9);
        }
        if ((state_0 & 0x200) != 0 && arg0Value instanceof Float) {
            float arg0Value_10 = ((Float)arg0Value).floatValue();
            return ImportValueNode.fromNumber(arg0Value_10);
        }
        if ((state_0 & 0x400) != 0 && arg0Value instanceof Character) {
            char arg0Value_11 = ((Character)arg0Value).charValue();
            return ImportValueNode.fromChar(arg0Value_11);
        }
        if ((state_0 & 0x800) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_12 = (DynamicObject)arg0Value;
            return ImportValueNode.fromDynamicObject(arg0Value_12);
        }
        if ((state_0 & 0x1000) != 0 && arg0Value instanceof InteropFunction) {
            InteropFunction arg0Value_13 = (InteropFunction)arg0Value;
            return ImportValueNode.fromInteropFunction(arg0Value_13);
        }
        if ((state_0 & 0x2000) != 0 && arg0Value instanceof GraalJSException) {
            GraalJSException arg0Value_14 = (GraalJSException)arg0Value;
            return ImportValueNode.fromJSException(arg0Value_14);
        }
        if ((state_0 & 0x4000) != 0 && arg0Value instanceof TruffleObject && !ImportValueNode.isSpecial(arg0Value_ = (TruffleObject)arg0Value)) {
            return ImportValueNode.fromTruffleObject(arg0Value_);
        }
        if ((state_0 & 0x8000) != 0 && ImportValueNodeGen.fallbackGuard_(state_0, arg0Value)) {
            return ImportValueNode.fallbackCase(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        TruffleObject truffleObject;
        int n;
        int state_0 = this.state_0_;
        if (arg0Value instanceof Integer) {
            int n2 = (Integer)arg0Value;
            this.state_0_ = state_0 |= 1;
            return ImportValueNode.fromInt(n2);
        }
        int n3 = JSTypesGen.specializeImplicitString(arg0Value);
        if (n3 != 0) {
            String arg0Value_4 = JSTypesGen.asImplicitString(n3, arg0Value);
            state_0 |= n3 << 16;
            this.state_0_ = state_0 |= 2;
            return ImportValueNode.fromString(arg0Value_4);
        }
        if (arg0Value instanceof Boolean) {
            boolean bl = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 4;
            return ImportValueNode.fromBoolean(bl);
        }
        if (arg0Value instanceof BigInt) {
            BigInt bigInt = (BigInt)arg0Value;
            this.state_0_ = state_0 |= 8;
            return ImportValueNode.fromBigInt(bigInt);
        }
        if (arg0Value instanceof Long) {
            long l = (Long)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(l)) {
                this.state_0_ = state_0 |= 0x10;
                return ImportValueNode.fromLongToInt(l);
            }
            if (!JSGuards.isLongRepresentableAsInt32(l)) {
                this.state_0_ = state_0 |= 0x20;
                return ImportValueNode.fromLong(l);
            }
        }
        if ((n = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
            double arg0Value_8 = JSTypesGen.asImplicitDouble(n, arg0Value);
            state_0 |= n << 19;
            this.state_0_ = state_0 |= 0x40;
            return ImportValueNode.fromDouble(arg0Value_8);
        }
        if (arg0Value instanceof Byte) {
            byte by = (Byte)arg0Value;
            this.state_0_ = state_0 |= 0x80;
            return ImportValueNode.fromNumber(by);
        }
        if (arg0Value instanceof Short) {
            short s = (Short)arg0Value;
            this.state_0_ = state_0 |= 0x100;
            return ImportValueNode.fromNumber(s);
        }
        if (arg0Value instanceof Float) {
            float f = ((Float)arg0Value).floatValue();
            this.state_0_ = state_0 |= 0x200;
            return ImportValueNode.fromNumber(f);
        }
        if (arg0Value instanceof Character) {
            char c = ((Character)arg0Value).charValue();
            this.state_0_ = state_0 |= 0x400;
            return ImportValueNode.fromChar(c);
        }
        if (JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject dynamicObject = (DynamicObject)arg0Value;
            this.state_0_ = state_0 |= 0x800;
            return ImportValueNode.fromDynamicObject(dynamicObject);
        }
        if (arg0Value instanceof InteropFunction) {
            InteropFunction interopFunction = (InteropFunction)arg0Value;
            this.state_0_ = state_0 |= 0x1000;
            return ImportValueNode.fromInteropFunction(interopFunction);
        }
        if (arg0Value instanceof GraalJSException) {
            GraalJSException graalJSException = (GraalJSException)arg0Value;
            this.state_0_ = state_0 |= 0x2000;
            return ImportValueNode.fromJSException(graalJSException);
        }
        if (arg0Value instanceof TruffleObject && !ImportValueNode.isSpecial(truffleObject = (TruffleObject)arg0Value)) {
            this.state_0_ = state_0 |= 0x4000;
            return ImportValueNode.fromTruffleObject(truffleObject);
        }
        this.state_0_ = state_0 |= 0x8000;
        return ImportValueNode.fallbackCase(arg0Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0xFFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0xFFFF & (state_0 & 0xFFFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[17];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "fromInt";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "fromString";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "fromBoolean";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "fromBigInt";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "fromLongToInt";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "fromLong";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "fromDouble";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "fromChar";
        s[1] = (state_0 & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "fromDynamicObject";
        s[1] = (state_0 & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "fromInteropFunction";
        s[1] = (state_0 & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "fromJSException";
        s[1] = (state_0 & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        s = new Object[3];
        s[0] = "fromTruffleObject";
        s[1] = (state_0 & 0x4000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        s = new Object[3];
        s[0] = "fallbackCase";
        s[1] = (state_0 & 0x8000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[16] = s;
        return Introspection.Provider.create(data);
    }

    private static boolean fallbackGuard_(int state_0, Object arg0Value) {
        TruffleObject arg0Value_;
        if (JSTypesGen.isImplicitString(arg0Value)) {
            return false;
        }
        if ((state_0 & 4) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state_0 & 8) == 0 && arg0Value instanceof BigInt) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x80) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state_0 & 0x100) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state_0 & 0x200) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state_0 & 0x400) == 0 && arg0Value instanceof Character) {
            return false;
        }
        if ((state_0 & 0x800) == 0 && JSTypes.isDynamicObject(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x1000) == 0 && arg0Value instanceof InteropFunction) {
            return false;
        }
        if ((state_0 & 0x2000) == 0 && arg0Value instanceof GraalJSException) {
            return false;
        }
        return !(arg0Value instanceof TruffleObject) || ImportValueNode.isSpecial(arg0Value_ = (TruffleObject)arg0Value);
    }

    public static ImportValueNode create() {
        return new ImportValueNodeGen();
    }

    public static ImportValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ImportValueNode.class)
    private static final class Uncached
    extends ImportValueNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object executeWithTarget(Object arg0Value) {
            TruffleObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                return ImportValueNode.fromInt(arg0Value_2);
            }
            if (JSTypesGen.isImplicitString(arg0Value)) {
                String arg0Value_3 = JSTypesGen.asImplicitString(arg0Value);
                return ImportValueNode.fromString(arg0Value_3);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_4 = (Boolean)arg0Value;
                return ImportValueNode.fromBoolean(arg0Value_4);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_5 = (BigInt)arg0Value;
                return ImportValueNode.fromBigInt(arg0Value_5);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_6 = (Long)arg0Value;
                if (JSGuards.isLongRepresentableAsInt32(arg0Value_6)) {
                    return ImportValueNode.fromLongToInt(arg0Value_6);
                }
                if (!JSGuards.isLongRepresentableAsInt32(arg0Value_6)) {
                    return ImportValueNode.fromLong(arg0Value_6);
                }
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_7 = JSTypesGen.asImplicitDouble(arg0Value);
                return ImportValueNode.fromDouble(arg0Value_7);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_8 = (Byte)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_8);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_9 = (Short)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_9);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_10 = ((Float)arg0Value).floatValue();
                return ImportValueNode.fromNumber(arg0Value_10);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_11 = ((Character)arg0Value).charValue();
                return ImportValueNode.fromChar(arg0Value_11);
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_12 = (DynamicObject)arg0Value;
                return ImportValueNode.fromDynamicObject(arg0Value_12);
            }
            if (arg0Value instanceof InteropFunction) {
                InteropFunction arg0Value_13 = (InteropFunction)arg0Value;
                return ImportValueNode.fromInteropFunction(arg0Value_13);
            }
            if (arg0Value instanceof GraalJSException) {
                GraalJSException arg0Value_14 = (GraalJSException)arg0Value;
                return ImportValueNode.fromJSException(arg0Value_14);
            }
            if (arg0Value instanceof TruffleObject && !ImportValueNode.isSpecial(arg0Value_ = (TruffleObject)arg0Value)) {
                return ImportValueNode.fromTruffleObject(arg0Value_);
            }
            return ImportValueNode.fallbackCase(arg0Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }
}

