/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.InitErrorObjectNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanUnaryNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@NodeInfo(shortName="try-catch")
public class TryCatchNode
extends StatementNode
implements ResumableNode {
    @Node.Child
    private JavaScriptNode tryBlock;
    @Node.Child
    private JavaScriptNode catchBlock;
    @Node.Child
    private JSWriteFrameSlotNode writeErrorVar;
    @Node.Child
    private BlockScopeNode blockScope;
    @Node.Child
    private JavaScriptNode destructuring;
    @Node.Child
    private JavaScriptNode conditionExpression;
    @Node.Child
    private GetErrorObjectNode getErrorObjectNode;
    @Node.Child
    private InteropLibrary exceptions;
    private final JSContext context;

    protected TryCatchNode(JSContext context, JavaScriptNode tryBlock, JavaScriptNode catchBlock, JSWriteFrameSlotNode writeErrorVar, BlockScopeNode blockScope, JavaScriptNode destructuring, JavaScriptNode conditionExpression) {
        this.context = context;
        this.tryBlock = tryBlock;
        this.writeErrorVar = writeErrorVar;
        this.catchBlock = catchBlock;
        this.blockScope = blockScope;
        this.destructuring = destructuring;
        JavaScriptNode javaScriptNode = this.conditionExpression = conditionExpression == null ? null : JSToBooleanUnaryNode.create(conditionExpression);
        assert (blockScope != null || writeErrorVar == null);
    }

    public static TryCatchNode create(JSContext context, JavaScriptNode tryBlock, JavaScriptNode catchBlock, JSWriteFrameSlotNode writeErrorVar, BlockScopeNode blockScope, JavaScriptNode destructuring, JavaScriptNode conditionExpression) {
        return new TryCatchNode(context, tryBlock, catchBlock, writeErrorVar, blockScope, destructuring, conditionExpression);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ControlFlowRootTag.class || tag == StandardTags.TryBlockTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("type", JSTags.ControlFlowRootTag.Type.ExceptionHandler.name());
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return TryCatchNode.create(this.context, TryCatchNode.cloneUninitialized(this.tryBlock, materializedTags), TryCatchNode.cloneUninitialized(this.catchBlock, materializedTags), TryCatchNode.cloneUninitialized(this.writeErrorVar, materializedTags), TryCatchNode.cloneUninitialized(this.blockScope, materializedTags), TryCatchNode.cloneUninitialized(this.destructuring, materializedTags), TryCatchNode.cloneUninitialized(this.conditionExpression, materializedTags));
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.tryBlock.isResultAlwaysOfType(clazz) && this.catchBlock.isResultAlwaysOfType(clazz);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        try {
            return this.tryBlock.execute(frame);
        }
        catch (ControlFlowException cfe) {
            throw cfe;
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                return this.executeCatch(frame, ex);
            }
            throw ex;
        }
    }

    @Override
    public final void executeVoid(VirtualFrame frame) {
        try {
            this.tryBlock.executeVoid(frame);
        }
        catch (ControlFlowException cfe) {
            throw cfe;
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                this.executeCatch(frame, ex);
            }
            throw ex;
        }
    }

    public static boolean shouldCatch(Throwable ex, InteropLibrary exceptions) {
        if (exceptions.isException(ex)) {
            try {
                ExceptionType exceptionType = exceptions.getExceptionType(ex);
                return exceptionType != ExceptionType.EXIT && exceptionType != ExceptionType.INTERRUPT;
            }
            catch (UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(ex, e, "getExceptionType", null);
            }
        }
        return ex instanceof StackOverflowError;
    }

    public static boolean shouldCatch(Throwable ex) {
        return TryCatchNode.shouldCatch(ex, InteropLibrary.getUncached());
    }

    private Object executeCatch(VirtualFrame frame, Throwable ex) {
        if (this.blockScope != null) {
            this.blockScope.appendScopeFrame(frame);
        }
        try {
            if (this.prepareCatch(frame, ex)) {
                Object object = this.catchBlock.execute(frame);
                return object;
            }
            throw JSRuntime.rethrow(ex);
        }
        finally {
            if (this.blockScope != null) {
                this.blockScope.exitScope(frame);
            }
        }
    }

    private boolean prepareCatch(VirtualFrame frame, Throwable ex) {
        if (this.writeErrorVar != null) {
            if (this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = this.insert(GetErrorObjectNode.create(this.context));
            }
            Object exceptionObject = this.getErrorObjectNode.execute(ex);
            this.writeErrorVar.executeWrite(frame, exceptionObject);
            if (this.destructuring != null) {
                this.destructuring.execute(frame);
            }
        }
        return this.conditionExpression == null || TryCatchNode.executeConditionAsBoolean(frame, this.conditionExpression);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        block14: {
            Object state = this.getStateAndReset(frame);
            if (state == Undefined.instance) {
                try {
                    return this.tryBlock.execute(frame);
                }
                catch (ControlFlowException cfe) {
                    throw cfe;
                }
                catch (Throwable ex) {
                    if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                        if (this.blockScope != null) {
                            this.blockScope.appendScopeFrame(frame);
                        }
                        if (!this.prepareCatch(frame, ex)) {
                            throw JSRuntime.rethrow(ex);
                        }
                        break block14;
                    }
                    throw ex;
                }
            }
            if (this.blockScope != null) {
                this.blockScope.setBlockScope(frame, state);
            }
        }
        try {
            Object ex = this.catchBlock.execute(frame);
            return ex;
        }
        catch (YieldException e) {
            this.setState(frame, this.blockScope == null ? Integer.valueOf(1) : this.blockScope.getBlockScope(frame));
            throw e;
        }
        finally {
            if (this.blockScope != null) {
                this.blockScope.exitScope(frame);
            }
        }
    }

    private InteropLibrary exceptions() {
        InteropLibrary e = this.exceptions;
        if (e == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptions = e = this.insert(InteropLibrary.getFactory().createDispatched(5));
        }
        return e;
    }

    public static final class GetErrorObjectNode
    extends JavaScriptBaseNode {
        @Node.Child
        private InitErrorObjectNode initErrorObjectNode;
        private final ConditionProfile isJSError = ConditionProfile.createBinaryProfile();
        private final ConditionProfile isJSException = ConditionProfile.createBinaryProfile();
        private final BranchProfile truffleExceptionBranch = BranchProfile.create();
        private final BranchProfile legacyTruffleExceptionBranch = BranchProfile.create();
        private final JSContext context;

        private GetErrorObjectNode(JSContext context) {
            this.context = context;
            this.initErrorObjectNode = InitErrorObjectNode.create(context, context.isOptionNashornCompatibilityMode());
        }

        public static GetErrorObjectNode create(JSContext context) {
            return new GetErrorObjectNode(context);
        }

        public Object execute(Throwable ex) {
            if (this.isJSError.profile(ex instanceof JSException)) {
                TruffleStackTrace.fillIn(ex);
                return this.doJSException((JSException)ex);
            }
            if (this.isJSException.profile(ex instanceof UserScriptException)) {
                return ((UserScriptException)ex).getErrorObject();
            }
            if (ex instanceof StackOverflowError) {
                CompilerDirectives.transferToInterpreter();
                JSException rangeException = Errors.createRangeErrorStackOverflow(ex, this);
                return this.doJSException(rangeException);
            }
            this.truffleExceptionBranch.enter();
            assert (!(ex instanceof GraalJSException) && (ex instanceof AbstractTruffleException || ex instanceof TruffleException)) : ex;
            if (ex instanceof AbstractTruffleException) {
                return ex;
            }
            this.legacyTruffleExceptionBranch.enter();
            Object exceptionObject = ((TruffleException)((Object)ex)).getExceptionObject();
            if (exceptionObject != null) {
                return exceptionObject;
            }
            return Errors.createErrorFromException(ex);
        }

        private Object doJSException(JSException exception) {
            DynamicObject errorObj = exception.getErrorObject();
            if (errorObj == null) {
                JSRealm realm = exception.getRealm();
                if (realm == null) {
                    realm = this.getRealm();
                }
                String message = exception.getRawMessage();
                assert (message != null);
                errorObj = GetErrorObjectNode.createErrorFromJSException(this.context, realm, exception.getErrorType());
                this.initErrorObjectNode.execute(errorObj, exception, message);
                exception.setErrorObject(errorObj);
            }
            return errorObj;
        }

        @CompilerDirectives.TruffleBoundary
        private static DynamicObject createErrorFromJSException(JSContext context, JSRealm realm, JSErrorType errorType) {
            return JSError.createErrorObject(context, realm, errorType);
        }
    }
}

