/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.IntlBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import java.util.Arrays;

public final class IntlBuiltins
extends JSBuiltinsContainer.SwitchEnum<Intl> {
    public static final JSBuiltinsContainer BUILTINS = new IntlBuiltins();

    protected IntlBuiltins() {
        super("Intl", Intl.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, Intl builtinEnum) {
        switch (builtinEnum) {
            case getCanonicalLocales: {
                return IntlBuiltinsFactory.GetCanonicalLocalesNodeGen.create(context, builtin, IntlBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class GetCanonicalLocalesNode
    extends JSBuiltinNode {
        @Node.Child
        JSToCanonicalizedLocaleListNode canonicalizeLocaleListNode;

        public GetCanonicalLocalesNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object getCanonicalLocales(Object locales) {
            if (this.canonicalizeLocaleListNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.canonicalizeLocaleListNode = this.insert(JSToCanonicalizedLocaleListNode.create(this.getContext()));
            }
            String[] languageTags = this.canonicalizeLocaleListNode.executeLanguageTags(locales);
            return JSRuntime.createArrayFromList(this.getContext(), this.getRealm(), Arrays.asList((Object[])languageTags));
        }
    }

    public static enum Intl implements BuiltinEnum<Intl>
    {
        getCanonicalLocales(1);

        private final int length;

        private Intl(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

