/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.ProxyFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class ProxyFunctionBuiltins
extends JSBuiltinsContainer.Lambda {
    public static final JSBuiltinsContainer BUILTINS = new ProxyFunctionBuiltins();

    protected ProxyFunctionBuiltins() {
        super("Proxy");
        this.defineFunction("revocable", 2, (context, builtin) -> ProxyFunctionBuiltinsFactory.RevocableNodeGen.create(context, builtin, ProxyFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context)));
    }

    public static abstract class RevocableNode
    extends JSBuiltinNode {
        @Node.Child
        private ConstructorBuiltins.ConstructJSProxyNode proxyCreateNode;
        @Node.Child
        private PropertySetNode setRevocableProxySlotNode;
        @Node.Child
        private CreateObjectNode createObjectNode;
        @Node.Child
        private CreateDataPropertyNode createProxyPropertyNode;
        @Node.Child
        private CreateDataPropertyNode createRevokePropertyNode;

        public RevocableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.proxyCreateNode = ConstructorBuiltinsFactory.ConstructJSProxyNodeGen.create(context, builtin, false, null);
            this.setRevocableProxySlotNode = PropertySetNode.createSetHidden(JSProxy.REVOCABLE_PROXY, context);
            this.createObjectNode = CreateObjectNode.create(context);
            this.createProxyPropertyNode = CreateDataPropertyNode.create(context, "proxy");
            this.createRevokePropertyNode = CreateDataPropertyNode.create(context, "revoke");
        }

        @Specialization
        protected Object doDefault(VirtualFrame frame, Object target, Object handler) {
            DynamicObject proxy = this.proxyCreateNode.execute(Undefined.instance, target, handler);
            JSFunctionData revokerFunctionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ProxyRevokerFunction, c -> RevocableNode.createProxyRevokerFunctionImpl(c));
            DynamicObject revoker = JSFunction.create(this.getRealm(), revokerFunctionData);
            this.setRevocableProxySlotNode.setValue(revoker, proxy);
            DynamicObject result = this.createObjectNode.execute(frame);
            this.createProxyPropertyNode.executeVoid(result, proxy);
            this.createRevokePropertyNode.executeVoid(result, revoker);
            return result;
        }

        private static JSFunctionData createProxyRevokerFunctionImpl(final JSContext context) {
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(new JavaScriptRootNode(){
                @Node.Child
                private PropertyGetNode getRevocableProxyNode;
                @Node.Child
                private PropertySetNode setRevocableProxyNode;
                @Node.Child
                private PropertySetNode setRevokedCallableProxyNode;
                @Node.Child
                private IsCallableNode isCallableNode;
                {
                    this.getRevocableProxyNode = PropertyGetNode.createGetHidden(JSProxy.REVOCABLE_PROXY, context);
                    this.setRevocableProxyNode = PropertySetNode.createSetHidden(JSProxy.REVOCABLE_PROXY, context);
                    this.setRevokedCallableProxyNode = PropertySetNode.createSetHidden(JSProxy.REVOKED_CALLABLE, context);
                    this.isCallableNode = IsCallableNode.create();
                }

                @Override
                public Object execute(VirtualFrame frame) {
                    JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                    DynamicObject proxy = (DynamicObject)this.getRevocableProxyNode.getValue(functionObject);
                    if (proxy == Null.instance) {
                        return Undefined.instance;
                    }
                    this.setRevocableProxyNode.setValue(functionObject, Null.instance);
                    boolean callable = this.isCallableNode.executeBoolean(proxy);
                    JSProxy.revoke(proxy);
                    this.setRevokedCallableProxyNode.setValueBoolean(proxy, callable);
                    return Undefined.instance;
                }
            });
            return JSFunctionData.createCallOnly(context, callTarget, 0, "");
        }
    }
}

