/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.variable.serializer;

import org.cibseven.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.cibseven.bpm.engine.impl.variable.serializer.ValueFields;
import org.cibseven.bpm.engine.variable.Variables;
import org.cibseven.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.cibseven.bpm.engine.variable.type.ValueType;
import org.cibseven.bpm.engine.variable.value.ShortValue;

public class ShortValueSerializer
extends PrimitiveValueSerializer<ShortValue> {
    public ShortValueSerializer() {
        super(ValueType.SHORT);
    }

    @Override
    public ShortValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.shortValue((Short)((Short)untypedValue.getValue()), (boolean)untypedValue.isTransient());
    }

    @Override
    public ShortValue readValue(ValueFields valueFields, boolean asTransientValue) {
        Long longValue = valueFields.getLongValue();
        Short shortValue = null;
        if (longValue != null) {
            shortValue = longValue.shortValue();
        }
        return Variables.shortValue(shortValue, (boolean)asTransientValue);
    }

    @Override
    public void writeValue(ShortValue value, ValueFields valueFields) {
        Short shortValue = (Short)value.getValue();
        if (shortValue != null) {
            valueFields.setLongValue(shortValue.longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }
}

