/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionObserver;
import org.cibseven.bpm.engine.variable.VariableMap;

public class ExecutionVariableSnapshotObserver
implements ExecutionObserver {
    protected VariableMap variableSnapshot;
    protected ExecutionEntity execution;
    protected boolean localVariables = true;
    protected boolean deserializeValues = false;

    public ExecutionVariableSnapshotObserver(ExecutionEntity executionEntity) {
        this(executionEntity, true, false);
    }

    public ExecutionVariableSnapshotObserver(ExecutionEntity executionEntity, boolean localVariables, boolean deserializeValues) {
        this.execution = executionEntity;
        this.execution.addExecutionObserver(this);
        this.localVariables = localVariables;
        this.deserializeValues = deserializeValues;
    }

    @Override
    public void onClear(ExecutionEntity execution) {
        if (this.variableSnapshot == null) {
            this.variableSnapshot = this.getVariables(this.localVariables);
        }
    }

    public VariableMap getVariables() {
        if (this.variableSnapshot == null) {
            return this.getVariables(this.localVariables);
        }
        return this.variableSnapshot;
    }

    private VariableMap getVariables(boolean localVariables) {
        return this.localVariables ? this.execution.getVariablesLocalTyped(this.deserializeValues) : this.execution.getVariablesTyped(this.deserializeValues);
    }
}

