/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.db.DbEntity;
import org.cibseven.bpm.engine.impl.db.EnginePersistenceLogger;
import org.cibseven.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.cibseven.bpm.engine.impl.history.HistoryLevel;
import org.cibseven.bpm.engine.impl.persistence.AbstractManager;

public class AbstractHistoricManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
    protected boolean isHistoryEnabled = !this.historyLevel.equals(HistoryLevel.HISTORY_LEVEL_NONE);
    protected boolean isHistoryLevelFullEnabled = this.historyLevel.equals(HistoryLevel.HISTORY_LEVEL_FULL);

    protected void checkHistoryEnabled() {
        if (!this.isHistoryEnabled) {
            throw LOG.disabledHistoryException();
        }
    }

    public boolean isHistoryEnabled() {
        return this.isHistoryEnabled;
    }

    public boolean isHistoryLevelFullEnabled() {
        return this.isHistoryLevelFullEnabled;
    }

    protected static boolean isPerformUpdate(Set<String> entities, Class<?> entityClass) {
        return entities == null || entities.isEmpty() || entities.contains(entityClass.getName());
    }

    protected static boolean isPerformUpdateOnly(Set<String> entities, Class<?> entityClass) {
        return entities != null && entities.size() == 1 && entities.contains(entityClass.getName());
    }

    protected static void addOperation(DbOperation operation, Map<Class<? extends DbEntity>, DbOperation> operations) {
        operations.put(operation.getEntityType(), operation);
    }

    protected static void addOperation(Collection<DbOperation> newOperations, Map<Class<? extends DbEntity>, DbOperation> operations) {
        newOperations.forEach(operation -> operations.put(operation.getEntityType(), (DbOperation)operation));
    }
}

