/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration.validation.instance;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingVariableInstance;
import org.cibseven.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import org.cibseven.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.util.CollectionUtil;

public class VariableConflictActivityInstanceValidator
implements MigratingActivityInstanceValidator {
    @Override
    public void validate(MigratingActivityInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl instanceReport) {
        ScopeImpl sourceScope = migratingInstance.getSourceScope();
        ScopeImpl targetScope = migratingInstance.getTargetScope();
        if (migratingInstance.migrates()) {
            boolean becomesNonScope;
            boolean bl = becomesNonScope = sourceScope.isScope() && !targetScope.isScope();
            if (becomesNonScope) {
                Map<String, List<MigratingVariableInstance>> dependentVariablesByName = this.getMigratingVariableInstancesByName(migratingInstance);
                for (String variableName : dependentVariablesByName.keySet()) {
                    if (dependentVariablesByName.get(variableName).size() <= 1) continue;
                    instanceReport.addFailure("The variable '" + variableName + "' exists in both, this scope and concurrent local in the parent scope. Migrating to a non-scope activity would overwrite one of them.");
                }
            }
        }
    }

    protected Map<String, List<MigratingVariableInstance>> getMigratingVariableInstancesByName(MigratingActivityInstance activityInstance) {
        HashMap<String, List<MigratingVariableInstance>> result = new HashMap<String, List<MigratingVariableInstance>>();
        for (MigratingInstance migratingInstance : activityInstance.getMigratingDependentInstances()) {
            if (!(migratingInstance instanceof MigratingVariableInstance)) continue;
            MigratingVariableInstance migratingVariableInstance = (MigratingVariableInstance)migratingInstance;
            CollectionUtil.addToMapOfLists(result, migratingVariableInstance.getVariableName(), migratingVariableInstance);
        }
        return result;
    }
}

