/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration.instance;

import java.util.LinkedList;
import java.util.List;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingProcessElementInstanceTopDownWalker;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingScopeInstanceBranch;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.tree.FlowScopeWalker;
import org.cibseven.bpm.engine.impl.tree.ReferenceWalker;
import org.cibseven.bpm.engine.impl.tree.TreeVisitor;

public abstract class MigratingProcessElementInstanceVisitor
implements TreeVisitor<MigratingProcessElementInstanceTopDownWalker.MigrationContext> {
    @Override
    public void visit(MigratingProcessElementInstanceTopDownWalker.MigrationContext obj) {
        if (this.canMigrate(obj.processElementInstance)) {
            this.migrateProcessElementInstance(obj.processElementInstance, obj.scopeInstanceBranch);
        }
    }

    protected abstract boolean canMigrate(MigratingProcessElementInstance var1);

    protected abstract void instantiateScopes(MigratingScopeInstance var1, MigratingScopeInstanceBranch var2, List<ScopeImpl> var3);

    protected void migrateProcessElementInstance(MigratingProcessElementInstance migratingInstance, MigratingScopeInstanceBranch migratingInstanceBranch) {
        ScopeImpl parentActivityInstanceTargetScope;
        MigratingScopeInstance parentMigratingInstance = migratingInstance.getParent();
        ScopeImpl sourceScope = migratingInstance.getSourceScope();
        ScopeImpl targetScope = migratingInstance.getTargetScope();
        ScopeImpl targetFlowScope = targetScope.getFlowScope();
        ScopeImpl scopeImpl = parentActivityInstanceTargetScope = parentMigratingInstance != null ? parentMigratingInstance.getTargetScope() : null;
        if (sourceScope != sourceScope.getProcessDefinition() && targetFlowScope != parentActivityInstanceTargetScope) {
            List<ScopeImpl> nonExistingScopes = this.collectNonExistingFlowScopes(targetFlowScope, migratingInstanceBranch);
            ScopeImpl existingScope = nonExistingScopes.isEmpty() ? targetFlowScope : nonExistingScopes.get(0).getFlowScope();
            MigratingScopeInstance ancestorScopeInstance = migratingInstanceBranch.getInstance(existingScope);
            this.instantiateScopes(ancestorScopeInstance, migratingInstanceBranch, nonExistingScopes);
            MigratingScopeInstance targetFlowScopeInstance = migratingInstanceBranch.getInstance(targetFlowScope);
            migratingInstance.detachState();
            migratingInstance.attachState(targetFlowScopeInstance);
        }
        migratingInstance.migrateState();
        migratingInstance.migrateDependentEntities();
    }

    protected List<ScopeImpl> collectNonExistingFlowScopes(ScopeImpl scope, final MigratingScopeInstanceBranch migratingExecutionBranch) {
        FlowScopeWalker walker = new FlowScopeWalker(scope);
        final LinkedList<ScopeImpl> result = new LinkedList<ScopeImpl>();
        walker.addPreVisitor(new TreeVisitor<ScopeImpl>(){

            @Override
            public void visit(ScopeImpl obj) {
                result.add(0, obj);
            }
        });
        walker.walkWhile(new ReferenceWalker.WalkCondition<ScopeImpl>(){

            @Override
            public boolean isFulfilled(ScopeImpl element) {
                return migratingExecutionBranch.hasInstance(element);
            }
        });
        return result;
    }
}

