/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cibseven.bpm.engine.batch.Batch;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.migration.MigrateProcessInstanceCmd;
import org.cibseven.bpm.engine.impl.migration.batch.MigrateProcessInstanceBatchCmd;
import org.cibseven.bpm.engine.migration.MigrationPlan;
import org.cibseven.bpm.engine.migration.MigrationPlanExecutionBuilder;
import org.cibseven.bpm.engine.runtime.ProcessInstanceQuery;

public class MigrationPlanExecutionBuilderImpl
implements MigrationPlanExecutionBuilder {
    protected CommandExecutor commandExecutor;
    protected MigrationPlan migrationPlan;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    public MigrationPlanExecutionBuilderImpl(CommandExecutor commandExecutor, MigrationPlan migrationPlan) {
        this.commandExecutor = commandExecutor;
        this.migrationPlan = migrationPlan;
    }

    public MigrationPlan getMigrationPlan() {
        return this.migrationPlan;
    }

    @Override
    public MigrationPlanExecutionBuilder processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public MigrationPlanExecutionBuilder processInstanceIds(String ... processInstanceIds) {
        this.processInstanceIds = processInstanceIds == null ? Collections.emptyList() : Arrays.asList(processInstanceIds);
        return this;
    }

    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    @Override
    public MigrationPlanExecutionBuilder processInstanceQuery(ProcessInstanceQuery processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    public ProcessInstanceQuery getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    @Override
    public MigrationPlanExecutionBuilder skipCustomListeners() {
        this.skipCustomListeners = true;
        return this;
    }

    public boolean isSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    @Override
    public MigrationPlanExecutionBuilder skipIoMappings() {
        this.skipIoMappings = true;
        return this;
    }

    public boolean isSkipIoMappings() {
        return this.skipIoMappings;
    }

    @Override
    public void execute() {
        this.commandExecutor.execute(new MigrateProcessInstanceCmd(this, false));
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new MigrateProcessInstanceBatchCmd(this));
    }
}

