/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cibseven.bpm.engine.impl.bpmn.behavior.ConditionalEventBehavior;
import org.cibseven.bpm.engine.impl.migration.MigrationActivityMatcher;
import org.cibseven.bpm.engine.impl.migration.MigrationInstructionGenerator;
import org.cibseven.bpm.engine.impl.migration.validation.activity.MigrationActivityValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.CannotAddMultiInstanceInnerActivityValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.CannotRemoveMultiInstanceInnerActivityValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.UpdateEventTriggersValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructionImpl;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;

public class DefaultMigrationInstructionGenerator
implements MigrationInstructionGenerator {
    protected List<MigrationActivityValidator> migrationActivityValidators = new ArrayList<MigrationActivityValidator>();
    protected List<MigrationInstructionValidator> migrationInstructionValidators = new ArrayList<MigrationInstructionValidator>();
    protected MigrationActivityMatcher migrationActivityMatcher;

    public DefaultMigrationInstructionGenerator(MigrationActivityMatcher migrationActivityMatcher) {
        this.migrationActivityMatcher = migrationActivityMatcher;
    }

    @Override
    public MigrationInstructionGenerator migrationActivityValidators(List<MigrationActivityValidator> migrationActivityValidators) {
        this.migrationActivityValidators = migrationActivityValidators;
        return this;
    }

    @Override
    public MigrationInstructionGenerator migrationInstructionValidators(List<MigrationInstructionValidator> migrationInstructionValidators) {
        this.migrationInstructionValidators = new ArrayList<MigrationInstructionValidator>();
        for (MigrationInstructionValidator validator : migrationInstructionValidators) {
            if (validator instanceof CannotAddMultiInstanceInnerActivityValidator || validator instanceof CannotRemoveMultiInstanceInnerActivityValidator) continue;
            this.migrationInstructionValidators.add(validator);
        }
        return this;
    }

    @Override
    public ValidatingMigrationInstructions generate(ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition, boolean updateEventTriggers) {
        ValidatingMigrationInstructions migrationInstructions = new ValidatingMigrationInstructions();
        this.generate(sourceProcessDefinition, targetProcessDefinition, sourceProcessDefinition, targetProcessDefinition, migrationInstructions, updateEventTriggers);
        return migrationInstructions;
    }

    protected List<ValidatingMigrationInstruction> generateInstructionsForActivities(Collection<ActivityImpl> sourceActivities, Collection<ActivityImpl> targetActivities, boolean updateEventTriggers, ValidatingMigrationInstructions existingInstructions) {
        ArrayList<ValidatingMigrationInstruction> generatedInstructions = new ArrayList<ValidatingMigrationInstruction>();
        for (ActivityImpl sourceActivity : sourceActivities) {
            if (existingInstructions.containsInstructionForSourceScope(sourceActivity)) continue;
            for (ActivityImpl targetActivity : targetActivities) {
                if (!this.isValidActivity(sourceActivity) || !this.isValidActivity(targetActivity) || !this.migrationActivityMatcher.matchActivities(sourceActivity, targetActivity)) continue;
                boolean updateEventTriggersForInstruction = sourceActivity.getActivityBehavior() instanceof ConditionalEventBehavior || updateEventTriggers && UpdateEventTriggersValidator.definesPersistentEventTrigger(sourceActivity);
                ValidatingMigrationInstructionImpl generatedInstruction = new ValidatingMigrationInstructionImpl(sourceActivity, targetActivity, updateEventTriggersForInstruction);
                generatedInstructions.add(generatedInstruction);
            }
        }
        return generatedInstructions;
    }

    public void generate(ScopeImpl sourceScope, ScopeImpl targetScope, ProcessDefinitionImpl sourceProcessDefinition, ProcessDefinitionImpl targetProcessDefinition, ValidatingMigrationInstructions existingInstructions, boolean updateEventTriggers) {
        List<ValidatingMigrationInstruction> flowScopeInstructions = this.generateInstructionsForActivities(sourceScope.getActivities(), targetScope.getActivities(), updateEventTriggers, existingInstructions);
        existingInstructions.addAll(flowScopeInstructions);
        List<ValidatingMigrationInstruction> eventScopeInstructions = this.generateInstructionsForActivities(sourceScope.getEventActivities(), targetScope.getEventActivities(), updateEventTriggers, existingInstructions);
        existingInstructions.addAll(eventScopeInstructions);
        existingInstructions.filterWith(this.migrationInstructionValidators);
        for (ValidatingMigrationInstruction generatedInstruction : flowScopeInstructions) {
            if (!existingInstructions.contains(generatedInstruction)) continue;
            this.generate(generatedInstruction.getSourceActivity(), generatedInstruction.getTargetActivity(), sourceProcessDefinition, targetProcessDefinition, existingInstructions, updateEventTriggers);
        }
    }

    protected boolean isValidActivity(ActivityImpl activity) {
        for (MigrationActivityValidator migrationActivityValidator : this.migrationActivityValidators) {
            if (migrationActivityValidator.valid(activity)) continue;
            return false;
        }
        return true;
    }
}

