/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.management;

import java.util.Date;
import java.util.List;
import org.cibseven.bpm.engine.batch.Batch;
import org.cibseven.bpm.engine.history.HistoricProcessInstanceQuery;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.SetJobsRetriesByProcessBatchCmd;
import org.cibseven.bpm.engine.impl.cmd.CommandLogger;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.management.SetJobRetriesByProcessAsyncBuilder;
import org.cibseven.bpm.engine.runtime.ProcessInstanceQuery;

public class SetJobRetriesByProcessAsyncBuilderImpl
implements SetJobRetriesByProcessAsyncBuilder {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected List<String> processInstanceIds;
    protected ProcessInstanceQuery processInstanceQuery;
    protected HistoricProcessInstanceQuery historicProcessInstanceQuery;
    protected Integer retries;
    protected Date dueDate;
    protected boolean isDueDateSet;

    public SetJobRetriesByProcessAsyncBuilderImpl(CommandExecutor commandExecutor, int retries) {
        this.commandExecutor = commandExecutor;
        this.retries = retries;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder processInstanceQuery(ProcessInstanceQuery query) {
        this.processInstanceQuery = query;
        return this;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder historicProcessInstanceQuery(HistoricProcessInstanceQuery query) {
        this.historicProcessInstanceQuery = query;
        return this;
    }

    @Override
    public SetJobRetriesByProcessAsyncBuilder dueDate(Date dueDate) {
        this.dueDate = dueDate;
        this.isDueDateSet = true;
        return this;
    }

    @Override
    public Batch executeAsync() {
        this.validateParameters();
        return this.commandExecutor.execute(new SetJobsRetriesByProcessBatchCmd(this.processInstanceIds, this.processInstanceQuery, this.historicProcessInstanceQuery, this.retries, this.dueDate, this.isDueDateSet));
    }

    protected void validateParameters() {
        boolean isHistoricProcessInstanceQueryNull;
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
        EnsureUtil.ensureNotNull("retries", (Object)this.retries);
        boolean isProcessInstanceIdsNull = this.processInstanceIds == null || this.processInstanceIds.isEmpty();
        boolean isProcessInstanceQueryNull = this.processInstanceQuery == null;
        boolean bl = isHistoricProcessInstanceQueryNull = this.historicProcessInstanceQuery == null;
        if (isProcessInstanceIdsNull && isProcessInstanceQueryNull && isHistoricProcessInstanceQueryNull) {
            throw LOG.exceptionSettingJobRetriesAsyncNoProcessesSpecified();
        }
    }
}

