/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.history.parser;

import java.util.List;
import org.cibseven.bpm.engine.delegate.ExecutionListener;
import org.cibseven.bpm.engine.delegate.TaskListener;
import org.cibseven.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.cibseven.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.cibseven.bpm.engine.impl.history.HistoryLevel;
import org.cibseven.bpm.engine.impl.history.event.HistoryEventTypes;
import org.cibseven.bpm.engine.impl.history.parser.ActivityInstanceEndListener;
import org.cibseven.bpm.engine.impl.history.parser.ActivityInstanceStartListener;
import org.cibseven.bpm.engine.impl.history.parser.ActivityInstanceUpdateListener;
import org.cibseven.bpm.engine.impl.history.parser.ProcessInstanceEndListener;
import org.cibseven.bpm.engine.impl.history.parser.ProcessInstanceStartListener;
import org.cibseven.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.cibseven.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.pvm.process.TransitionImpl;
import org.cibseven.bpm.engine.impl.task.TaskDefinition;
import org.cibseven.bpm.engine.impl.util.xml.Element;
import org.cibseven.bpm.engine.impl.variable.VariableDeclaration;

public class HistoryParseListener
implements BpmnParseListener {
    protected ExecutionListener PROCESS_INSTANCE_START_LISTENER;
    protected ExecutionListener PROCESS_INSTANCE_END_LISTENER;
    protected ExecutionListener ACTIVITY_INSTANCE_START_LISTENER;
    protected ExecutionListener ACTIVITY_INSTANCE_END_LISTENER;
    protected TaskListener USER_TASK_ASSIGNMENT_HANDLER;
    protected TaskListener USER_TASK_ID_HANDLER;
    protected HistoryLevel historyLevel;

    public HistoryParseListener(HistoryEventProducer historyEventProducer) {
        this.initExecutionListeners(historyEventProducer);
    }

    protected void initExecutionListeners(HistoryEventProducer historyEventProducer) {
        this.PROCESS_INSTANCE_START_LISTENER = new ProcessInstanceStartListener(historyEventProducer);
        this.PROCESS_INSTANCE_END_LISTENER = new ProcessInstanceEndListener(historyEventProducer);
        this.ACTIVITY_INSTANCE_START_LISTENER = new ActivityInstanceStartListener(historyEventProducer);
        this.ACTIVITY_INSTANCE_END_LISTENER = new ActivityInstanceEndListener(historyEventProducer);
        this.USER_TASK_ID_HANDLER = this.USER_TASK_ASSIGNMENT_HANDLER = new ActivityInstanceUpdateListener(historyEventProducer);
    }

    @Override
    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
        this.ensureHistoryLevelInitialized();
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.PROCESS_INSTANCE_END, null)) {
            processDefinition.addBuiltInListener("end", this.PROCESS_INSTANCE_END_LISTENER);
        }
    }

    @Override
    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.ensureHistoryLevelInitialized();
        this.addActivityHandlers(activity);
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_CREATE, null)) {
            TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activity.getActivityBehavior()).getTaskDefinition();
            taskDefinition.addBuiltInTaskListener("assignment", this.USER_TASK_ASSIGNMENT_HANDLER);
            taskDefinition.addBuiltInTaskListener("create", this.USER_TASK_ID_HANDLER);
        }
    }

    @Override
    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl timerActivity) {
    }

    @Override
    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
    }

    @Override
    public void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity) {
    }

    @Override
    public void parseProperty(Element propertyElement, VariableDeclaration variableDeclaration, ActivityImpl activity) {
    }

    @Override
    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
    }

    @Override
    public void parseRootElement(Element rootElement, List<ProcessDefinitionEntity> processDefinitions) {
    }

    @Override
    public void parseBoundarySignalEventDefinition(Element signalEventDefinition, boolean interrupting, ActivityImpl signalActivity) {
    }

    @Override
    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateSignalCatchEventDefinition(Element signalEventDefinition, ActivityImpl signalActivity) {
    }

    @Override
    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl compensationActivity) {
    }

    @Override
    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        if (!activity.getProperty("type").equals("intermediateLinkCatch")) {
            this.addActivityHandlers(activity);
        }
    }

    @Override
    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addActivityHandlers(activity);
    }

    @Override
    public void parseIntermediateMessageCatchEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity) {
    }

    @Override
    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl messageActivity) {
    }

    @Override
    public void parseBoundaryEscalationEventDefinition(Element escalationEventDefinition, boolean interrupting, ActivityImpl boundaryEventActivity) {
    }

    @Override
    public void parseBoundaryConditionalEventDefinition(Element element, boolean interrupting, ActivityImpl conditionalActivity) {
    }

    @Override
    public void parseIntermediateConditionalEventDefinition(Element conditionalEventDefinition, ActivityImpl conditionalActivity) {
    }

    @Override
    public void parseConditionalStartEventForEventSubprocess(Element element, ActivityImpl conditionalActivity, boolean interrupting) {
    }

    @Override
    public void parseIoMapping(Element extensionElements, ActivityImpl activity, IoMapping inputOutput) {
    }

    protected void addActivityHandlers(ActivityImpl activity) {
        this.ensureHistoryLevelInitialized();
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_START, null)) {
            activity.addBuiltInListener("start", this.ACTIVITY_INSTANCE_START_LISTENER, 0);
        }
        if (this.historyLevel.isHistoryEventProduced(HistoryEventTypes.ACTIVITY_INSTANCE_END, null)) {
            activity.addBuiltInListener("end", this.ACTIVITY_INSTANCE_END_LISTENER);
        }
    }

    protected void ensureHistoryLevelInitialized() {
        if (this.historyLevel == null) {
            this.historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        }
    }
}

