/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.errorcode;

import java.sql.SQLException;
import org.cibseven.bpm.engine.OptimisticLockingException;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.cibseven.bpm.engine.impl.util.ExceptionUtil;

public interface ExceptionCodeProvider {
    default public Integer provideCode(ProcessEngineException processEngineException) {
        if (processEngineException instanceof OptimisticLockingException) {
            return BuiltinExceptionCode.OPTIMISTIC_LOCKING.getCode();
        }
        return null;
    }

    default public Integer provideCode(SQLException sqlException) {
        boolean deadlockDetected = ExceptionUtil.checkDeadlockException(sqlException);
        if (deadlockDetected) {
            return BuiltinExceptionCode.DEADLOCK.getCode();
        }
        boolean foreignKeyConstraintViolated = ExceptionUtil.checkForeignKeyConstraintViolation(sqlException);
        if (foreignKeyConstraintViolated) {
            return BuiltinExceptionCode.FOREIGN_KEY_CONSTRAINT_VIOLATION.getCode();
        }
        boolean columnSizeTooSmall = ExceptionUtil.checkValueTooLongException(sqlException);
        if (columnSizeTooSmall) {
            return BuiltinExceptionCode.COLUMN_SIZE_TOO_SMALL.getCode();
        }
        return null;
    }
}

