/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.digest._apacheCommonsCodec;

import java.io.UnsupportedEncodingException;

public class StringUtils {
    public static final String UTF_8 = "UTF-8";

    public static String newString(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    public static String newStringUtf8(byte[] bytes) {
        return StringUtils.newString(bytes, UTF_8);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.getBytesUnchecked(string, UTF_8);
    }

    public static byte[] getBytesUnchecked(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw StringUtils.newIllegalStateException(charsetName, e);
        }
    }

    private static IllegalStateException newIllegalStateException(String charsetName, UnsupportedEncodingException e) {
        return new IllegalStateException(charsetName + ": " + e);
    }
}

