/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.context;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import org.cibseven.bpm.application.InvocationContext;
import org.cibseven.bpm.application.ProcessApplicationInterface;
import org.cibseven.bpm.application.ProcessApplicationReference;
import org.cibseven.bpm.application.ProcessApplicationUnavailableException;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.cibseven.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.cibseven.bpm.engine.impl.context.BpmnExecutionContext;
import org.cibseven.bpm.engine.impl.context.CaseExecutionContext;
import org.cibseven.bpm.engine.impl.context.CoreExecutionContext;
import org.cibseven.bpm.engine.impl.context.ExecutionContext;
import org.cibseven.bpm.engine.impl.context.ProcessApplicationClassloaderInterceptor;
import org.cibseven.bpm.engine.impl.core.instance.CoreExecution;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.cibseven.bpm.engine.impl.jobexecutor.JobExecutorContext;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;

public class Context {
    protected static ThreadLocal<Deque<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<CommandInvocationContext>> commandInvocationContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<CoreExecutionContext<? extends CoreExecution>>> executionContextStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<JobExecutorContext> jobExecutorContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Deque<ProcessApplicationReference>> processApplicationContext = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Deque stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static CommandInvocationContext getCommandInvocationContext() {
        Deque stack = Context.getStack(commandInvocationContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandInvocationContext)stack.peek();
    }

    public static void setCommandInvocationContext(CommandInvocationContext commandInvocationContext) {
        Context.getStack(commandInvocationContextThreadLocal).push(commandInvocationContext);
    }

    public static void removeCommandInvocationContext() {
        Deque stack = Context.getStack(commandInvocationContextThreadLocal);
        CommandInvocationContext currentContext = (CommandInvocationContext)stack.pop();
        if (stack.isEmpty()) {
            if (Context.getJobExecutorContext() == null) {
                currentContext.getProcessDataContext().clearMdc();
                currentContext.getProcessDataContext().restoreExternalMDCProperties();
            }
        } else {
            ((CommandInvocationContext)stack.peek()).getProcessDataContext().updateMdcFromCurrentValues();
        }
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Deque stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)stack.peek();
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push(processEngineConfiguration);
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    @Deprecated
    public static ExecutionContext getExecutionContext() {
        return Context.getBpmnExecutionContext();
    }

    public static BpmnExecutionContext getBpmnExecutionContext() {
        return (BpmnExecutionContext)Context.getCoreExecutionContext();
    }

    public static CaseExecutionContext getCaseExecutionContext() {
        return (CaseExecutionContext)Context.getCoreExecutionContext();
    }

    public static CoreExecutionContext<? extends CoreExecution> getCoreExecutionContext() {
        Deque stack = Context.getStack(executionContextStackThreadLocal);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return (CoreExecutionContext)stack.peek();
    }

    public static void setExecutionContext(ExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new BpmnExecutionContext(execution));
    }

    public static void setExecutionContext(CaseExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new CaseExecutionContext(execution));
    }

    public static void removeExecutionContext() {
        Context.getStack(executionContextStackThreadLocal).pop();
    }

    protected static <T> Deque<T> getStack(ThreadLocal<Deque<T>> threadLocal) {
        Deque<T> stack = threadLocal.get();
        if (stack == null) {
            stack = new ArrayDeque<T>();
            threadLocal.set(stack);
        }
        return stack;
    }

    public static JobExecutorContext getJobExecutorContext() {
        return jobExecutorContextThreadLocal.get();
    }

    public static void setJobExecutorContext(JobExecutorContext jobExecutorContext) {
        jobExecutorContextThreadLocal.set(jobExecutorContext);
    }

    public static void removeJobExecutorContext() {
        jobExecutorContextThreadLocal.remove();
    }

    public static ProcessApplicationReference getCurrentProcessApplication() {
        Deque stack = Context.getStack(processApplicationContext);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessApplicationReference)stack.peek();
    }

    public static void setCurrentProcessApplication(ProcessApplicationReference reference) {
        Deque stack = Context.getStack(processApplicationContext);
        stack.push(reference);
    }

    public static void removeCurrentProcessApplication() {
        Deque stack = Context.getStack(processApplicationContext);
        stack.pop();
    }

    public static <T> T executeWithinProcessApplication(Callable<T> callback, ProcessApplicationReference processApplicationReference) {
        return Context.executeWithinProcessApplication(callback, processApplicationReference, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeWithinProcessApplication(Callable<T> callback, ProcessApplicationReference processApplicationReference, InvocationContext invocationContext) {
        String paName = processApplicationReference.getName();
        try {
            ProcessApplicationInterface processApplication = processApplicationReference.getProcessApplication();
            Context.setCurrentProcessApplication(processApplicationReference);
            try {
                ProcessApplicationClassloaderInterceptor<T> wrappedCallback = new ProcessApplicationClassloaderInterceptor<T>(callback);
                T t = processApplication.execute(wrappedCallback, invocationContext);
                return t;
            }
            catch (Exception e) {
                if (e.getCause() == null) throw new ProcessEngineException("Unexpected exeption while executing within process application ", e);
                if (!(e.getCause() instanceof RuntimeException)) throw new ProcessEngineException("Unexpected exeption while executing within process application ", e);
                throw (RuntimeException)e.getCause();
            }
            finally {
                Context.removeCurrentProcessApplication();
            }
        }
        catch (ProcessApplicationUnavailableException e) {
            throw new ProcessEngineException("Cannot switch to process application '" + paName + "' for execution: " + e.getMessage(), e);
        }
    }
}

