/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmmn.handler;

import java.util.List;
import org.cibseven.bpm.engine.impl.cmmn.behavior.ProcessOrCaseTaskActivityBehavior;
import org.cibseven.bpm.engine.impl.cmmn.handler.CallingTaskItemHandler;
import org.cibseven.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.cibseven.bpm.engine.impl.core.model.CallableElement;
import org.cibseven.bpm.engine.impl.core.model.CallableElementParameter;
import org.cibseven.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.cibseven.bpm.engine.impl.el.ExpressionManager;
import org.cibseven.bpm.model.cmmn.instance.CmmnElement;
import org.cibseven.bpm.model.cmmn.instance.PlanItemDefinition;
import org.cibseven.bpm.model.cmmn.instance.camunda.CamundaIn;
import org.cibseven.bpm.model.cmmn.instance.camunda.CamundaOut;

public abstract class ProcessOrCaseTaskItemHandler
extends CallingTaskItemHandler {
    @Override
    protected CallableElement createCallableElement() {
        return new CallableElement();
    }

    @Override
    protected void initializeCallableElement(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        super.initializeCallableElement(element, activity, context);
        ProcessOrCaseTaskActivityBehavior behavior = (ProcessOrCaseTaskActivityBehavior)activity.getActivityBehavior();
        CallableElement callableElement = behavior.getCallableElement();
        this.initializeInputParameter(element, activity, context, callableElement);
        this.initializeOutputParameter(element, activity, context, callableElement);
    }

    protected void initializeInputParameter(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        List<CamundaIn> inputs = this.getInputs(element);
        for (CamundaIn input : inputs) {
            String variables;
            String businessKey = input.getCamundaBusinessKey();
            if (businessKey != null && !businessKey.isEmpty()) {
                ParameterValueProvider businessKeyValueProvider = this.createParameterValueProvider(businessKey, expressionManager);
                callableElement.setBusinessKeyValueProvider(businessKeyValueProvider);
                continue;
            }
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addInput(parameter);
            if (input.getCamundaLocal()) {
                parameter.setReadLocal(true);
            }
            if ("all".equals(variables = input.getCamundaVariables())) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = input.getCamundaSource();
            if (source == null || source.isEmpty()) {
                source = input.getCamundaSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = input.getCamundaTarget();
            parameter.setTarget(target);
        }
    }

    protected void initializeOutputParameter(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CallableElement callableElement) {
        ExpressionManager expressionManager = context.getExpressionManager();
        List<CamundaOut> outputs = this.getOutputs(element);
        for (CamundaOut output : outputs) {
            CallableElementParameter parameter = new CallableElementParameter();
            callableElement.addOutput(parameter);
            String variables = output.getCamundaVariables();
            if ("all".equals(variables)) {
                parameter.setAllVariables(true);
                continue;
            }
            String source = output.getCamundaSource();
            if (source == null || source.isEmpty()) {
                source = output.getCamundaSourceExpression();
            }
            ParameterValueProvider sourceValueProvider = this.createParameterValueProvider(source, expressionManager);
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = output.getCamundaTarget();
            parameter.setTarget(target);
        }
    }

    protected List<CamundaIn> getInputs(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return this.queryExtensionElementsByClass((CmmnElement)definition, CamundaIn.class);
    }

    protected List<CamundaOut> getOutputs(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return this.queryExtensionElementsByClass((CmmnElement)definition, CamundaOut.class);
    }
}

