/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.engine.exception.NotFoundException;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.SignalEventReceivedBuilderImpl;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.CommandLogger;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.cibseven.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.cibseven.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.cibseven.bpm.engine.impl.pvm.PvmProcessInstance;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final SignalEventReceivedBuilderImpl builder;

    public SignalEventReceivedCmd(SignalEventReceivedBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String signalName = this.builder.getSignalName();
        String executionId = this.builder.getExecutionId();
        if (executionId == null) {
            this.sendSignal(commandContext, signalName);
        } else {
            this.sendSignalToExecution(commandContext, signalName, executionId);
        }
        return null;
    }

    protected void sendSignal(CommandContext commandContext, String signalName) {
        List<EventSubscriptionEntity> signalEventSubscriptions = this.findSignalEventSubscriptions(commandContext, signalName);
        List<EventSubscriptionEntity> catchSignalEventSubscription = this.filterIntermediateSubscriptions(signalEventSubscriptions);
        List<EventSubscriptionEntity> startSignalEventSubscriptions = this.filterStartSubscriptions(signalEventSubscriptions);
        Map<String, ProcessDefinitionEntity> processDefinitions = this.getProcessDefinitionsOfSubscriptions(startSignalEventSubscriptions);
        this.checkAuthorizationOfCatchSignals(commandContext, catchSignalEventSubscription);
        this.checkAuthorizationOfStartSignals(commandContext, startSignalEventSubscriptions, processDefinitions);
        this.notifyExecutions(catchSignalEventSubscription);
        this.startProcessInstances(startSignalEventSubscriptions, processDefinitions);
    }

    protected List<EventSubscriptionEntity> findSignalEventSubscriptions(CommandContext commandContext, String signalName) {
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        if (this.builder.isTenantIdSet()) {
            return eventSubscriptionManager.findSignalEventSubscriptionsByEventNameAndTenantId(signalName, this.builder.getTenantId());
        }
        return eventSubscriptionManager.findSignalEventSubscriptionsByEventName(signalName);
    }

    protected Map<String, ProcessDefinitionEntity> getProcessDefinitionsOfSubscriptions(List<EventSubscriptionEntity> startSignalEventSubscriptions) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        HashMap<String, ProcessDefinitionEntity> processDefinitions = new HashMap<String, ProcessDefinitionEntity>();
        for (EventSubscriptionEntity eventSubscription : startSignalEventSubscriptions) {
            String processDefinitionId = eventSubscription.getConfiguration();
            EnsureUtil.ensureNotNull("Configuration of signal start event subscription '" + eventSubscription.getId() + "' contains no process definition id.", (Object)processDefinitionId);
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null || processDefinition.isSuspended()) continue;
            processDefinitions.put(eventSubscription.getId(), processDefinition);
        }
        return processDefinitions;
    }

    protected void sendSignalToExecution(CommandContext commandContext, String signalName, String executionId) {
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity execution = executionManager.findExecutionById(executionId);
        EnsureUtil.ensureNotNull("Cannot find execution with id '" + executionId + "'", "execution", (Object)execution);
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        List<EventSubscriptionEntity> signalEvents = eventSubscriptionManager.findSignalEventSubscriptionsByNameAndExecution(signalName, executionId);
        EnsureUtil.ensureNotEmpty(NotFoundException.class, "Execution '" + executionId + "' has not subscribed to a signal event with name '" + signalName + "'.", signalEvents);
        this.checkAuthorizationOfCatchSignals(commandContext, signalEvents);
        this.notifyExecutions(signalEvents);
    }

    protected void checkAuthorizationOfCatchSignals(CommandContext commandContext, List<EventSubscriptionEntity> catchSignalEventSubscription) {
        for (EventSubscriptionEntity event : catchSignalEventSubscription) {
            String processInstanceId = event.getProcessInstanceId();
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateProcessInstanceById(processInstanceId);
            }
        }
    }

    private void checkAuthorizationOfStartSignals(CommandContext commandContext, List<EventSubscriptionEntity> startSignalEventSubscriptions, Map<String, ProcessDefinitionEntity> processDefinitions) {
        for (EventSubscriptionEntity signalStartEventSubscription : startSignalEventSubscriptions) {
            ProcessDefinitionEntity processDefinition = processDefinitions.get(signalStartEventSubscription.getId());
            if (processDefinition == null) continue;
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkCreateProcessInstance(processDefinition);
            }
        }
    }

    private void notifyExecutions(List<EventSubscriptionEntity> catchSignalEventSubscription) {
        for (EventSubscriptionEntity signalEventSubscriptionEntity : catchSignalEventSubscription) {
            if (!this.isActiveEventSubscription(signalEventSubscriptionEntity)) continue;
            signalEventSubscriptionEntity.eventReceived(this.builder.getVariables(), false);
        }
    }

    private boolean isActiveEventSubscription(EventSubscriptionEntity signalEventSubscriptionEntity) {
        ExecutionEntity execution = signalEventSubscriptionEntity.getExecution();
        return !execution.isEnded() && !execution.isCanceled();
    }

    private void startProcessInstances(List<EventSubscriptionEntity> startSignalEventSubscriptions, Map<String, ProcessDefinitionEntity> processDefinitions) {
        for (EventSubscriptionEntity signalStartEventSubscription : startSignalEventSubscriptions) {
            ProcessDefinitionEntity processDefinition = processDefinitions.get(signalStartEventSubscription.getId());
            if (processDefinition == null) continue;
            ActivityImpl signalStartEvent = processDefinition.findActivity(signalStartEventSubscription.getActivityId());
            PvmProcessInstance processInstance = processDefinition.createProcessInstanceForInitial(signalStartEvent);
            processInstance.start((Map<String, Object>)this.builder.getVariables());
        }
    }

    protected List<EventSubscriptionEntity> filterIntermediateSubscriptions(List<EventSubscriptionEntity> subscriptions) {
        ArrayList<EventSubscriptionEntity> result = new ArrayList<EventSubscriptionEntity>();
        for (EventSubscriptionEntity subscription : subscriptions) {
            if (subscription.getExecutionId() == null) continue;
            result.add(subscription);
        }
        return result;
    }

    protected List<EventSubscriptionEntity> filterStartSubscriptions(List<EventSubscriptionEntity> subscriptions) {
        ArrayList<EventSubscriptionEntity> result = new ArrayList<EventSubscriptionEntity>();
        for (EventSubscriptionEntity subscription : subscriptions) {
            if (subscription.getExecutionId() != null) continue;
            result.add(subscription);
        }
        return result;
    }
}

