/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.util.Collection;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.AbstractRemoveVariableCmd;
import org.cibseven.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.PropertyChange;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;

public class RemoveExecutionVariablesCmd
extends AbstractRemoveVariableCmd {
    private static final long serialVersionUID = 1L;

    public RemoveExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        super(executionId, variableNames, isLocal);
    }

    @Override
    protected ExecutionEntity getEntity() {
        EnsureUtil.ensureNotNull("executionId", (Object)this.entityId);
        ExecutionEntity execution = this.commandContext.getExecutionManager().findExecutionById(this.entityId);
        EnsureUtil.ensureNotNull("execution " + this.entityId + " doesn't exist", "execution", (Object)execution);
        this.checkRemoveExecutionVariables(execution);
        return execution;
    }

    @Override
    protected ExecutionEntity getContextExecution() {
        return this.getEntity();
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        ExecutionEntity execution = (ExecutionEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), execution.getId(), null, PropertyChange.EMPTY_CHANGE);
    }

    protected void checkRemoveExecutionVariables(ExecutionEntity execution) {
        for (CommandChecker checker : this.commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceVariables(execution);
        }
    }
}

