/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.ByteArrayEntity;

public class GetTaskAttachmentContentCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;
    protected String taskId;

    public GetTaskAttachmentContentCmd(String taskId, String attachmentId) {
        this.attachmentId = attachmentId;
        this.taskId = taskId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        AttachmentEntity attachment = (AttachmentEntity)commandContext.getAttachmentManager().findAttachmentByTaskIdAndAttachmentId(this.taskId, this.attachmentId);
        if (attachment == null) {
            return null;
        }
        String contentId = attachment.getContentId();
        if (contentId == null) {
            return null;
        }
        ByteArrayEntity byteArray = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, contentId);
        byte[] bytes = byteArray.getBytes();
        return new ByteArrayInputStream(bytes);
    }
}

