/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.variable.value.TypedValue;

public class GetExecutionVariableTypedCmd<T extends TypedValue>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;
    protected boolean deserializeValue;

    public GetExecutionVariableTypedCmd(String executionId, String variableName, boolean isLocal, boolean deserializeValue) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
        this.deserializeValue = deserializeValue;
    }

    @Override
    public T execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("executionId", (Object)this.executionId);
        EnsureUtil.ensureNotNull("variableName", (Object)this.variableName);
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        EnsureUtil.ensureNotNull("execution " + this.executionId + " doesn't exist", "execution", (Object)execution);
        this.checkGetExecutionVariableTyped(execution, commandContext);
        Object value = this.isLocal ? execution.getVariableLocalTyped(this.variableName, this.deserializeValue) : execution.getVariableTyped(this.variableName, this.deserializeValue);
        return value;
    }

    public void checkGetExecutionVariableTyped(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessInstanceVariable(execution);
        }
    }
}

