/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.bpmn.diagram.ProcessDiagramLayoutFactory;
import org.cibseven.bpm.engine.impl.cfg.CommandChecker;
import org.cibseven.bpm.engine.impl.cmd.GetDeploymentProcessDiagramCmd;
import org.cibseven.bpm.engine.impl.cmd.GetDeploymentProcessModelCmd;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.interceptor.Command;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.cibseven.bpm.engine.repository.DiagramLayout;

public class GetDeploymentProcessDiagramLayoutCmd
implements Command<DiagramLayout>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetDeploymentProcessDiagramLayoutCmd(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public DiagramLayout execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        InputStream processModelStream = commandContext.runWithoutAuthorization(new GetDeploymentProcessModelCmd(this.processDefinitionId));
        InputStream processDiagramStream = commandContext.runWithoutAuthorization(new GetDeploymentProcessDiagramCmd(this.processDefinitionId));
        return new ProcessDiagramLayoutFactory().getProcessDiagramLayout(processModelStream, processDiagramStream);
    }
}

